/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.io.IOException;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.CX;
import org.apache.pdfbox.jbig2.decoder.mmr.MMRDecompressor;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

public class GenericRegion
implements Region {
    private final Logger log = LoggerFactory.getLogger(GenericRegion.class);
    private SubInputStream subInputStream;
    private long dataHeaderOffset;
    private long dataHeaderLength;
    private long dataOffset;
    private long dataLength;
    private RegionSegmentInformation regionInfo;
    private boolean useExtTemplates;
    private boolean isTPGDon;
    private byte gbTemplate;
    private boolean isMMREncoded;
    private short[] gbAtX;
    private short[] gbAtY;
    private boolean[] gbAtOverride;
    private boolean override;
    private Bitmap regionBitmap;
    private ArithmeticDecoder arithDecoder;
    private CX cx;
    private MMRDecompressor mmrDecompressor;

    public GenericRegion() {
    }

    public GenericRegion(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    private void parseHeader() throws IOException, InvalidHeaderValueException {
        this.regionInfo.parseHeader();
        this.subInputStream.readBits(3);
        if (this.subInputStream.readBit() == 1) {
            this.useExtTemplates = true;
        }
        if (this.subInputStream.readBit() == 1) {
            this.isTPGDon = true;
        }
        this.gbTemplate = (byte)(this.subInputStream.readBits(2) & 0xFL);
        if (this.subInputStream.readBit() == 1) {
            this.isMMREncoded = true;
        }
        if (!this.isMMREncoded) {
            int n2 = this.gbTemplate == 0 ? (this.useExtTemplates ? 12 : 4) : 1;
            this.readGbAtPixels(n2);
        }
        this.computeSegmentDataStructure();
        this.checkInput();
    }

    private void readGbAtPixels(int n2) throws IOException {
        this.gbAtX = new short[n2];
        this.gbAtY = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.gbAtX[i2] = this.subInputStream.readByte();
            this.gbAtY[i2] = this.subInputStream.readByte();
        }
    }

    private void computeSegmentDataStructure() throws IOException {
        this.dataOffset = this.subInputStream.getStreamPosition();
        this.dataHeaderLength = this.dataOffset - this.dataHeaderOffset;
        this.dataLength = this.subInputStream.length() - this.dataHeaderLength;
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (this.isMMREncoded && this.gbTemplate != 0) {
            this.log.info("gbTemplate should contain the value 0");
        }
    }

    @Override
    public Bitmap getRegionBitmap() throws IOException {
        if (null == this.regionBitmap) {
            if (this.isMMREncoded) {
                if (null == this.mmrDecompressor) {
                    this.mmrDecompressor = new MMRDecompressor(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight(), new SubInputStream(this.subInputStream, this.dataOffset, this.dataLength));
                }
                this.regionBitmap = this.mmrDecompressor.uncompress();
            } else {
                this.updateOverrideFlags();
                int n2 = 0;
                if (this.arithDecoder == null) {
                    this.arithDecoder = new ArithmeticDecoder(this.subInputStream);
                }
                if (this.cx == null) {
                    this.cx = new CX(65536, 1);
                }
                this.regionBitmap = new Bitmap(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight());
                int n3 = this.regionBitmap.getWidth() + 7 & 0xFFFFFFF8;
                for (int i2 = 0; i2 < this.regionBitmap.getHeight(); ++i2) {
                    if (this.isTPGDon) {
                        n2 ^= this.decodeSLTP();
                    }
                    if (n2 == 1) {
                        if (i2 <= 0) continue;
                        this.copyLineAbove(i2);
                        continue;
                    }
                    this.decodeLine(i2, this.regionBitmap.getWidth(), this.regionBitmap.getRowStride(), n3);
                }
            }
        }
        return this.regionBitmap;
    }

    private int decodeSLTP() throws IOException {
        switch (this.gbTemplate) {
            case 0: {
                this.cx.setIndex(39717);
                break;
            }
            case 1: {
                this.cx.setIndex(1941);
                break;
            }
            case 2: {
                this.cx.setIndex(229);
                break;
            }
            case 3: {
                this.cx.setIndex(405);
            }
        }
        return this.arithDecoder.decode(this.cx);
    }

    private void decodeLine(int n2, int n3, int n4, int n5) throws IOException {
        int n6 = this.regionBitmap.getByteIndex(0, n2);
        int n7 = n6 - n4;
        switch (this.gbTemplate) {
            case 0: {
                if (!this.useExtTemplates) {
                    this.decodeTemplate0a(n2, n3, n4, n5, n6, n7);
                    break;
                }
                this.decodeTemplate0b(n2, n3, n4, n5, n6, n7);
                break;
            }
            case 1: {
                this.decodeTemplate1(n2, n3, n4, n5, n6, n7);
                break;
            }
            case 2: {
                this.decodeTemplate2(n2, n3, n4, n5, n6, n7);
                break;
            }
            case 3: {
                this.decodeTemplate3(n2, n3, n4, n5, n6, n7);
            }
        }
    }

    private void copyLineAbove(int n2) {
        int n3 = n2 * this.regionBitmap.getRowStride();
        int n4 = n3 - this.regionBitmap.getRowStride();
        for (int i2 = 0; i2 < this.regionBitmap.getRowStride(); ++i2) {
            this.regionBitmap.setByte(n3++, this.regionBitmap.getByte(n4++));
        }
    }

    private void decodeTemplate0a(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (n2 >= 1) {
            n9 = this.regionBitmap.getByteAsInteger(n7);
        }
        if (n2 >= 2) {
            n10 = this.regionBitmap.getByteAsInteger(n7 - n4) << 6;
        }
        int n11 = n9 & 0xF0 | n10 & 0x3800;
        int n12 = 0;
        while (n12 < n5) {
            int n13;
            byte by = 0;
            int n14 = n12 + 8;
            int n15 = n13 = n3 - n12 > 8 ? 8 : n3 - n12;
            if (n2 > 0) {
                n9 = n9 << 8 | (n14 < n3 ? this.regionBitmap.getByteAsInteger(n7 + 1) : 0);
            }
            if (n2 > 1) {
                n10 = n10 << 8 | (n14 < n3 ? this.regionBitmap.getByteAsInteger(n7 - n4 + 1) << 6 : 0);
            }
            for (int i2 = 0; i2 < n13; ++i2) {
                int n16 = 7 - i2;
                if (this.override) {
                    n8 = this.overrideAtTemplate0a(n11, n12 + i2, n2, by, i2, n16);
                    this.cx.setIndex(n8);
                } else {
                    this.cx.setIndex(n11);
                }
                int n17 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n17 << n16);
                n11 = (n11 & 0x7BF7) << 1 | n17 | n9 >> n16 & 0x10 | n10 >> n16 & 0x800;
            }
            this.regionBitmap.setByte(n6++, by);
            ++n7;
            n12 = n14;
        }
    }

    private void decodeTemplate0b(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (n2 >= 1) {
            n9 = this.regionBitmap.getByteAsInteger(n7);
        }
        if (n2 >= 2) {
            n10 = this.regionBitmap.getByteAsInteger(n7 - n4) << 6;
        }
        int n11 = n9 & 0xF0 | n10 & 0x3800;
        int n12 = 0;
        while (n12 < n5) {
            int n13;
            byte by = 0;
            int n14 = n12 + 8;
            int n15 = n13 = n3 - n12 > 8 ? 8 : n3 - n12;
            if (n2 > 0) {
                n9 = n9 << 8 | (n14 < n3 ? this.regionBitmap.getByteAsInteger(n7 + 1) : 0);
            }
            if (n2 > 1) {
                n10 = n10 << 8 | (n14 < n3 ? this.regionBitmap.getByteAsInteger(n7 - n4 + 1) << 6 : 0);
            }
            for (int i2 = 0; i2 < n13; ++i2) {
                int n16 = 7 - i2;
                if (this.override) {
                    n8 = this.overrideAtTemplate0b(n11, n12 + i2, n2, by, i2, n16);
                    this.cx.setIndex(n8);
                } else {
                    this.cx.setIndex(n11);
                }
                int n17 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n17 << n16);
                n11 = (n11 & 0x7BF7) << 1 | n17 | n9 >> n16 & 0x10 | n10 >> n16 & 0x800;
            }
            this.regionBitmap.setByte(n6++, by);
            ++n7;
            n12 = n14;
        }
    }

    private void decodeTemplate1(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = 0;
        int n9 = 0;
        if (n2 >= 1) {
            n8 = this.regionBitmap.getByteAsInteger(n7);
        }
        if (n2 >= 2) {
            n9 = this.regionBitmap.getByteAsInteger(n7 - n4) << 5;
        }
        int n10 = n8 >> 1 & 0x1F8 | n9 >> 1 & 0x1E00;
        int n11 = 0;
        while (n11 < n5) {
            int n12;
            byte by = 0;
            int n13 = n11 + 8;
            int n14 = n12 = n3 - n11 > 8 ? 8 : n3 - n11;
            if (n2 >= 1) {
                n8 = n8 << 8 | (n13 < n3 ? this.regionBitmap.getByteAsInteger(n7 + 1) : 0);
            }
            if (n2 >= 2) {
                n9 = n9 << 8 | (n13 < n3 ? this.regionBitmap.getByteAsInteger(n7 - n4 + 1) << 5 : 0);
            }
            for (int i2 = 0; i2 < n12; ++i2) {
                if (this.override) {
                    int n15 = this.overrideAtTemplate1(n10, n11 + i2, n2, by, i2);
                    this.cx.setIndex(n15);
                } else {
                    this.cx.setIndex(n10);
                }
                int n16 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n16 << 7 - i2);
                int n17 = 8 - i2;
                n10 = (n10 & 0xEFB) << 1 | n16 | n8 >> n17 & 8 | n9 >> n17 & 0x200;
            }
            this.regionBitmap.setByte(n6++, by);
            ++n7;
            n11 = n13;
        }
    }

    private void decodeTemplate2(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = 0;
        int n9 = 0;
        if (n2 >= 1) {
            n8 = this.regionBitmap.getByteAsInteger(n7);
        }
        if (n2 >= 2) {
            n9 = this.regionBitmap.getByteAsInteger(n7 - n4) << 4;
        }
        int n10 = n8 >> 3 & 0x7C | n9 >> 3 & 0x380;
        int n11 = 0;
        while (n11 < n5) {
            int n12;
            byte by = 0;
            int n13 = n11 + 8;
            int n14 = n12 = n3 - n11 > 8 ? 8 : n3 - n11;
            if (n2 >= 1) {
                n8 = n8 << 8 | (n13 < n3 ? this.regionBitmap.getByteAsInteger(n7 + 1) : 0);
            }
            if (n2 >= 2) {
                n9 = n9 << 8 | (n13 < n3 ? this.regionBitmap.getByteAsInteger(n7 - n4 + 1) << 4 : 0);
            }
            for (int i2 = 0; i2 < n12; ++i2) {
                if (this.override) {
                    int n15 = this.overrideAtTemplate2(n10, n11 + i2, n2, by, i2);
                    this.cx.setIndex(n15);
                } else {
                    this.cx.setIndex(n10);
                }
                int n16 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n16 << 7 - i2);
                int n17 = 10 - i2;
                n10 = (n10 & 0x1BD) << 1 | n16 | n8 >> n17 & 4 | n9 >> n17 & 0x80;
            }
            this.regionBitmap.setByte(n6++, by);
            ++n7;
            n11 = n13;
        }
    }

    private void decodeTemplate3(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = 0;
        if (n2 >= 1) {
            n8 = this.regionBitmap.getByteAsInteger(n7);
        }
        int n9 = n8 >> 1 & 0x70;
        int n10 = 0;
        while (n10 < n5) {
            int n11;
            byte by = 0;
            int n12 = n10 + 8;
            int n13 = n11 = n3 - n10 > 8 ? 8 : n3 - n10;
            if (n2 >= 1) {
                n8 = n8 << 8 | (n12 < n3 ? this.regionBitmap.getByteAsInteger(n7 + 1) : 0);
            }
            for (int i2 = 0; i2 < n11; ++i2) {
                if (this.override) {
                    int n14 = this.overrideAtTemplate3(n9, n10 + i2, n2, by, i2);
                    this.cx.setIndex(n14);
                } else {
                    this.cx.setIndex(n9);
                }
                int n15 = this.arithDecoder.decode(this.cx);
                by = (byte)(by | n15 << 7 - i2);
                n9 = (n9 & 0x1F7) << 1 | n15 | n8 >> 8 - i2 & 0x10;
            }
            this.regionBitmap.setByte(n6++, by);
            ++n7;
            n10 = n12;
        }
    }

    private void updateOverrideFlags() {
        if (this.gbAtX == null || this.gbAtY == null) {
            this.log.info("AT pixels not set");
            return;
        }
        if (this.gbAtX.length != this.gbAtY.length) {
            this.log.info("AT pixel inconsistent, amount of x pixels: " + this.gbAtX.length + ", amount of y pixels:" + this.gbAtY.length);
            return;
        }
        this.gbAtOverride = new boolean[this.gbAtX.length];
        switch (this.gbTemplate) {
            case 0: {
                if (!this.useExtTemplates) {
                    if (this.gbAtX[0] != 3 || this.gbAtY[0] != -1) {
                        this.setOverrideFlag(0);
                    }
                    if (this.gbAtX[1] != -3 || this.gbAtY[1] != -1) {
                        this.setOverrideFlag(1);
                    }
                    if (this.gbAtX[2] != 2 || this.gbAtY[2] != -2) {
                        this.setOverrideFlag(2);
                    }
                    if (this.gbAtX[3] == -2 && this.gbAtY[3] == -2) break;
                    this.setOverrideFlag(3);
                    break;
                }
                if (this.gbAtX[0] != -2 || this.gbAtY[0] != 0) {
                    this.setOverrideFlag(0);
                }
                if (this.gbAtX[1] != 0 || this.gbAtY[1] != -2) {
                    this.setOverrideFlag(1);
                }
                if (this.gbAtX[2] != -2 || this.gbAtY[2] != -1) {
                    this.setOverrideFlag(2);
                }
                if (this.gbAtX[3] != -1 || this.gbAtY[3] != -2) {
                    this.setOverrideFlag(3);
                }
                if (this.gbAtX[4] != 1 || this.gbAtY[4] != -2) {
                    this.setOverrideFlag(4);
                }
                if (this.gbAtX[5] != 2 || this.gbAtY[5] != -1) {
                    this.setOverrideFlag(5);
                }
                if (this.gbAtX[6] != -3 || this.gbAtY[6] != 0) {
                    this.setOverrideFlag(6);
                }
                if (this.gbAtX[7] != -4 || this.gbAtY[7] != 0) {
                    this.setOverrideFlag(7);
                }
                if (this.gbAtX[8] != 2 || this.gbAtY[8] != -2) {
                    this.setOverrideFlag(8);
                }
                if (this.gbAtX[9] != 3 || this.gbAtY[9] != -1) {
                    this.setOverrideFlag(9);
                }
                if (this.gbAtX[10] != -2 || this.gbAtY[10] != -2) {
                    this.setOverrideFlag(10);
                }
                if (this.gbAtX[11] == -3 && this.gbAtY[11] == -1) break;
                this.setOverrideFlag(11);
                break;
            }
            case 1: {
                if (this.gbAtX[0] == 3 && this.gbAtY[0] == -1) break;
                this.setOverrideFlag(0);
                break;
            }
            case 2: {
                if (this.gbAtX[0] == 2 && this.gbAtY[0] == -1) break;
                this.setOverrideFlag(0);
                break;
            }
            case 3: {
                if (this.gbAtX[0] == 2 && this.gbAtY[0] == -1) break;
                this.setOverrideFlag(0);
            }
        }
    }

    private void setOverrideFlag(int n2) {
        this.gbAtOverride[n2] = true;
        this.override = true;
    }

    private int overrideAtTemplate0a(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        if (this.gbAtOverride[0]) {
            n2 &= 0xFFEF;
            n2 = this.gbAtY[0] == 0 && this.gbAtX[0] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[0] & 1) << 4) : (n2 |= this.getPixel(n3 + this.gbAtX[0], n4 + this.gbAtY[0]) << 4);
        }
        if (this.gbAtOverride[1]) {
            n2 &= 0xFBFF;
            n2 = this.gbAtY[1] == 0 && this.gbAtX[1] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[1] & 1) << 10) : (n2 |= this.getPixel(n3 + this.gbAtX[1], n4 + this.gbAtY[1]) << 10);
        }
        if (this.gbAtOverride[2]) {
            n2 &= 0xF7FF;
            n2 = this.gbAtY[2] == 0 && this.gbAtX[2] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[2] & 1) << 11) : (n2 |= this.getPixel(n3 + this.gbAtX[2], n4 + this.gbAtY[2]) << 11);
        }
        if (this.gbAtOverride[3]) {
            n2 &= Short.MAX_VALUE;
            n2 = this.gbAtY[3] == 0 && this.gbAtX[3] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[3] & 1) << 15) : (n2 |= this.getPixel(n3 + this.gbAtX[3], n4 + this.gbAtY[3]) << 15);
        }
        return n2;
    }

    private int overrideAtTemplate0b(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        if (this.gbAtOverride[0]) {
            n2 &= 0xFFFD;
            n2 = this.gbAtY[0] == 0 && this.gbAtX[0] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[0] & 1) << 1) : (n2 |= this.getPixel(n3 + this.gbAtX[0], n4 + this.gbAtY[0]) << 1);
        }
        if (this.gbAtOverride[1]) {
            n2 &= 0xDFFF;
            n2 = this.gbAtY[1] == 0 && this.gbAtX[1] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[1] & 1) << 13) : (n2 |= this.getPixel(n3 + this.gbAtX[1], n4 + this.gbAtY[1]) << 13);
        }
        if (this.gbAtOverride[2]) {
            n2 &= 0xFDFF;
            n2 = this.gbAtY[2] == 0 && this.gbAtX[2] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[2] & 1) << 9) : (n2 |= this.getPixel(n3 + this.gbAtX[2], n4 + this.gbAtY[2]) << 9);
        }
        if (this.gbAtOverride[3]) {
            n2 &= 0xBFFF;
            n2 = this.gbAtY[3] == 0 && this.gbAtX[3] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[3] & 1) << 14) : (n2 |= this.getPixel(n3 + this.gbAtX[3], n4 + this.gbAtY[3]) << 14);
        }
        if (this.gbAtOverride[4]) {
            n2 &= 0xEFFF;
            n2 = this.gbAtY[4] == 0 && this.gbAtX[4] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[4] & 1) << 12) : (n2 |= this.getPixel(n3 + this.gbAtX[4], n4 + this.gbAtY[4]) << 12);
        }
        if (this.gbAtOverride[5]) {
            n2 &= 0xFFDF;
            n2 = this.gbAtY[5] == 0 && this.gbAtX[5] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[5] & 1) << 5) : (n2 |= this.getPixel(n3 + this.gbAtX[5], n4 + this.gbAtY[5]) << 5);
        }
        if (this.gbAtOverride[6]) {
            n2 &= 0xFFFB;
            n2 = this.gbAtY[6] == 0 && this.gbAtX[6] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[6] & 1) << 2) : (n2 |= this.getPixel(n3 + this.gbAtX[6], n4 + this.gbAtY[6]) << 2);
        }
        if (this.gbAtOverride[7]) {
            n2 &= 0xFFF7;
            n2 = this.gbAtY[7] == 0 && this.gbAtX[7] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[7] & 1) << 3) : (n2 |= this.getPixel(n3 + this.gbAtX[7], n4 + this.gbAtY[7]) << 3);
        }
        if (this.gbAtOverride[8]) {
            n2 &= 0xF7FF;
            n2 = this.gbAtY[8] == 0 && this.gbAtX[8] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[8] & 1) << 11) : (n2 |= this.getPixel(n3 + this.gbAtX[8], n4 + this.gbAtY[8]) << 11);
        }
        if (this.gbAtOverride[9]) {
            n2 &= 0xFFEF;
            n2 = this.gbAtY[9] == 0 && this.gbAtX[9] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[9] & 1) << 4) : (n2 |= this.getPixel(n3 + this.gbAtX[9], n4 + this.gbAtY[9]) << 4);
        }
        if (this.gbAtOverride[10]) {
            n2 &= Short.MAX_VALUE;
            n2 = this.gbAtY[10] == 0 && this.gbAtX[10] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[10] & 1) << 15) : (n2 |= this.getPixel(n3 + this.gbAtX[10], n4 + this.gbAtY[10]) << 15);
        }
        if (this.gbAtOverride[11]) {
            n2 &= 0xFDFF;
            n2 = this.gbAtY[11] == 0 && this.gbAtX[11] >= -n6 ? (n2 |= (n5 >> n7 - this.gbAtX[11] & 1) << 10) : (n2 |= this.getPixel(n3 + this.gbAtX[11], n4 + this.gbAtY[11]) << 10);
        }
        return n2;
    }

    private int overrideAtTemplate1(int n2, int n3, int n4, int n5, int n6) throws IOException {
        n2 &= 0x1FF7;
        if (this.gbAtY[0] == 0 && this.gbAtX[0] >= -n6) {
            return n2 | (n5 >> 7 - (n6 + this.gbAtX[0]) & 1) << 3;
        }
        return n2 | this.getPixel(n3 + this.gbAtX[0], n4 + this.gbAtY[0]) << 3;
    }

    private int overrideAtTemplate2(int n2, int n3, int n4, int n5, int n6) throws IOException {
        n2 &= 0x3FB;
        if (this.gbAtY[0] == 0 && this.gbAtX[0] >= -n6) {
            return n2 | (n5 >> 7 - (n6 + this.gbAtX[0]) & 1) << 2;
        }
        return n2 | this.getPixel(n3 + this.gbAtX[0], n4 + this.gbAtY[0]) << 2;
    }

    private int overrideAtTemplate3(int n2, int n3, int n4, int n5, int n6) throws IOException {
        n2 &= 0x3EF;
        if (this.gbAtY[0] == 0 && this.gbAtX[0] >= -n6) {
            return n2 | (n5 >> 7 - (n6 + this.gbAtX[0]) & 1) << 4;
        }
        return n2 | this.getPixel(n3 + this.gbAtX[0], n4 + this.gbAtY[0]) << 4;
    }

    private byte getPixel(int n2, int n3) throws IOException {
        if (n2 < 0 || n2 >= this.regionBitmap.getWidth()) {
            return 0;
        }
        if (n3 < 0 || n3 >= this.regionBitmap.getHeight()) {
            return 0;
        }
        return this.regionBitmap.getPixel(n2, n3);
    }

    protected void setParameters(boolean bl, long l2, long l3, int n2, int n3) {
        this.isMMREncoded = bl;
        this.dataOffset = l2;
        this.dataLength = l3;
        this.regionInfo.setBitmapHeight(n2);
        this.regionInfo.setBitmapWidth(n3);
        this.mmrDecompressor = null;
        this.resetBitmap();
    }

    protected void setParameters(boolean bl, byte by, boolean bl2, boolean bl3, short[] sArray, short[] sArray2, int n2, int n3, CX cX, ArithmeticDecoder arithmeticDecoder) {
        this.isMMREncoded = bl;
        this.gbTemplate = by;
        this.isTPGDon = bl2;
        this.gbAtX = sArray;
        this.gbAtY = sArray2;
        this.regionInfo.setBitmapWidth(n2);
        this.regionInfo.setBitmapHeight(n3);
        if (null != cX) {
            this.cx = cX;
        }
        if (null != arithmeticDecoder) {
            this.arithDecoder = arithmeticDecoder;
        }
        this.mmrDecompressor = null;
        this.resetBitmap();
    }

    protected void setParameters(boolean bl, long l2, long l3, int n2, int n3, byte by, boolean bl2, boolean bl3, short[] sArray, short[] sArray2) {
        this.dataOffset = l2;
        this.dataLength = l3;
        this.regionInfo = new RegionSegmentInformation();
        this.regionInfo.setBitmapHeight(n2);
        this.regionInfo.setBitmapWidth(n3);
        this.gbTemplate = by;
        this.isMMREncoded = bl;
        this.isTPGDon = bl2;
        this.gbAtX = sArray;
        this.gbAtY = sArray2;
    }

    protected void resetBitmap() {
        this.regionBitmap = null;
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IOException {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    @Override
    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }

    protected boolean useExtTemplates() {
        return this.useExtTemplates;
    }

    protected boolean isTPGDon() {
        return this.isTPGDon;
    }

    protected byte getGbTemplate() {
        return this.gbTemplate;
    }

    protected boolean isMMREncoded() {
        return this.isMMREncoded;
    }

    protected short[] getGbAtX() {
        return this.gbAtX;
    }

    protected short[] getGbAtY() {
        return this.gbAtY;
    }
}

