/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.io.IOException;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.CX;
import org.apache.pdfbox.jbig2.err.IntegerMaxValueException;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

public class GenericRefinementRegion
implements Region {
    private static final Logger log = LoggerFactory.getLogger(GenericRefinementRegion.class);
    private static final Template T0 = new Template0();
    private static final Template T1 = new Template1();
    private SubInputStream subInputStream;
    private SegmentHeader segmentHeader;
    private RegionSegmentInformation regionInfo;
    private boolean isTPGROn;
    private short templateID;
    private Template template;
    private short[] grAtX;
    private short[] grAtY;
    private Bitmap regionBitmap;
    private Bitmap referenceBitmap;
    private int referenceDX;
    private int referenceDY;
    private ArithmeticDecoder arithDecoder;
    private CX cx;
    private boolean override;
    private boolean[] grAtOverride;

    public GenericRefinementRegion() {
    }

    public GenericRefinementRegion(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    public GenericRefinementRegion(SubInputStream subInputStream, SegmentHeader segmentHeader) {
        this.subInputStream = subInputStream;
        this.segmentHeader = segmentHeader;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    private void parseHeader() throws IOException {
        this.regionInfo.parseHeader();
        this.subInputStream.readBits(6);
        if (this.subInputStream.readBit() == 1) {
            this.isTPGROn = true;
        }
        this.templateID = (short)this.subInputStream.readBit();
        switch (this.templateID) {
            case 0: {
                this.template = T0;
                this.readAtPixels();
                break;
            }
            case 1: {
                this.template = T1;
            }
        }
    }

    private void readAtPixels() throws IOException {
        this.grAtX = new short[2];
        this.grAtY = new short[2];
        this.grAtX[0] = this.subInputStream.readByte();
        this.grAtY[0] = this.subInputStream.readByte();
        this.grAtX[1] = this.subInputStream.readByte();
        this.grAtY[1] = this.subInputStream.readByte();
    }

    @Override
    public Bitmap getRegionBitmap() throws IOException, IntegerMaxValueException, InvalidHeaderValueException {
        if (null == this.regionBitmap) {
            int n2 = 0;
            if (this.referenceBitmap == null) {
                this.referenceBitmap = this.getGrReference();
            }
            if (this.arithDecoder == null) {
                this.arithDecoder = new ArithmeticDecoder(this.subInputStream);
            }
            if (this.cx == null) {
                this.cx = new CX(8192, 1);
            }
            this.regionBitmap = new Bitmap(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight());
            if (this.templateID == 0) {
                this.updateOverride();
            }
            int n3 = this.regionBitmap.getWidth() + 7 & 0xFFFFFFF8;
            int n4 = this.isTPGROn ? -this.referenceDY * this.referenceBitmap.getRowStride() : 0;
            int n5 = n4 + 1;
            for (int i2 = 0; i2 < this.regionBitmap.getHeight(); ++i2) {
                if (this.isTPGROn) {
                    n2 ^= this.decodeSLTP();
                }
                if (n2 == 0) {
                    this.decodeOptimized(i2, this.regionBitmap.getWidth(), this.regionBitmap.getRowStride(), this.referenceBitmap.getRowStride(), n3, n4, n5);
                    continue;
                }
                this.decodeTypicalPredictedLine(i2, this.regionBitmap.getWidth(), this.regionBitmap.getRowStride(), this.referenceBitmap.getRowStride(), n3, n4);
            }
        }
        return this.regionBitmap;
    }

    private int decodeSLTP() throws IOException {
        this.template.setIndex(this.cx);
        return this.arithDecoder.decode(this.cx);
    }

    private Bitmap getGrReference() throws IntegerMaxValueException, InvalidHeaderValueException, IOException {
        SegmentHeader[] segmentHeaderArray = this.segmentHeader.getRtSegments();
        Region region = (Region)segmentHeaderArray[0].getSegmentData();
        return region.getRegionBitmap();
    }

    private void decodeOptimized(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        int n9 = n2 - this.referenceDY;
        int n10 = this.referenceBitmap.getByteIndex(Math.max(0, -this.referenceDX), n9);
        int n11 = this.regionBitmap.getByteIndex(Math.max(0, this.referenceDX), n2);
        switch (this.templateID) {
            case 0: {
                this.decodeTemplate(n2, n3, n4, n5, n6, n7, n8, n11, n9, n10, T0);
                break;
            }
            case 1: {
                this.decodeTemplate(n2, n3, n4, n5, n6, n7, n8, n11, n9, n10, T1);
            }
        }
    }

    private void decodeTemplate(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Template template) throws IOException {
        short s2;
        short s3;
        short s4;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (n10 >= 1 && n10 - 1 < this.referenceBitmap.getHeight()) {
            n15 = this.referenceBitmap.getByteAsInteger(n11 - n5);
        }
        if (n10 >= 0 && n10 < this.referenceBitmap.getHeight()) {
            n14 = this.referenceBitmap.getByteAsInteger(n11);
        }
        if (n10 >= -1 && n10 + 1 < this.referenceBitmap.getHeight()) {
            n13 = this.referenceBitmap.getByteAsInteger(n11 + n5);
        }
        ++n11;
        if (n2 >= 1) {
            n12 = this.regionBitmap.getByteAsInteger(n9 - n4);
        }
        ++n9;
        int n16 = this.referenceDX % 8;
        int n17 = 6 + n16;
        int n18 = n11 % n5;
        if (n17 >= 0) {
            s4 = (short)((n17 >= 8 ? 0 : n15 >>> n17) & 7);
            s3 = (short)((n17 >= 8 ? 0 : n14 >>> n17) & 7);
            s2 = (short)((n17 >= 8 ? 0 : n13 >>> n17) & 7);
            if (n17 == 6 && n18 > 1) {
                if (n10 >= 1 && n10 - 1 < this.referenceBitmap.getHeight()) {
                    s4 = (short)(s4 | this.referenceBitmap.getByteAsInteger(n11 - n5 - 2) << 2 & 4);
                }
                if (n10 >= 0 && n10 < this.referenceBitmap.getHeight()) {
                    s3 = (short)(s3 | this.referenceBitmap.getByteAsInteger(n11 - 2) << 2 & 4);
                }
                if (n10 >= -1 && n10 + 1 < this.referenceBitmap.getHeight()) {
                    s2 = (short)(s2 | this.referenceBitmap.getByteAsInteger(n11 + n5 - 2) << 2 & 4);
                }
            }
            if (n17 == 0) {
                n13 = 0;
                n14 = 0;
                n15 = 0;
                if (n18 < n5 - 1) {
                    if (n10 >= 1 && n10 - 1 < this.referenceBitmap.getHeight()) {
                        n15 = this.referenceBitmap.getByteAsInteger(n11 - n5);
                    }
                    if (n10 >= 0 && n10 < this.referenceBitmap.getHeight()) {
                        n14 = this.referenceBitmap.getByteAsInteger(n11);
                    }
                    if (n10 >= -1 && n10 + 1 < this.referenceBitmap.getHeight()) {
                        n13 = this.referenceBitmap.getByteAsInteger(n11 + n5);
                    }
                }
                ++n11;
            }
        } else {
            s4 = (short)(n15 << 1 & 7);
            s3 = (short)(n14 << 1 & 7);
            s2 = (short)(n13 << 1 & 7);
            n13 = 0;
            n14 = 0;
            n15 = 0;
            if (n18 < n5 - 1) {
                if (n10 >= 1 && n10 - 1 < this.referenceBitmap.getHeight()) {
                    n15 = this.referenceBitmap.getByteAsInteger(n11 - n5);
                }
                if (n10 >= 0 && n10 < this.referenceBitmap.getHeight()) {
                    n14 = this.referenceBitmap.getByteAsInteger(n11);
                }
                if (n10 >= -1 && n10 + 1 < this.referenceBitmap.getHeight()) {
                    n13 = this.referenceBitmap.getByteAsInteger(n11 + n5);
                }
                ++n11;
            }
            s4 = (short)(s4 | (short)(n15 >>> 7 & 7));
            s3 = (short)(s3 | (short)(n14 >>> 7 & 7));
            s2 = (short)(s2 | (short)(n13 >>> 7 & 7));
        }
        short s5 = (short)(n12 >>> 6);
        short s6 = 0;
        int n19 = (2 - n16) % 8;
        n15 <<= n19;
        n14 <<= n19;
        n13 <<= n19;
        n12 <<= 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n20 = i2 & 7;
            short s7 = template.form(s4, s3, s2, s5, s6);
            if (this.override) {
                this.cx.setIndex(this.overrideAtTemplate0(s7, i2, n2, this.regionBitmap.getByte(this.regionBitmap.getByteIndex(i2, n2)), n20));
            } else {
                this.cx.setIndex(s7);
            }
            int n21 = this.arithDecoder.decode(this.cx);
            this.regionBitmap.setPixel(i2, n2, (byte)n21);
            s4 = (short)((s4 << 1 | 1 & n15 >>> 7) & 7);
            s3 = (short)((s3 << 1 | 1 & n14 >>> 7) & 7);
            s2 = (short)((s2 << 1 | 1 & n13 >>> 7) & 7);
            s5 = (short)((s5 << 1 | 1 & n12 >>> 7) & 7);
            s6 = (short)n21;
            if ((i2 - this.referenceDX) % 8 == 5) {
                if ((i2 - this.referenceDX) / 8 + 1 >= this.referenceBitmap.getRowStride()) {
                    n13 = 0;
                    n14 = 0;
                    n15 = 0;
                } else {
                    n15 = n10 >= 1 && n10 - 1 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n11 - n5) : 0;
                    n14 = n10 >= 0 && n10 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n11) : 0;
                    n13 = n10 >= -1 && n10 + 1 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n11 + n5) : 0;
                }
                ++n11;
            } else {
                n15 <<= 1;
                n14 <<= 1;
                n13 <<= 1;
            }
            if (n20 == 5 && n2 >= 1) {
                n12 = (i2 >> 3) + 1 >= this.regionBitmap.getRowStride() ? 0 : this.regionBitmap.getByteAsInteger(n9 - n4);
                ++n9;
                continue;
            }
            n12 <<= 1;
        }
    }

    private void updateOverride() {
        if (this.grAtX == null || this.grAtY == null) {
            log.info("AT pixels not set");
            return;
        }
        if (this.grAtX.length != this.grAtY.length) {
            log.info("AT pixel inconsistent");
            return;
        }
        this.grAtOverride = new boolean[this.grAtX.length];
        switch (this.templateID) {
            case 0: {
                if (this.grAtX[0] != -1 && this.grAtY[0] != -1) {
                    this.grAtOverride[0] = true;
                    this.override = true;
                }
                if (this.grAtX[1] == -1 || this.grAtY[1] == -1) break;
                this.grAtOverride[1] = true;
                this.override = true;
                break;
            }
            case 1: {
                this.override = false;
            }
        }
    }

    private void decodeTypicalPredictedLine(int n2, int n3, int n4, int n5, int n6, int n7) throws IOException {
        int n8 = n2 - this.referenceDY;
        int n9 = this.referenceBitmap.getByteIndex(0, n8);
        int n10 = this.regionBitmap.getByteIndex(0, n2);
        switch (this.templateID) {
            case 0: {
                this.decodeTypicalPredictedLineTemplate0(n2, n3, n4, n5, n6, n7, n10, n8, n9);
                break;
            }
            case 1: {
                this.decodeTypicalPredictedLineTemplate1(n2, n3, n4, n5, n6, n7, n10, n8, n9);
            }
        }
    }

    private void decodeTypicalPredictedLineTemplate0(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IOException {
        int n11 = n2 > 0 ? this.regionBitmap.getByteAsInteger(n8 - n4) : 0;
        int n12 = n9 > 0 && n9 <= this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n10 - n5 + n7) << 4 : 0;
        int n13 = n9 >= 0 && n9 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n10 + n7) << 1 : 0;
        int n14 = n9 > -2 && n9 < this.referenceBitmap.getHeight() - 1 ? this.referenceBitmap.getByteAsInteger(n10 + n5 + n7) : 0;
        int n15 = n11 >> 5 & 6 | n14 >> 2 & 0x30 | n13 & 0x180 | n12 & 0xC00;
        int n16 = 0;
        while (n16 < n6) {
            byte by = 0;
            int n17 = n16 + 8;
            int n18 = n3 - n16 > 8 ? 8 : n3 - n16;
            boolean bl = n17 < n3;
            boolean bl2 = n17 < this.referenceBitmap.getWidth();
            int n19 = n7 + 1;
            if (n2 > 0) {
                n11 = n11 << 8 | (bl ? this.regionBitmap.getByteAsInteger(n8 - n4 + 1) : 0);
            }
            if (n9 > 0 && n9 <= this.referenceBitmap.getHeight()) {
                n12 = n12 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n10 - n5 + n19) << 4 : 0);
            }
            if (n9 >= 0 && n9 < this.referenceBitmap.getHeight()) {
                n13 = n13 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n10 + n19) << 1 : 0);
            }
            if (n9 > -2 && n9 < this.referenceBitmap.getHeight() - 1) {
                n14 = n14 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n10 + n5 + n19) : 0);
            }
            for (int i2 = 0; i2 < n18; ++i2) {
                boolean bl3 = false;
                int n20 = 0;
                int n21 = n15 >> 4 & 0x1FF;
                if (n21 == 511) {
                    bl3 = true;
                    n20 = 1;
                } else if (n21 == 0) {
                    bl3 = true;
                    n20 = 0;
                }
                if (!bl3) {
                    if (this.override) {
                        int n22 = this.overrideAtTemplate0(n15, n16 + i2, n2, by, i2);
                        this.cx.setIndex(n22);
                    } else {
                        this.cx.setIndex(n15);
                    }
                    n20 = this.arithDecoder.decode(this.cx);
                }
                int n23 = 7 - i2;
                by = (byte)(by | n20 << n23);
                n15 = (n15 & 0xDB6) << 1 | n20 | n11 >> n23 + 5 & 2 | n14 >> n23 + 2 & 0x10 | n13 >> n23 & 0x80 | n12 >> n23 & 0x400;
            }
            this.regionBitmap.setByte(n8++, by);
            ++n10;
            n16 = n17;
        }
    }

    private void decodeTypicalPredictedLineTemplate1(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IOException {
        int n11 = n2 > 0 ? this.regionBitmap.getByteAsInteger(n8 - n4) : 0;
        int n12 = n9 > 0 && n9 <= this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n8 - n5 + n7) << 2 : 0;
        int n13 = n9 >= 0 && n9 < this.referenceBitmap.getHeight() ? this.referenceBitmap.getByteAsInteger(n8 + n7) : 0;
        int n14 = n9 > -2 && n9 < this.referenceBitmap.getHeight() - 1 ? this.referenceBitmap.getByteAsInteger(n8 + n5 + n7) : 0;
        int n15 = n11 >> 5 & 6 | n14 >> 2 & 0x30 | n13 & 0xC0 | n12 & 0x200;
        int n16 = n14 >> 2 & 0x70 | n13 & 0xC0 | n12 & 0x700;
        int n17 = 0;
        while (n17 < n6) {
            byte by = 0;
            int n18 = n17 + 8;
            int n19 = n3 - n17 > 8 ? 8 : n3 - n17;
            boolean bl = n18 < n3;
            boolean bl2 = n18 < this.referenceBitmap.getWidth();
            int n20 = n7 + 1;
            if (n2 > 0) {
                n11 = n11 << 8 | (bl ? this.regionBitmap.getByteAsInteger(n8 - n4 + 1) : 0);
            }
            if (n9 > 0 && n9 <= this.referenceBitmap.getHeight()) {
                n12 = n12 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n10 - n5 + n20) << 2 : 0);
            }
            if (n9 >= 0 && n9 < this.referenceBitmap.getHeight()) {
                n13 = n13 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n10 + n20) : 0);
            }
            if (n9 > -2 && n9 < this.referenceBitmap.getHeight() - 1) {
                n14 = n14 << 8 | (bl2 ? this.referenceBitmap.getByteAsInteger(n10 + n5 + n20) : 0);
            }
            for (int i2 = 0; i2 < n19; ++i2) {
                int n21 = 0;
                int n22 = n16 >> 4 & 0x1FF;
                if (n22 == 511) {
                    n21 = 1;
                } else if (n22 == 0) {
                    n21 = 0;
                } else {
                    this.cx.setIndex(n15);
                    n21 = this.arithDecoder.decode(this.cx);
                }
                int n23 = 7 - i2;
                by = (byte)(by | n21 << n23);
                n15 = (n15 & 0xD6) << 1 | n21 | n11 >> n23 + 5 & 2 | n14 >> n23 + 2 & 0x10 | n13 >> n23 & 0x40 | n12 >> n23 & 0x200;
                n16 = (n16 & 0xDB) << 1 | n14 >> n23 + 2 & 0x10 | n13 >> n23 & 0x80 | n12 >> n23 & 0x400;
            }
            this.regionBitmap.setByte(n8++, by);
            ++n10;
            n17 = n18;
        }
    }

    private int overrideAtTemplate0(int n2, int n3, int n4, int n5, int n6) throws IOException {
        if (this.grAtOverride[0]) {
            n2 &= 0xFFF7;
            n2 = this.grAtY[0] == 0 && this.grAtX[0] >= -n6 ? (n2 |= (n5 >> 7 - (n6 + this.grAtX[0]) & 1) << 3) : (n2 |= this.getPixel(this.regionBitmap, n3 + this.grAtX[0], n4 + this.grAtY[0]) << 3);
        }
        if (this.grAtOverride[1]) {
            n2 &= 0xEFFF;
            n2 = this.grAtY[1] == 0 && this.grAtX[1] >= -n6 ? (n2 |= (n5 >> 7 - (n6 + this.grAtX[1]) & 1) << 12) : (n2 |= this.getPixel(this.referenceBitmap, n3 + this.grAtX[1] + this.referenceDX, n4 + this.grAtY[1] + this.referenceDY) << 12);
        }
        return n2;
    }

    private byte getPixel(Bitmap bitmap, int n2, int n3) throws IOException {
        if (n2 < 0 || n2 >= bitmap.getWidth()) {
            return 0;
        }
        if (n3 < 0 || n3 >= bitmap.getHeight()) {
            return 0;
        }
        return bitmap.getPixel(n2, n3);
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws IOException {
        this.segmentHeader = segmentHeader;
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    protected void setParameters(CX cX, ArithmeticDecoder arithmeticDecoder, short s2, int n2, int n3, Bitmap bitmap, int n4, int n5, boolean bl, short[] sArray, short[] sArray2) {
        if (null != cX) {
            this.cx = cX;
        }
        if (null != arithmeticDecoder) {
            this.arithDecoder = arithmeticDecoder;
        }
        this.templateID = s2;
        this.regionInfo.setBitmapWidth(n2);
        this.regionInfo.setBitmapHeight(n3);
        this.referenceBitmap = bitmap;
        this.referenceDX = n4;
        this.referenceDY = n5;
        this.isTPGROn = bl;
        this.grAtX = sArray;
        this.grAtY = sArray2;
        this.regionBitmap = null;
    }

    @Override
    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }

    private static class Template1
    extends Template {
        private Template1() {
        }

        @Override
        protected short form(short s2, short s3, short s4, short s5, short s6) {
            return (short)((s2 & 2) << 8 | s3 << 6 | (s4 & 3) << 4 | s5 << 1 | s6);
        }

        @Override
        protected void setIndex(CX cX) {
            cX.setIndex(128);
        }
    }

    private static class Template0
    extends Template {
        private Template0() {
        }

        @Override
        protected short form(short s2, short s3, short s4, short s5, short s6) {
            return (short)(s2 << 10 | s3 << 7 | s4 << 4 | s5 << 1 | s6);
        }

        @Override
        protected void setIndex(CX cX) {
            cX.setIndex(256);
        }
    }

    public static abstract class Template {
        protected abstract short form(short var1, short var2, short var3, short var4, short var5);

        protected abstract void setIndex(CX var1);
    }
}

