/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.image;

import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.pdfbox.jbig2.image.Weighttab;

abstract class Scanline {
    int y;
    protected final int length;

    protected Scanline(int n2) {
        this.length = n2;
    }

    protected final int getWidth() {
        return this.length;
    }

    protected abstract void clear();

    protected abstract void fetch(int var1, int var2);

    protected abstract void filter(int[] var1, int[] var2, Weighttab[] var3, Scanline var4);

    protected abstract void accumulate(int var1, Scanline var2);

    protected abstract void shift(int[] var1);

    protected abstract void store(int var1, int var2);

    protected static final class ByteBiLevelPackedScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int[] data;

        protected ByteBiLevelPackedScanline(Raster raster, WritableRaster writableRaster, int n2) {
            super(n2);
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.data = new int[n2];
        }

        @Override
        protected void accumulate(int n2, Scanline scanline) {
            ByteBiLevelPackedScanline byteBiLevelPackedScanline = (ByteBiLevelPackedScanline)scanline;
            int[] nArray = this.data;
            int[] nArray2 = byteBiLevelPackedScanline.data;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n3 = i2;
                nArray2[n3] = nArray2[n3] + n2 * nArray[i2];
            }
        }

        @Override
        protected void clear() {
            int[] nArray = this.data;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = 0;
            }
        }

        @Override
        protected void fetch(int n2, int n3) {
            this.srcRaster.getPixels(n2, n3, this.length, 1, this.data);
            for (int i2 = 0; i2 < this.length; ++i2) {
                if (this.data[i2] == 0) continue;
                this.data[i2] = 255;
            }
        }

        @Override
        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            ByteBiLevelPackedScanline byteBiLevelPackedScanline = (ByteBiLevelPackedScanline)scanline;
            int n2 = scanline.length;
            int n3 = 1 << nArray2[0] - 1;
            int[] nArray3 = this.data;
            int[] nArray4 = byteBiLevelPackedScanline.data;
            int n4 = nArray[0];
            int n5 = nArray2[0];
            if (n4 != 0) {
                int n6 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n7;
                    Weighttab weighttab = weighttabArray[i2];
                    int n8 = weighttab.weights.length;
                    int n9 = n3;
                    int n10 = weighttab.i0;
                    for (n7 = 0; n7 < n8 && n10 < nArray3.length; ++n7) {
                        n9 += weighttab.weights[n7] * (nArray3[n10++] >> n4);
                    }
                    n7 = n9 >> n5;
                    nArray4[n6++] = n7 < 0 ? 0 : (n7 > 255 ? 255 : n7);
                }
            } else {
                int n11 = 0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    Weighttab weighttab = weighttabArray[i3];
                    int n12 = weighttab.weights.length;
                    int n13 = n3;
                    int n14 = weighttab.i0;
                    for (int i4 = 0; i4 < n12 && n14 < nArray3.length; ++i4) {
                        n13 += weighttab.weights[i4] * nArray3[n14++];
                    }
                    nArray4[n11++] = n13 >> n5;
                }
            }
        }

        @Override
        protected void shift(int[] nArray) {
            int n2 = nArray[0];
            int n3 = 1 << n2 - 1;
            int[] nArray2 = this.data;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n4 = nArray2[i2] + n3 >> n2;
                nArray2[i2] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
            }
        }

        @Override
        protected void store(int n2, int n3) {
            this.dstRaster.setPixels(n2, n3, this.length, 1, this.data);
        }
    }

    protected static final class GenericRasterScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int componentCount;
        private final int[][] data;
        private final SampleModel srcSM;
        private final SampleModel dstSM;
        private final int[] channelMask;
        private final int[] tmp;
        private final ScanlineFilter inputFilter;

        protected GenericRasterScanline(Raster raster, WritableRaster writableRaster, int n2, int[] nArray, ScanlineFilter scanlineFilter) {
            super(n2);
            int n3;
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.inputFilter = scanlineFilter;
            this.srcSM = this.srcRaster.getSampleModel();
            this.dstSM = this.dstRaster.getSampleModel();
            this.componentCount = this.srcSM.getNumBands();
            if (this.componentCount != this.dstSM.getNumBands()) {
                throw new IllegalArgumentException("weird: src raster num bands != dst raster num bands");
            }
            this.tmp = new int[this.componentCount];
            this.data = new int[this.componentCount][];
            for (n3 = 0; n3 < this.data.length; ++n3) {
                this.data[n3] = new int[n2];
            }
            this.channelMask = new int[this.componentCount];
            for (n3 = 0; n3 < this.componentCount; ++n3) {
                this.channelMask[n3] = (1 << nArray[n3]) - 1;
            }
        }

        @Override
        protected void accumulate(int n2, Scanline scanline) {
            GenericRasterScanline genericRasterScanline = (GenericRasterScanline)scanline;
            int n3 = genericRasterScanline.data[0].length;
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                int[] nArray = this.data[i2];
                int[] nArray2 = genericRasterScanline.data[i2];
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n4 = i3;
                    nArray2[n4] = nArray2[n4] + n2 * nArray[i3];
                }
            }
        }

        @Override
        protected void clear() {
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                int[] nArray = this.data[i2];
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    nArray[i3] = 0;
                }
            }
        }

        @Override
        protected void fetch(int n2, int n3) {
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                this.srcRaster.getSamples(n2, n3, this.length, 1, i2, this.data[i2]);
                if (null == this.inputFilter) continue;
                this.inputFilter.filter(n2, n3, i2, this.data[i2], this.length);
            }
        }

        @Override
        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            int n2;
            int n3;
            GenericRasterScanline genericRasterScanline = (GenericRasterScanline)scanline;
            int n4 = scanline.length;
            int[] nArray3 = this.tmp;
            for (n3 = 0; n3 < this.componentCount; ++n3) {
                nArray3[n3] = 1 << nArray2[n3] - 1;
            }
            n3 = this.data[0].length;
            boolean bl = false;
            for (n2 = 0; n2 < this.componentCount && !bl; bl |= nArray[n2] != 0, ++n2) {
            }
            if (bl) {
                for (n2 = 0; n2 < this.componentCount; ++n2) {
                    int[] nArray4 = this.data[n2];
                    int[] nArray5 = genericRasterScanline.data[n2];
                    int n5 = this.channelMask[n2];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        Weighttab weighttab = weighttabArray[i2];
                        int n6 = weighttab.weights.length;
                        int n7 = nArray3[n2];
                        int n8 = 0;
                        for (int i3 = weighttab.i0; n8 < n6 && i3 < n3; ++n8, ++i3) {
                            n7 += weighttab.weights[n8] * (nArray4[i3] >> nArray[n2]);
                        }
                        n8 = n7 >> nArray2[n2];
                        nArray5[i2] = n8 < 0 ? 0 : (n8 > n5 ? n5 : n8);
                    }
                }
            } else {
                for (n2 = 0; n2 < this.componentCount; ++n2) {
                    int[] nArray6 = this.data[n2];
                    int[] nArray7 = genericRasterScanline.data[n2];
                    for (int i4 = 0; i4 < n4; ++i4) {
                        Weighttab weighttab = weighttabArray[i4];
                        int n9 = weighttab.weights.length;
                        int n10 = nArray3[n2];
                        int n11 = 0;
                        for (int i5 = weighttab.i0; n11 < n9 && i5 < n3; ++n11, ++i5) {
                            n10 += weighttab.weights[n11] * nArray6[i5];
                        }
                        nArray7[i4] = n10 >> nArray2[n2];
                    }
                }
            }
        }

        @Override
        protected void shift(int[] nArray) {
            int[] nArray2 = this.tmp;
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                nArray2[i2] = 1 << nArray[i2] - 1;
            }
            int[][] nArray3 = this.data;
            int n2 = nArray3[0].length;
            for (int i3 = 0; i3 < this.componentCount; ++i3) {
                int[] nArray4 = this.data[i3];
                int n3 = this.channelMask[i3];
                for (int i4 = 0; i4 < n2; ++i4) {
                    int n4 = nArray4[i4] + nArray2[i3] >> nArray[i3];
                    nArray4[i4] = n4 < 0 ? 0 : (n4 > n3 ? n3 : n4);
                }
            }
        }

        @Override
        protected void store(int n2, int n3) {
            int n4 = this.length;
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                this.dstRaster.setSamples(n2, n3, n4, 1, i2, this.data[i2]);
            }
        }
    }

    protected static final class IntegerSinglePixelPackedScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int[] data;
        private final int[] bitMasks;
        private final int[] bitOffsets;
        private final int componentCount;
        private final SinglePixelPackedSampleModel srcSM;
        private final int[] tmp;

        protected IntegerSinglePixelPackedScanline(Raster raster, WritableRaster writableRaster, int n2) {
            super(n2);
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.srcSM = (SinglePixelPackedSampleModel)this.srcRaster.getSampleModel();
            this.bitMasks = this.srcSM.getBitMasks();
            this.bitOffsets = this.srcSM.getBitOffsets();
            this.componentCount = this.bitMasks.length;
            if (this.componentCount != this.bitOffsets.length || this.bitOffsets.length != this.srcSM.getNumBands()) {
                throw new IllegalArgumentException("weird: getBitMasks().length != getBitOffsets().length");
            }
            this.tmp = new int[this.componentCount];
            this.data = new int[this.componentCount * n2];
        }

        @Override
        protected void accumulate(int n2, Scanline scanline) {
            IntegerSinglePixelPackedScanline integerSinglePixelPackedScanline = (IntegerSinglePixelPackedScanline)scanline;
            int[] nArray = this.data;
            int[] nArray2 = integerSinglePixelPackedScanline.data;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n3 = i2;
                nArray2[n3] = nArray2[n3] + n2 * nArray[i2];
            }
        }

        @Override
        protected void clear() {
            int[] nArray = this.data;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = 0;
            }
        }

        @Override
        protected void fetch(int n2, int n3) {
            this.srcRaster.getPixels(n2, n3, this.length, 1, this.data);
        }

        @Override
        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            int n2;
            IntegerSinglePixelPackedScanline integerSinglePixelPackedScanline = (IntegerSinglePixelPackedScanline)scanline;
            int n3 = scanline.length;
            int[] nArray3 = this.tmp;
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                nArray3[i2] = 1 << nArray2[i2] - 1;
            }
            int[] nArray4 = this.data;
            int[] nArray5 = integerSinglePixelPackedScanline.data;
            boolean bl = false;
            for (n2 = 0; n2 < this.componentCount && !bl; bl |= nArray[n2] != 0, ++n2) {
            }
            if (bl) {
                n2 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    Weighttab weighttab = weighttabArray[i3];
                    int n4 = weighttab.weights.length;
                    for (int i4 = 0; i4 < this.componentCount; ++i4) {
                        int n5 = nArray3[i4];
                        int n6 = 0;
                        for (int i5 = weighttab.i0 * this.componentCount + i4; n6 < n4 && i5 < nArray4.length; ++n6, i5 += this.componentCount) {
                            n5 += weighttab.weights[n6] * (nArray4[i5] >> nArray[i4]);
                        }
                        n6 = n5 >> nArray2[i4];
                        nArray5[n2++] = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
                    }
                }
            } else {
                n2 = 0;
                for (int i6 = 0; i6 < n3; ++i6) {
                    Weighttab weighttab = weighttabArray[i6];
                    int n7 = weighttab.weights.length;
                    for (int i7 = 0; i7 < this.componentCount; ++i7) {
                        int n8 = nArray3[i7];
                        int n9 = 0;
                        for (int i8 = weighttab.i0 * this.componentCount + i7; n9 < n7 && i8 < nArray4.length; ++n9, i8 += this.componentCount) {
                            n8 += weighttab.weights[n9] * nArray4[i8];
                        }
                        nArray5[n2++] = n8 >> nArray2[i7];
                    }
                }
            }
        }

        @Override
        protected void shift(int[] nArray) {
            int[] nArray2 = this.tmp;
            for (int i2 = 0; i2 < this.componentCount; ++i2) {
                nArray2[i2] = 1 << nArray[i2] - 1;
            }
            int[] nArray3 = this.data;
            int n2 = 0;
            while (n2 < nArray3.length) {
                int n3 = 0;
                while (n3 < this.componentCount) {
                    int n4 = nArray3[n2] + nArray2[n3] >> nArray[n3];
                    nArray3[n2] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
                    ++n3;
                    ++n2;
                }
            }
        }

        @Override
        protected void store(int n2, int n3) {
            this.dstRaster.setPixels(n2, n3, this.length, 1, this.data);
        }
    }

    protected static final class ByteBGRScanline
    extends Scanline {
        private final Raster srcRaster;
        private final WritableRaster dstRaster;
        private final int[] data;

        protected ByteBGRScanline(Raster raster, WritableRaster writableRaster, int n2) {
            super(n2);
            this.srcRaster = raster;
            this.dstRaster = writableRaster;
            this.data = new int[3 * n2];
        }

        @Override
        protected void accumulate(int n2, Scanline scanline) {
            ByteBGRScanline byteBGRScanline = (ByteBGRScanline)scanline;
            int[] nArray = this.data;
            int[] nArray2 = byteBGRScanline.data;
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n3 = i2;
                nArray2[n3] = nArray2[n3] + n2 * nArray[i2];
            }
        }

        @Override
        protected void clear() {
            int[] nArray = this.data;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = 0;
            }
        }

        @Override
        protected void fetch(int n2, int n3) {
            this.srcRaster.getPixels(n2, n3, this.length, 1, this.data);
        }

        @Override
        protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
            ByteBGRScanline byteBGRScanline = (ByteBGRScanline)scanline;
            int n2 = scanline.length;
            int[] nArray3 = new int[]{1 << nArray2[0] - 1, 1 << nArray2[1] - 1, 1 << nArray2[2] - 1};
            int[] nArray4 = this.data;
            int[] nArray5 = byteBGRScanline.data;
            if (nArray[0] != 0 || nArray[1] != 0 || nArray[2] != 0) {
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4;
                    Weighttab weighttab = weighttabArray[i2];
                    int n5 = weighttab.weights.length;
                    int n6 = nArray3[0];
                    int n7 = nArray3[1];
                    int n8 = nArray3[2];
                    int n9 = weighttab.i0 * 3;
                    for (n4 = 0; n4 < n5 && n9 < nArray4.length; ++n4) {
                        int n10 = weighttab.weights[n4];
                        n6 += n10 * (nArray4[n9++] >> nArray[0]);
                        n7 += n10 * (nArray4[n9++] >> nArray[1]);
                        n8 += n10 * (nArray4[n9++] >> nArray[2]);
                    }
                    n4 = n6 >> nArray2[0];
                    nArray5[n3++] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
                    n4 = n7 >> nArray2[1];
                    nArray5[n3++] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
                    n4 = n8 >> nArray2[2];
                    nArray5[n3++] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
                }
            } else {
                int n11 = 0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    Weighttab weighttab = weighttabArray[i3];
                    int n12 = weighttab.weights.length;
                    int n13 = nArray3[0];
                    int n14 = nArray3[1];
                    int n15 = nArray3[2];
                    int n16 = weighttab.i0 * 3;
                    for (int i4 = 0; i4 < n12 && n16 < nArray4.length; ++i4) {
                        int n17 = weighttab.weights[i4];
                        n13 += n17 * nArray4[n16++];
                        n14 += n17 * nArray4[n16++];
                        n15 += n17 * nArray4[n16++];
                    }
                    nArray5[n11++] = n13 >> nArray2[0];
                    nArray5[n11++] = n14 >> nArray2[1];
                    nArray5[n11++] = n15 >> nArray2[2];
                }
            }
        }

        @Override
        protected void shift(int[] nArray) {
            int[] nArray2 = new int[]{1 << nArray[0] - 1, 1 << nArray[1] - 1, 1 << nArray[2] - 1};
            int[] nArray3 = this.data;
            int n2 = 0;
            while (n2 < nArray3.length) {
                int n3 = 0;
                while (n3 < 3) {
                    int n4 = nArray3[n2] + nArray2[n3] >> nArray[n3];
                    nArray3[n2] = n4 < 0 ? 0 : (n4 > 255 ? 255 : n4);
                    ++n3;
                    ++n2;
                }
            }
        }

        @Override
        protected void store(int n2, int n3) {
            this.dstRaster.setPixels(n2, n3, this.length, 1, this.data);
        }
    }

    public static interface ScanlineFilter {
        public void filter(int var1, int var2, int var3, Object var4, int var5);
    }
}

