/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.image;

import org.apache.pdfbox.jbig2.image.Filter;
import org.apache.pdfbox.jbig2.util.Utils;

class ParameterizedFilter {
    final Filter filter;
    final double scale;
    final double support;
    final int width;

    public ParameterizedFilter(Filter filter, double d2) {
        this.filter = filter;
        this.scale = filter.blur * Math.max(1.0, 1.0 / d2);
        this.support = Math.max(0.5, this.scale * filter.support);
        this.width = (int)Math.ceil(2.0 * this.support);
    }

    public ParameterizedFilter(Filter filter, double d2, double d3, int n2) {
        this.filter = filter;
        this.scale = d2;
        this.support = d3;
        this.width = n2;
    }

    public double eval(double d2, int n2) {
        return this.filter.fWindowed(((double)n2 + 0.5 - d2) / this.scale);
    }

    public int minIndex(double d2) {
        return Utils.floor(d2 - this.support);
    }

    public int maxIndex(double d2) {
        return Utils.ceil(d2 + this.support);
    }
}

