/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import javax.imageio.ImageReadParam;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.JBIG2ReadParam;
import org.apache.pdfbox.jbig2.image.Filter;
import org.apache.pdfbox.jbig2.image.FilterType;
import org.apache.pdfbox.jbig2.image.Resizer;
import org.apache.pdfbox.jbig2.util.CombinationOperator;

public class Bitmaps {
    public static WritableRaster asRaster(Bitmap bitmap) {
        return Bitmaps.asRaster(bitmap, FilterType.Gaussian);
    }

    public static WritableRaster asRaster(Bitmap bitmap, FilterType filterType) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        JBIG2ReadParam jBIG2ReadParam = new JBIG2ReadParam(1, 1, 0, 0, new Rectangle(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Dimension(bitmap.getWidth(), bitmap.getHeight()));
        return Bitmaps.asRaster(bitmap, jBIG2ReadParam, filterType);
    }

    public static WritableRaster asRaster(Bitmap bitmap, ImageReadParam imageReadParam, FilterType filterType) {
        boolean bl;
        double d2;
        double d3;
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        if (imageReadParam == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        Dimension dimension = imageReadParam.getSourceRenderSize();
        if (dimension != null) {
            d3 = dimension.getWidth() / (double)bitmap.getWidth();
            d2 = dimension.getHeight() / (double)bitmap.getHeight();
        } else {
            d2 = 1.0;
            d3 = 1.0;
        }
        Rectangle rectangle = imageReadParam.getSourceRegion();
        if (rectangle != null && !bitmap.getBounds().equals(rectangle)) {
            rectangle = bitmap.getBounds().intersection(rectangle);
            bitmap = Bitmaps.extract(rectangle, bitmap);
        }
        boolean bl2 = d3 != 1.0 || d2 != 1.0;
        boolean bl3 = imageReadParam.getSourceXSubsampling() != 1;
        boolean bl4 = bl = imageReadParam.getSourceYSubsampling() != 1;
        if (bl3 && bl) {
            if (bl2) {
                d3 /= (double)imageReadParam.getSourceXSubsampling();
                d2 /= (double)imageReadParam.getSourceYSubsampling();
            } else {
                bitmap = Bitmaps.subsample(bitmap, imageReadParam);
            }
        } else {
            if (bl3) {
                if (bl2) {
                    d3 /= (double)imageReadParam.getSourceXSubsampling();
                } else {
                    bitmap = Bitmaps.subsampleX(bitmap, imageReadParam.getSourceXSubsampling(), imageReadParam.getSubsamplingXOffset());
                }
            }
            if (bl) {
                if (bl2) {
                    d2 /= (double)imageReadParam.getSourceYSubsampling();
                } else {
                    bitmap = Bitmaps.subsampleY(bitmap, imageReadParam.getSourceYSubsampling(), imageReadParam.getSubsamplingYOffset());
                }
            }
        }
        return Bitmaps.buildRaster(bitmap, filterType, d3, d2);
    }

    private static WritableRaster buildRaster(Bitmap bitmap, FilterType filterType, double d2, double d3) {
        WritableRaster writableRaster;
        Rectangle rectangle = new Rectangle(0, 0, (int)Math.round((double)bitmap.getWidth() * d2), (int)Math.round((double)bitmap.getHeight() * d3));
        if (d2 != 1.0 || d3 != 1.0) {
            writableRaster = WritableRaster.createInterleavedRaster(0, rectangle.width, rectangle.height, 1, new Point());
            Resizer resizer = new Resizer(d2, d3);
            Filter filter = Filter.byType(filterType);
            resizer.resize(bitmap, bitmap.getBounds(), writableRaster, rectangle, filter, filter);
        } else {
            writableRaster = WritableRaster.createPackedRaster(0, rectangle.width, rectangle.height, 1, 1, new Point());
            int n2 = 0;
            for (int i2 = 0; i2 < bitmap.getHeight(); ++i2) {
                int n3 = 0;
                while (n3 < bitmap.getWidth()) {
                    int n4 = ~bitmap.getByte(n2) & 0xFF;
                    int n5 = bitmap.getWidth() - n3 > 8 ? 8 : bitmap.getWidth() - n3;
                    int n6 = 7 - n5;
                    int n7 = 7;
                    while (n7 > n6) {
                        writableRaster.setSample(n3, i2, 0, n4 >> n7 & 1);
                        --n7;
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        return writableRaster;
    }

    public static BufferedImage asBufferedImage(Bitmap bitmap) {
        return Bitmaps.asBufferedImage(bitmap, FilterType.Gaussian);
    }

    public static BufferedImage asBufferedImage(Bitmap bitmap, FilterType filterType) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        JBIG2ReadParam jBIG2ReadParam = new JBIG2ReadParam(1, 1, 0, 0, new Rectangle(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Dimension(bitmap.getWidth(), bitmap.getHeight()));
        return Bitmaps.asBufferedImage(bitmap, jBIG2ReadParam, filterType);
    }

    public static BufferedImage asBufferedImage(Bitmap bitmap, ImageReadParam imageReadParam, FilterType filterType) {
        boolean bl;
        double d2;
        double d3;
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        if (imageReadParam == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        WritableRaster writableRaster = Bitmaps.asRaster(bitmap, imageReadParam, filterType);
        Dimension dimension = imageReadParam.getSourceRenderSize();
        if (dimension != null) {
            d3 = dimension.getWidth() / (double)bitmap.getWidth();
            d2 = dimension.getHeight() / (double)bitmap.getHeight();
        } else {
            d2 = 1.0;
            d3 = 1.0;
        }
        IndexColorModel indexColorModel = null;
        boolean bl2 = bl = d3 != 1.0 || d2 != 1.0;
        if (bl) {
            byte[] byArray = new byte[256];
            int n2 = 255;
            int n3 = 0;
            while (n2 >= 0) {
                byArray[n2] = (byte)(255 - n3 * 255 / 255);
                --n2;
                ++n3;
            }
            indexColorModel = new IndexColorModel(8, 256, byArray, byArray, byArray);
        } else {
            indexColorModel = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
        }
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    public static Bitmap extract(Rectangle rectangle, Bitmap bitmap) {
        Bitmap bitmap2 = new Bitmap(rectangle.width, rectangle.height);
        int n2 = rectangle.x & 7;
        int n3 = 8 - n2;
        int n4 = 0;
        int n5 = 8 - bitmap2.getWidth() & 7;
        int n6 = bitmap.getByteIndex(rectangle.x, rectangle.y);
        int n7 = bitmap.getByteIndex(rectangle.x + rectangle.width - 1, rectangle.y);
        boolean bl = bitmap2.getRowStride() == n7 + 1 - n6;
        int n8 = rectangle.y;
        while ((double)n8 < rectangle.getMaxY()) {
            int n9;
            int n10 = n6;
            int n11 = n4;
            if (n6 == n7) {
                n9 = (byte)(bitmap.getByte(n10) << n2);
                bitmap2.setByte(n11, Bitmaps.unpad(n5, (byte)n9));
            } else if (n2 == 0) {
                for (n9 = n6; n9 <= n7; ++n9) {
                    byte by = bitmap.getByte(n10++);
                    if (n9 == n7 && bl) {
                        by = Bitmaps.unpad(n5, by);
                    }
                    bitmap2.setByte(n11++, by);
                }
            } else {
                Bitmaps.copyLine(bitmap, bitmap2, n2, n3, n5, n6, n7, bl, n10, n11);
            }
            n6 += bitmap.getRowStride();
            n7 += bitmap.getRowStride();
            n4 += bitmap2.getRowStride();
            ++n8;
        }
        return bitmap2;
    }

    private static void copyLine(Bitmap bitmap, Bitmap bitmap2, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8) {
        for (int i2 = n5; i2 < n6; ++i2) {
            byte by;
            if (n7 + 1 < bitmap.getByteArray().length) {
                by = i2 + 1 == n6 ? (byte)1 : 0;
                byte by2 = (byte)(bitmap.getByte(n7++) << n2 | (bitmap.getByte(n7) & 0xFF) >>> n3);
                if (by != 0 && !bl) {
                    by2 = Bitmaps.unpad(n4, by2);
                }
                bitmap2.setByte(n8++, by2);
                if (by == 0 || !bl) continue;
                by2 = Bitmaps.unpad(n4, (byte)((bitmap.getByte(n7) & 0xFF) << n2));
                bitmap2.setByte(n8, by2);
                continue;
            }
            by = (byte)(bitmap.getByte(n7++) << n2 & 0xFF);
            bitmap2.setByte(n8++, by);
        }
    }

    private static byte unpad(int n2, byte by) {
        return (byte)(by >> n2 << n2);
    }

    public static Bitmap subsample(Bitmap bitmap, ImageReadParam imageReadParam) {
        if (bitmap == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        if (imageReadParam == null) {
            throw new IllegalArgumentException("param must not be null");
        }
        int n2 = imageReadParam.getSourceXSubsampling();
        int n3 = imageReadParam.getSourceYSubsampling();
        int n4 = imageReadParam.getSubsamplingXOffset();
        int n5 = imageReadParam.getSubsamplingYOffset();
        int n6 = (bitmap.getWidth() - n4) / n2;
        int n7 = (bitmap.getHeight() - n5) / n3;
        Bitmap bitmap2 = new Bitmap(n6, n7);
        int n8 = 0;
        int n9 = n5;
        while (n8 < bitmap2.getHeight()) {
            int n10 = 0;
            int n11 = n4;
            while (n10 < bitmap2.getWidth()) {
                byte by = bitmap.getPixel(n11, n9);
                if (by != 0) {
                    bitmap2.setPixel(n10, n8, by);
                }
                ++n10;
                n11 += n2;
            }
            ++n8;
            n9 += n3;
        }
        return bitmap2;
    }

    public static Bitmap subsampleX(Bitmap bitmap, int n2, int n3) {
        if (bitmap == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        int n4 = (bitmap.getWidth() - n3) / n2;
        Bitmap bitmap2 = new Bitmap(bitmap.getWidth(), n4);
        for (int i2 = 0; i2 < bitmap2.getHeight(); ++i2) {
            int n5 = 0;
            int n6 = n3;
            while (n5 < bitmap2.getWidth()) {
                byte by = bitmap.getPixel(n6, i2);
                if (by != 0) {
                    bitmap2.setPixel(n5, i2, by);
                }
                ++n5;
                n6 += n2;
            }
        }
        return bitmap2;
    }

    public static Bitmap subsampleY(Bitmap bitmap, int n2, int n3) {
        if (bitmap == null) {
            throw new IllegalArgumentException("src must not be null");
        }
        int n4 = (bitmap.getWidth() - n3) / n2;
        Bitmap bitmap2 = new Bitmap(n4, bitmap.getHeight());
        int n5 = 0;
        int n6 = n3;
        while (n5 < bitmap2.getHeight()) {
            for (int i2 = 0; i2 < bitmap2.getWidth(); ++i2) {
                byte by = bitmap.getPixel(i2, n6);
                if (by == 0) continue;
                bitmap2.setPixel(i2, n5, by);
            }
            ++n5;
            n6 += n2;
        }
        return bitmap2;
    }

    public static byte combineBytes(byte by, byte by2, CombinationOperator combinationOperator) {
        switch (combinationOperator) {
            case OR: {
                return (byte)(by2 | by);
            }
            case AND: {
                return (byte)(by2 & by);
            }
            case XOR: {
                return (byte)(by2 ^ by);
            }
            case XNOR: {
                return (byte)(~(by ^ by2));
            }
        }
        return by2;
    }

    public static void blit(Bitmap bitmap, Bitmap bitmap2, int n2, int n3, CombinationOperator combinationOperator) {
        int n4 = 0;
        int n5 = 0;
        int n6 = bitmap.getRowStride() - 1;
        if (n2 < 0) {
            n5 = -n2;
            n2 = 0;
        } else if (n2 + bitmap.getWidth() > bitmap2.getWidth()) {
            n6 -= bitmap.getWidth() + n2 - bitmap2.getWidth();
        }
        if (n3 < 0) {
            n4 = -n3;
            n3 = 0;
            n5 += bitmap.getRowStride();
            n6 += bitmap.getRowStride();
        } else if (n3 + bitmap.getHeight() > bitmap2.getHeight()) {
            n4 = bitmap.getHeight() + n3 - bitmap2.getHeight();
        }
        int n7 = n2 & 7;
        int n8 = 8 - n7;
        int n9 = bitmap.getWidth() & 7;
        int n10 = n8 - n9;
        boolean bl = (n8 & 7) != 0;
        boolean bl2 = bitmap.getWidth() <= (n6 - n5 << 3) + n8;
        int n11 = bitmap2.getByteIndex(n2, n3);
        int n12 = Math.min(bitmap.getHeight(), n4 + bitmap2.getHeight());
        if (!bl) {
            Bitmaps.blitUnshifted(bitmap, bitmap2, n4, n12, n11, n5, n6, combinationOperator);
        } else if (bl2) {
            Bitmaps.blitSpecialShifted(bitmap, bitmap2, n4, n12, n11, n5, n6, n10, n7, n8, combinationOperator);
        } else {
            Bitmaps.blitShifted(bitmap, bitmap2, n4, n12, n11, n5, n6, n10, n7, n8, combinationOperator, n9);
        }
    }

    private static void blitUnshifted(Bitmap bitmap, Bitmap bitmap2, int n2, int n3, int n4, int n5, int n6, CombinationOperator combinationOperator) {
        int n7 = n2;
        while (n7 < n3) {
            int n8 = n4;
            for (int i2 = n5; i2 <= n6; ++i2) {
                byte by = bitmap2.getByte(n8);
                byte by2 = bitmap.getByte(i2);
                bitmap2.setByte(n8++, Bitmaps.combineBytes(by, by2, combinationOperator));
            }
            ++n7;
            n4 += bitmap2.getRowStride();
            n5 += bitmap.getRowStride();
            n6 += bitmap.getRowStride();
        }
    }

    private static void blitSpecialShifted(Bitmap bitmap, Bitmap bitmap2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, CombinationOperator combinationOperator) {
        int n10 = n2;
        while (n10 < n3) {
            int n11 = 0;
            int n12 = n4;
            for (int i2 = n5; i2 <= n6; ++i2) {
                byte by = bitmap2.getByte(n12);
                n11 = (short)((n11 | bitmap.getByte(i2) & 0xFF) << n9);
                byte by2 = (byte)(n11 >> 8);
                if (i2 == n6) {
                    by2 = Bitmaps.unpad(n7, by2);
                }
                bitmap2.setByte(n12++, Bitmaps.combineBytes(by, by2, combinationOperator));
                n11 = (short)(n11 << n8);
            }
            ++n10;
            n4 += bitmap2.getRowStride();
            n5 += bitmap.getRowStride();
            n6 += bitmap.getRowStride();
        }
    }

    private static void blitShifted(Bitmap bitmap, Bitmap bitmap2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, CombinationOperator combinationOperator, int n10) {
        int n11 = n2;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n4;
            for (int i2 = n5; i2 <= n6; ++i2) {
                byte by = bitmap2.getByte(n13);
                n12 = (short)((n12 | bitmap.getByte(i2) & 0xFF) << n9);
                byte by2 = (byte)(n12 >> 8);
                bitmap2.setByte(n13++, Bitmaps.combineBytes(by, by2, combinationOperator));
                n12 = (short)(n12 << n8);
                if (i2 != n6) continue;
                by2 = (byte)(n12 >> 8 - n9);
                if (n10 != 0) {
                    by2 = Bitmaps.unpad(8 + n7, by2);
                }
                by = bitmap2.getByte(n13);
                bitmap2.setByte(n13, Bitmaps.combineBytes(by, by2, combinationOperator));
            }
            ++n11;
            n4 += bitmap2.getRowStride();
            n5 += bitmap.getRowStride();
            n6 += bitmap.getRowStride();
        }
    }
}

