/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.mmr;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.decoder.mmr.MMRConstants;

public class MMRDecompressor {
    private int width;
    private int height;
    private static final int FIRST_LEVEL_TABLE_SIZE = 8;
    private static final int FIRST_LEVEL_TABLE_MASK = 255;
    private static final int SECOND_LEVEL_TABLE_SIZE = 5;
    private static final int SECOND_LEVEL_TABLE_MASK = 31;
    private static Code[] whiteTable = null;
    private static Code[] blackTable = null;
    private static Code[] modeTable = null;
    private RunData data;

    private static final synchronized void initTables() {
        if (null == whiteTable) {
            whiteTable = MMRDecompressor.createLittleEndianTable(MMRConstants.WhiteCodes);
            blackTable = MMRDecompressor.createLittleEndianTable(MMRConstants.BlackCodes);
            modeTable = MMRDecompressor.createLittleEndianTable(MMRConstants.ModeCodes);
        }
    }

    private final int uncompress2D(RunData runData, int[] nArray, int n2, int[] nArray2, int n3) {
        Code code;
        int n4;
        block26: {
            int n5 = 0;
            n4 = 0;
            int n6 = 0;
            boolean bl = true;
            code = null;
            int n7 = n3;
            nArray[n2 + 1] = n7;
            nArray[n2] = n7;
            int n8 = n3 + 1;
            nArray[n2 + 3] = n8;
            nArray[n2 + 2] = n8;
            try {
                block13: while (n6 < n3) {
                    code = runData.uncompressGetCode(MMRDecompressor.modeTable);
                    if (code == null) {
                        ++runData.offset;
                        break;
                    }
                    runData.offset += code.bitLength;
                    switch (code.runLength) {
                        case 2: {
                            n6 = nArray[n5];
                            break;
                        }
                        case 3: {
                            n6 = nArray[n5] + 1;
                            break;
                        }
                        case 6: {
                            n6 = nArray[n5] - 1;
                            break;
                        }
                        case 1: {
                            int n9 = 1;
                            while (n9 > 0) {
                                code = runData.uncompressGetCode(bl ? MMRDecompressor.whiteTable : MMRDecompressor.blackTable);
                                if (code == null) break block26;
                                runData.offset += code.bitLength;
                                if (code.runLength < 64) {
                                    if (code.runLength < 0) {
                                        nArray2[n4++] = n6;
                                        code = null;
                                        break block26;
                                    }
                                    nArray2[n4++] = n6 += code.runLength;
                                    break;
                                }
                                n6 += code.runLength;
                            }
                            n9 = n6;
                            int n10 = 1;
                            while (n10 > 0) {
                                code = runData.uncompressGetCode(!bl ? MMRDecompressor.whiteTable : MMRDecompressor.blackTable);
                                if (code == null) break block26;
                                runData.offset += code.bitLength;
                                if (code.runLength < 64) {
                                    if (code.runLength < 0) {
                                        nArray2[n4++] = n6;
                                        break block26;
                                    }
                                    if ((n6 += code.runLength) >= n3 && n6 == n9) break;
                                    nArray2[n4++] = n6;
                                    break;
                                }
                                n6 += code.runLength;
                            }
                            while (n6 < n3 && nArray[n5] <= n6) {
                                n5 += 2;
                            }
                            continue block13;
                        }
                        case 0: {
                            int n11 = ++n5;
                            ++n5;
                            n6 = nArray[n11];
                            continue block13;
                        }
                        case 4: {
                            n6 = nArray[n5] + 2;
                            break;
                        }
                        case 7: {
                            n6 = nArray[n5] - 2;
                            break;
                        }
                        case 5: {
                            n6 = nArray[n5] + 3;
                            break;
                        }
                        case 8: {
                            n6 = nArray[n5] - 3;
                            break;
                        }
                        default: {
                            int n10;
                            System.err.println("Should not happen!");
                            if (runData.offset == 12 && code.runLength == -1) {
                                runData.offset = 0;
                                this.uncompress1D(runData, nArray, n3);
                                ++runData.offset;
                                this.uncompress1D(runData, nArray2, n3);
                                n10 = this.uncompress1D(runData, nArray, n3);
                                ++runData.offset;
                                return n10;
                            }
                            n6 = n3;
                            continue block13;
                        }
                    }
                    if (n6 > n3) continue;
                    bl = !bl;
                    nArray2[n4++] = n6;
                    n5 = n5 > 0 ? --n5 : ++n5;
                    while (n6 < n3 && nArray[n5] <= n6) {
                        n5 += 2;
                    }
                }
            }
            catch (Throwable throwable) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("whiteRun           = ");
                stringBuffer.append(bl);
                stringBuffer.append("\n");
                stringBuffer.append("code               = ");
                stringBuffer.append(code);
                stringBuffer.append("\n");
                stringBuffer.append("refOffset          = ");
                stringBuffer.append(n5);
                stringBuffer.append("\n");
                stringBuffer.append("curOffset          = ");
                stringBuffer.append(n4);
                stringBuffer.append("\n");
                stringBuffer.append("bitPos             = ");
                stringBuffer.append(n6);
                stringBuffer.append("\n");
                stringBuffer.append("runData.offset = ");
                stringBuffer.append(runData.offset);
                stringBuffer.append(" ( byte:");
                stringBuffer.append(runData.offset / 8);
                stringBuffer.append(", bit:");
                stringBuffer.append(runData.offset & 7);
                stringBuffer.append(" )");
                System.out.println(stringBuffer.toString());
                return -3;
            }
        }
        if (nArray2[n4] != n3) {
            nArray2[n4] = n3;
        }
        if (code == null) {
            return -1;
        }
        return n4;
    }

    public MMRDecompressor(int n2, int n3, ImageInputStream imageInputStream) {
        this.width = n2;
        this.height = n3;
        this.data = new RunData(imageInputStream);
        MMRDecompressor.initTables();
    }

    public Bitmap uncompress() {
        Bitmap bitmap = new Bitmap(this.width, this.height);
        int[] nArray = new int[this.width + 5];
        int[] nArray2 = new int[this.width + 5];
        nArray2[0] = this.width;
        int n2 = 1;
        int n3 = 0;
        for (int i2 = 0; i2 < this.height && (n3 = this.uncompress2D(this.data, nArray2, n2, nArray, this.width)) != -3; ++i2) {
            if (n3 > 0) {
                this.fillBitmap(bitmap, i2, nArray, n3);
            }
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n2 = n3;
        }
        this.detectAndSkipEOL();
        this.data.align();
        return bitmap;
    }

    private void detectAndSkipEOL() {
        Code code;
        while (null != (code = this.data.uncompressGetCode(MMRDecompressor.modeTable)) && code.runLength == -1) {
            this.data.offset += code.bitLength;
        }
    }

    private void fillBitmap(Bitmap bitmap, int n2, int[] nArray, int n3) {
        int n4 = 0;
        int n5 = bitmap.getByteIndex(0, n2);
        byte by = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = nArray[i2];
            int n7 = (i2 & 1) == 0 ? 0 : 1;
            while (n4 < n6) {
                by = (byte)(by << 1 | n7);
                if ((++n4 & 7) != 0) continue;
                bitmap.setByte(n5++, by);
                by = 0;
            }
        }
        if ((n4 & 7) != 0) {
            by = (byte)(by << 8 - (n4 & 7));
            bitmap.setByte(n5, by);
        }
    }

    private final int uncompress1D(RunData runData, int[] nArray, int n2) {
        boolean bl = true;
        Code code = null;
        int n3 = 0;
        block0: for (int i2 = 0; i2 < n2; i2 += code.runLength) {
            do {
                code = bl ? runData.uncompressGetCode(MMRDecompressor.whiteTable) : runData.uncompressGetCode(MMRDecompressor.blackTable);
                runData.offset += code.bitLength;
                if (code.runLength < 0) break block0;
            } while (code.runLength >= 64);
            bl = !bl;
            nArray[n3++] = i2;
        }
        if (nArray[n3] != n2) {
            nArray[n3] = n2;
        }
        return code != null && code.runLength != -1 ? n3 : -1;
    }

    private static Code[] createLittleEndianTable(int[][] nArray) {
        Code[] codeArray = new Code[256];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2;
            int n3;
            int n4;
            Code code = new Code(nArray[i2]);
            if (code.bitLength <= 8) {
                n4 = 8 - code.bitLength;
                int n5 = code.codeWord << n4;
                for (n3 = (1 << n4) - 1; n3 >= 0; --n3) {
                    n2 = n5 | n3;
                    codeArray[n2] = code;
                }
                continue;
            }
            n4 = code.codeWord >>> code.bitLength - 8;
            if (codeArray[n4] == null) {
                Code code2 = new Code(new int[3]);
                code2.subTable = new Code[32];
                codeArray[n4] = code2;
            }
            if (code.bitLength <= 13) {
                Code[] codeArray2 = codeArray[n4].subTable;
                n3 = 13 - code.bitLength;
                n2 = code.codeWord << n3 & 0x1F;
                for (int i3 = (1 << n3) - 1; i3 >= 0; --i3) {
                    codeArray2[n2 | i3] = code;
                }
                continue;
            }
            throw new IllegalArgumentException("Code table overflow in MMRDecompressor");
        }
        return codeArray;
    }

    private static final class Code {
        Code[] subTable = null;
        final int bitLength;
        final int codeWord;
        final int runLength;

        Code(int[] nArray) {
            this.bitLength = nArray[0];
            this.codeWord = nArray[1];
            this.runLength = nArray[2];
        }

        public String toString() {
            return this.bitLength + "/" + this.codeWord + "/" + this.runLength;
        }

        public boolean equals(Object object) {
            return object instanceof Code && ((Code)object).bitLength == this.bitLength && ((Code)object).codeWord == this.codeWord && ((Code)object).runLength == this.runLength;
        }
    }

    private final class RunData {
        private static final int MAX_RUN_DATA_BUFFER = 131072;
        private static final int MIN_RUN_DATA_BUFFER = 3;
        private static final int CODE_OFFSET = 24;
        ImageInputStream stream;
        int offset;
        int lastOffset = 0;
        int lastCode = 0;
        byte[] buffer;
        int bufferBase;
        int bufferTop;

        RunData(ImageInputStream imageInputStream) {
            this.stream = imageInputStream;
            this.offset = 0;
            this.lastOffset = 1;
            try {
                long l2 = imageInputStream.length();
                l2 = Math.min(Math.max(3L, l2), 131072L);
                this.buffer = new byte[(int)l2];
                this.fillBuffer(0);
            }
            catch (IOException iOException) {
                this.buffer = new byte[10];
                iOException.printStackTrace();
            }
        }

        private final Code uncompressGetCode(Code[] codeArray) {
            return this.uncompressGetCodeLittleEndian(codeArray);
        }

        private final Code uncompressGetCodeLittleEndian(Code[] codeArray) {
            int n2 = this.uncompressGetNextCodeLittleEndian() & 0xFFFFFF;
            Code code = codeArray[n2 >> 16];
            if (null != code && null != code.subTable) {
                code = code.subTable[n2 >> 11 & 0x1F];
            }
            return code;
        }

        private final int uncompressGetNextCodeLittleEndian() {
            try {
                int n2 = this.offset - this.lastOffset;
                if (n2 < 0 || n2 > 24) {
                    int n3 = (this.offset >> 3) - this.bufferBase;
                    if (n3 >= this.bufferTop) {
                        this.fillBuffer(n3 += this.bufferBase);
                        n3 -= this.bufferBase;
                    }
                    this.lastCode = (this.buffer[n3] & 0xFF) << 16 | (this.buffer[n3 + 1] & 0xFF) << 8 | this.buffer[n3 + 2] & 0xFF;
                    int n4 = this.offset & 7;
                    this.lastCode <<= n4;
                } else {
                    int n5 = this.lastOffset & 7;
                    int n6 = 7 - n5;
                    if (n2 <= n6) {
                        this.lastCode <<= n2;
                    } else {
                        int n7 = (this.lastOffset >> 3) + 3 - this.bufferBase;
                        if (n7 >= this.bufferTop) {
                            this.fillBuffer(n7 += this.bufferBase);
                            n7 -= this.bufferBase;
                        }
                        n5 = 8 - n5;
                        do {
                            this.lastCode <<= n5;
                            this.lastCode |= this.buffer[n7] & 0xFF;
                            ++n7;
                        } while ((n2 -= (n5 = 8)) >= 8);
                        this.lastCode <<= n2;
                    }
                }
                this.lastOffset = this.offset;
                return this.lastCode;
            }
            catch (IOException iOException) {
                throw new ArrayIndexOutOfBoundsException("Corrupted RLE data caused by an IOException while reading raw data: " + iOException.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillBuffer(int n2) throws IOException {
            this.bufferBase = n2;
            ImageInputStream imageInputStream = this.stream;
            synchronized (imageInputStream) {
                try {
                    this.stream.seek(n2);
                    this.bufferTop = this.stream.read(this.buffer);
                }
                catch (EOFException eOFException) {
                    this.bufferTop = -1;
                }
                if (this.bufferTop > -1 && this.bufferTop < 3) {
                    int n3 = 0;
                    while (this.bufferTop < 3) {
                        try {
                            n3 = this.stream.read();
                        }
                        catch (EOFException eOFException) {
                            n3 = -1;
                        }
                        this.buffer[this.bufferTop++] = n3 == -1 ? (byte)0 : (byte)(n3 & 0xFF);
                    }
                }
            }
            this.bufferTop -= 3;
            if (this.bufferTop < 0) {
                Arrays.fill(this.buffer, (byte)0);
                this.bufferTop = this.buffer.length - 3;
            }
        }

        private void align() {
            this.offset = this.offset + 7 >> 3 << 3;
        }
    }
}

