/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.huffman;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.decoder.huffman.HuffmanTable;
import org.apache.pdfbox.jbig2.decoder.huffman.Node;
import org.apache.pdfbox.jbig2.decoder.huffman.OutOfBandNode;
import org.apache.pdfbox.jbig2.decoder.huffman.ValueNode;

class InternalNode
extends Node {
    private final int depth;
    private Node zero;
    private Node one;

    protected InternalNode() {
        this.depth = 0;
    }

    protected InternalNode(int n2) {
        this.depth = n2;
    }

    protected void append(HuffmanTable.Code code) {
        if (code.prefixLength == 0) {
            return;
        }
        int n2 = code.prefixLength - 1 - this.depth;
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative shifting is not possible.");
        }
        int n3 = code.code >> n2 & 1;
        if (n2 == 0) {
            if (code.rangeLength == -1) {
                if (n3 == 1) {
                    if (this.one != null) {
                        throw new IllegalStateException("already have a OOB for " + code);
                    }
                    this.one = new OutOfBandNode(code);
                } else {
                    if (this.zero != null) {
                        throw new IllegalStateException("already have a OOB for " + code);
                    }
                    this.zero = new OutOfBandNode(code);
                }
            } else if (n3 == 1) {
                if (this.one != null) {
                    throw new IllegalStateException("already have a ValueNode for " + code);
                }
                this.one = new ValueNode(code);
            } else {
                if (this.zero != null) {
                    throw new IllegalStateException("already have a ValueNode for " + code);
                }
                this.zero = new ValueNode(code);
            }
        } else if (n3 == 1) {
            if (this.one == null) {
                this.one = new InternalNode(this.depth + 1);
            }
            ((InternalNode)this.one).append(code);
        } else {
            if (this.zero == null) {
                this.zero = new InternalNode(this.depth + 1);
            }
            ((InternalNode)this.zero).append(code);
        }
    }

    @Override
    protected long decode(ImageInputStream imageInputStream) throws IOException {
        int n2 = imageInputStream.readBit();
        Node node = n2 == 0 ? this.zero : this.one;
        return node.decode(imageInputStream);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\n");
        this.pad(stringBuilder);
        stringBuilder.append("0: ").append(this.zero).append("\n");
        this.pad(stringBuilder);
        stringBuilder.append("1: ").append(this.one).append("\n");
        return stringBuilder.toString();
    }

    private void pad(StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < this.depth; ++i2) {
            stringBuilder.append("   ");
        }
    }
}

