/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.decoder.arithmetic;

import java.io.IOException;
import org.apache.pdfbox.jbig2.decoder.arithmetic.ArithmeticDecoder;
import org.apache.pdfbox.jbig2.decoder.arithmetic.CX;

public class ArithmeticIntegerDecoder {
    private final ArithmeticDecoder decoder;
    private int prev;

    public ArithmeticIntegerDecoder(ArithmeticDecoder arithmeticDecoder) {
        this.decoder = arithmeticDecoder;
    }

    public long decode(CX cX) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        if (cX == null) {
            cX = new CX(512, 1);
        }
        this.prev = 1;
        cX.setIndex(this.prev);
        int n5 = this.decoder.decode(cX);
        this.setPrev(n5);
        cX.setIndex(this.prev);
        int n6 = this.decoder.decode(cX);
        this.setPrev(n6);
        if (n6 == 1) {
            cX.setIndex(this.prev);
            n6 = this.decoder.decode(cX);
            this.setPrev(n6);
            if (n6 == 1) {
                cX.setIndex(this.prev);
                n6 = this.decoder.decode(cX);
                this.setPrev(n6);
                if (n6 == 1) {
                    cX.setIndex(this.prev);
                    n6 = this.decoder.decode(cX);
                    this.setPrev(n6);
                    if (n6 == 1) {
                        cX.setIndex(this.prev);
                        n6 = this.decoder.decode(cX);
                        this.setPrev(n6);
                        if (n6 == 1) {
                            n3 = 32;
                            n2 = 4436;
                        } else {
                            n3 = 12;
                            n2 = 340;
                        }
                    } else {
                        n3 = 8;
                        n2 = 84;
                    }
                } else {
                    n3 = 6;
                    n2 = 20;
                }
            } else {
                n3 = 4;
                n2 = 4;
            }
        } else {
            n3 = 2;
            n2 = 0;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            cX.setIndex(this.prev);
            n6 = this.decoder.decode(cX);
            this.setPrev(n6);
            n4 = n4 << 1 | n6;
        }
        n4 += n2;
        if (n5 == 0) {
            return n4;
        }
        if (n5 == 1 && n4 > 0) {
            return -n4;
        }
        return Long.MAX_VALUE;
    }

    private void setPrev(int n2) {
        this.prev = this.prev < 256 ? (this.prev << 1 | n2) & 0x1FF : ((this.prev << 1 | n2) & 0x1FF | 0x100) & 0x1FF;
    }

    public int decodeIAID(CX cX, long l2) throws IOException {
        this.prev = 1;
        int n2 = 0;
        while ((long)n2 < l2) {
            cX.setIndex(this.prev);
            this.prev = this.prev << 1 | this.decoder.decode(cX);
            ++n2;
        }
        return this.prev - (1 << (int)l2);
    }
}

