/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class TestImage
extends JFrame {
    private static final long serialVersionUID = 7353175320371957550L;

    public static void main(String[] stringArray) {
        int n2 = 250;
        int n3 = 250;
        int n4 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3 * n4];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)i2;
        }
        new TestImage(byArray, n2, n3, n4);
    }

    public TestImage(byte[] byArray, int n2, int n3, int n4) {
        super("Demobild");
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, new byte[]{-1, 0}, new byte[]{-1, 0}, new byte[]{-1, 0});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n2, n3, 1, n4, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, dataBufferByte, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(indexColorModel, writableRaster, false, null);
        ImageComponent imageComponent = new ImageComponent(bufferedImage);
        JScrollPane jScrollPane = new JScrollPane(imageComponent);
        this.setContentPane(jScrollPane);
        this.pack();
        this.setSize(new Dimension(1600, 900));
        this.setVisible(true);
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public TestImage(BufferedImage bufferedImage) {
        super("Demobild");
        this.setDefaultCloseOperation(3);
        ImageComponent imageComponent = new ImageComponent(bufferedImage);
        imageComponent.setScale(1);
        JScrollPane jScrollPane = new JScrollPane(imageComponent);
        this.setContentPane(jScrollPane);
        this.pack();
        this.setSize(new Dimension(1600, 900));
        this.setVisible(true);
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static class ImageComponent
    extends JComponent {
        private static final long serialVersionUID = -5921296548288376287L;
        Image myImage;
        int imgWidth = -1;
        int imgHeight = -1;
        Dimension prefSize = null;
        private int scale = 1;

        protected ImageComponent() {
        }

        public ImageComponent(Image image) {
            this.setImage(image);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.prefSize != null) {
                return this.prefSize;
            }
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.prefSize != null) {
                return this.prefSize;
            }
            return super.getMinimumSize();
        }

        public void setImage(Image image) {
            if (this.myImage != null) {
                this.myImage.flush();
            }
            this.myImage = image;
            if (this.myImage != null) {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.myImage, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.imgWidth = this.myImage.getWidth(this);
                this.imgHeight = this.myImage.getHeight(this);
                this.setSize(this.imgWidth * this.scale, this.imgHeight * this.scale);
                this.prefSize = this.getSize();
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.myImage != null) {
                graphics2D.scale(this.scale, this.scale);
                graphics2D.drawImage(this.myImage, 1, 1, this.imgWidth, this.imgHeight, this);
            }
        }

        public void setScale(int n2) {
            this.scale = n2;
            this.setSize(this.imgWidth * n2, this.imgHeight * n2);
            this.prefSize = this.getSize();
            this.revalidate();
            this.repaint();
        }

        public int getScale() {
            return this.scale;
        }
    }
}

