/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;

public final class Predictor {
    private Predictor() {
    }

    static void decodePredictorRow(int predictor, int colors, int bitsPerComponent, int columns, byte[] actline, byte[] lastline) {
        if (predictor == 1) {
            return;
        }
        int bitsPerPixel = colors * bitsPerComponent;
        int bytesPerPixel = (bitsPerPixel + 7) / 8;
        int rowlength = actline.length;
        switch (predictor) {
            case 2: {
                if (bitsPerComponent == 8) {
                    for (int p2 = bytesPerPixel; p2 < rowlength; ++p2) {
                        int sub = actline[p2] & 0xFF;
                        int left = actline[p2 - bytesPerPixel] & 0xFF;
                        actline[p2] = (byte)(sub + left);
                    }
                } else if (bitsPerComponent == 16) {
                    for (int p3 = bytesPerPixel; p3 < rowlength; p3 += 2) {
                        int sub = ((actline[p3] & 0xFF) << 8) + (actline[p3 + 1] & 0xFF);
                        int left = ((actline[p3 - bytesPerPixel] & 0xFF) << 8) + (actline[p3 - bytesPerPixel + 1] & 0xFF);
                        actline[p3] = (byte)(sub + left >> 8 & 0xFF);
                        actline[p3 + 1] = (byte)(sub + left & 0xFF);
                    }
                } else if (bitsPerComponent == 1 && colors == 1) {
                    for (int p4 = 0; p4 < rowlength; ++p4) {
                        for (int bit = 7; bit >= 0; --bit) {
                            int sub = actline[p4] >> bit & 1;
                            if (p4 == 0 && bit == 7) continue;
                            int left = bit == 7 ? actline[p4 - 1] & 1 : actline[p4] >> bit + 1 & 1;
                            if ((sub + left & 1) == 0) {
                                int n2 = p4;
                                actline[n2] = (byte)(actline[n2] & ~(1 << bit));
                                continue;
                            }
                            int n3 = p4;
                            actline[n3] = (byte)(actline[n3] | 1 << bit);
                        }
                    }
                } else {
                    int elements = columns * colors;
                    for (int p5 = colors; p5 < elements; ++p5) {
                        int bytePosSub = p5 * bitsPerComponent / 8;
                        int bitPosSub = 8 - p5 * bitsPerComponent % 8 - bitsPerComponent;
                        int bytePosLeft = (p5 - colors) * bitsPerComponent / 8;
                        int bitPosLeft = 8 - (p5 - colors) * bitsPerComponent % 8 - bitsPerComponent;
                        int sub = Predictor.getBitSeq(actline[bytePosSub], bitPosSub, bitsPerComponent);
                        int left = Predictor.getBitSeq(actline[bytePosLeft], bitPosLeft, bitsPerComponent);
                        actline[bytePosSub] = (byte)Predictor.calcSetBitSeq(actline[bytePosSub], bitPosSub, bitsPerComponent, sub + left);
                    }
                }
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                for (int p6 = bytesPerPixel; p6 < rowlength; ++p6) {
                    byte sub = actline[p6];
                    byte left = actline[p6 - bytesPerPixel];
                    actline[p6] = (byte)(sub + left);
                }
                break;
            }
            case 12: {
                for (int p7 = 0; p7 < rowlength; ++p7) {
                    int up = actline[p7] & 0xFF;
                    int prior = lastline[p7] & 0xFF;
                    actline[p7] = (byte)(up + prior & 0xFF);
                }
                break;
            }
            case 13: {
                for (int p8 = 0; p8 < rowlength; ++p8) {
                    int avg = actline[p8] & 0xFF;
                    int left = p8 - bytesPerPixel >= 0 ? actline[p8 - bytesPerPixel] & 0xFF : 0;
                    int up = lastline[p8] & 0xFF;
                    actline[p8] = (byte)(avg + (left + up) / 2 & 0xFF);
                }
                break;
            }
            case 14: {
                for (int p9 = 0; p9 < rowlength; ++p9) {
                    int paeth = actline[p9] & 0xFF;
                    int a2 = p9 - bytesPerPixel >= 0 ? actline[p9 - bytesPerPixel] & 0xFF : 0;
                    int b2 = lastline[p9] & 0xFF;
                    int c2 = p9 - bytesPerPixel >= 0 ? lastline[p9 - bytesPerPixel] & 0xFF : 0;
                    int value = a2 + b2 - c2;
                    int absa = Math.abs(value - a2);
                    int absb = Math.abs(value - b2);
                    int absc = Math.abs(value - c2);
                    actline[p9] = absa <= absb && absa <= absc ? (byte)(paeth + a2 & 0xFF) : (absb <= absc ? (byte)(paeth + b2 & 0xFF) : (byte)(paeth + c2 & 0xFF));
                }
                break;
            }
        }
    }

    static int calculateRowLength(int colors, int bitsPerComponent, int columns) {
        int bitsPerPixel = colors * bitsPerComponent;
        return (columns * bitsPerPixel + 7) / 8;
    }

    static int getBitSeq(int by, int startBit, int bitSize) {
        int mask = (1 << bitSize) - 1;
        return by >>> startBit & mask;
    }

    static int calcSetBitSeq(int by, int startBit, int bitSize, int val) {
        int mask = (1 << bitSize) - 1;
        int truncatedVal = val & mask;
        mask = ~(mask << startBit);
        return by & mask | truncatedVal << startBit;
    }

    static OutputStream wrapPredictor(OutputStream out, COSDictionary decodeParams) {
        int predictor = decodeParams.getInt(COSName.PREDICTOR);
        if (predictor > 1) {
            int colors = Math.min(decodeParams.getInt(COSName.COLORS, 1), 32);
            int bitsPerPixel = decodeParams.getInt(COSName.BITS_PER_COMPONENT, 8);
            int columns = decodeParams.getInt(COSName.COLUMNS, 1);
            return new PredictorOutputStream(out, predictor, colors, bitsPerPixel, columns);
        }
        return out;
    }

    private static final class PredictorOutputStream
    extends FilterOutputStream {
        private int predictor;
        private final int colors;
        private final int bitsPerComponent;
        private final int columns;
        private final int rowLength;
        private final boolean predictorPerRow;
        private byte[] currentRow;
        private byte[] lastRow;
        private int currentRowData = 0;
        private boolean predictorRead = false;

        PredictorOutputStream(OutputStream out, int predictor, int colors, int bitsPerComponent, int columns) {
            super(out);
            this.predictor = predictor;
            this.colors = colors;
            this.bitsPerComponent = bitsPerComponent;
            this.columns = columns;
            this.rowLength = Predictor.calculateRowLength(colors, bitsPerComponent, columns);
            this.predictorPerRow = predictor >= 10;
            this.currentRow = new byte[this.rowLength];
            this.lastRow = new byte[this.rowLength];
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            int currentOffset = off;
            int maxOffset = currentOffset + len;
            while (currentOffset < maxOffset) {
                if (this.predictorPerRow && this.currentRowData == 0 && !this.predictorRead) {
                    this.predictor = bytes[currentOffset] + 10;
                    ++currentOffset;
                    this.predictorRead = true;
                    continue;
                }
                int toRead = Math.min(this.rowLength - this.currentRowData, maxOffset - currentOffset);
                System.arraycopy(bytes, currentOffset, this.currentRow, this.currentRowData, toRead);
                this.currentRowData += toRead;
                currentOffset += toRead;
                if (this.currentRowData != this.currentRow.length) continue;
                this.decodeAndWriteRow();
            }
        }

        private void decodeAndWriteRow() throws IOException {
            Predictor.decodePredictorRow(this.predictor, this.colors, this.bitsPerComponent, this.columns, this.currentRow, this.lastRow);
            this.out.write(this.currentRow);
            this.flipRows();
        }

        private void flipRows() {
            byte[] temp = this.lastRow;
            this.lastRow = this.currentRow;
            this.currentRow = temp;
            this.currentRowData = 0;
            this.predictorRead = false;
        }

        @Override
        public void flush() throws IOException {
            if (this.currentRowData > 0) {
                Arrays.fill(this.currentRow, this.currentRowData, this.rowLength, (byte)0);
                this.decodeAndWriteRow();
            }
            super.flush();
        }

        @Override
        public void write(int i2) throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

