/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.fontencodingpane;

import java.io.IOException;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.debugger.fontencodingpane.FontPane;
import org.apache.pdfbox.debugger.fontencodingpane.SimpleFont;
import org.apache.pdfbox.debugger.fontencodingpane.Type0Font;
import org.apache.pdfbox.debugger.fontencodingpane.Type3Font;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;

public class FontEncodingPaneController {
    private static final Log LOG = LogFactory.getLog(FontEncodingPaneController.class);
    private FontPane fontPane;

    public FontEncodingPaneController(COSName fontName, COSDictionary dictionary) {
        PDResources resources = new PDResources(dictionary);
        try {
            PDFont font = resources.getFont(fontName);
            if (font instanceof PDType3Font) {
                this.fontPane = new Type3Font((PDType3Font)font, resources);
            } else if (font instanceof PDSimpleFont) {
                this.fontPane = new SimpleFont((PDSimpleFont)font);
            } else if (font instanceof PDType0Font) {
                this.fontPane = new Type0Font(((PDType0Font)font).getDescendantFont(), (PDType0Font)font);
            }
        }
        catch (IOException e2) {
            LOG.error(e2.getMessage(), e2);
        }
    }

    public JPanel getPane() {
        if (this.fontPane != null) {
            return this.fontPane.getPanel();
        }
        return null;
    }
}

