/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream.operator.graphics;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.MissingOperandException;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.graphics.GraphicsOperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;

public final class AppendRectangleToPath
extends GraphicsOperatorProcessor {
    @Override
    public void process(Operator operator, List<COSBase> operands) throws IOException {
        if (operands.size() < 4) {
            throw new MissingOperandException(operator, operands);
        }
        if (!this.checkArrayTypesClass(operands, COSNumber.class)) {
            return;
        }
        COSNumber x2 = (COSNumber)operands.get(0);
        COSNumber y2 = (COSNumber)operands.get(1);
        COSNumber w2 = (COSNumber)operands.get(2);
        COSNumber h2 = (COSNumber)operands.get(3);
        float x1 = x2.floatValue();
        float y1 = y2.floatValue();
        float x22 = w2.floatValue() + x1;
        float y22 = h2.floatValue() + y1;
        Point2D.Float p0 = this.context.transformedPoint(x1, y1);
        Point2D.Float p1 = this.context.transformedPoint(x22, y1);
        Point2D.Float p2 = this.context.transformedPoint(x22, y22);
        Point2D.Float p3 = this.context.transformedPoint(x1, y22);
        this.context.appendRectangle(p0, p1, p2, p3);
    }

    @Override
    public String getName() {
        return "re";
    }
}

