/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
final class NIOHeader {
    int length;
    int packetChecksum;
    int flags;
    int headerChecksum;
    int type;
    final SessionAtts session;

    NIOHeader(SessionAtts sessionAtts) {
        this.session = sessionAtts;
    }

    final void readHeaderBuffer() throws IOException, NetException {
        this.session.headerBufferForRead = this.session.readBuffer.slice();
        this.session.headerBufferForRead.clear();
        this.session.headerBufferForRead.limit(8);
        this.session.headerBufferForRead.rewind();
        this.readNSHeader();
    }

    final void readNSHeader() throws IOException {
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
            this.length = this.session.headerBufferForRead.getInt() & 0xFFFFFFFF;
        } else {
            this.length = this.session.headerBufferForRead.getShort() & 0xFFFF;
            this.packetChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
        }
        this.type = this.session.headerBufferForRead.get() & 0xFF;
        this.flags = this.session.headerBufferForRead.get() & 0xFF;
        this.headerChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
    }

    final void fillHeaderBuffer() throws IOException {
        this.session.headerBufferForWrite.clear();
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
            this.session.headerBufferForWrite.putInt(this.length);
        } else {
            this.session.headerBufferForWrite.putShort((short)this.length);
            this.session.headerBufferForWrite.putShort((short)0);
        }
        this.session.headerBufferForWrite.put((byte)this.type);
        this.session.headerBufferForWrite.put((byte)this.flags);
        this.session.headerBufferForWrite.putShort((short)0);
    }

    @Log
    protected void debug(Logger logger2, Level level, Executable executable, String string) {
        ClioSupport.log(logger2, level, this.getClass(), executable, string);
    }
}

