/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleWebRowSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;

    @Override
    public void setFilter(Predicate predicate) throws SQLException {
        this.predicate = predicate;
    }

    @Override
    public Predicate getFilter() {
        return this.predicate;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow >= this.rowCount) {
            return false;
        }
        boolean bl = false;
        do {
            ++this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow <= this.rowCount);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowsetType == 1003) {
            throw (SQLException)DatabaseError.createSqlException(344).fillInStackTrace();
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow <= 1) {
            return false;
        }
        boolean bl = false;
        do {
            --this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            bl = true;
            break;
        } while (this.presentRow >= 1);
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        int n3;
        if (this.rowsetType == 1003) {
            throw (SQLException)DatabaseError.createSqlException(344).fillInStackTrace();
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        int n4 = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.presentRow = 0;
        for (n3 = 0; n3 < n4 && this.presentRow <= this.rowCount; ++n3) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n3 == n4) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    @Override
    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(object, n2)) {
            throw (SQLException)DatabaseError.createSqlException(345).fillInStackTrace();
        }
    }

    @Override
    @Log
    protected void debug(Logger logger2, Level level, Executable executable, String string) {
        ClioSupport.log(logger2, level, this.getClass(), executable, string);
    }
}

