/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.web.health;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import luwa.marlin.web.health.periodic.LastRunResult;

public final class PeriodicalRuns {
    private PeriodicalRuns() {
    }

    public static Map<String, String> expressInDetail(Optional<LastRunResult> lastResult, ZonedDateTime bootTime, Map<String, String> details) {
        details.put("runs_periodically", "true");
        details.put("service_start_date", String.valueOf(bootTime));
        lastResult.ifPresent(last -> {
            details.put("last_run_date", String.valueOf(last.end()));
            details.put("last_run_result", String.valueOf(last.success()));
            details.put("last_run_details", String.valueOf(last.details()));
        });
        return details;
    }

    public static LastRunResult lastRunResultFor(final boolean success, final ZonedDateTime end, final String details) {
        return new LastRunResult(){

            @Override
            public boolean success() {
                return success;
            }

            @Override
            public ZonedDateTime end() {
                return end;
            }

            @Override
            public String details() {
                return details;
            }
        };
    }
}

