/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.web;

import io.undertow.server.HttpServerExchange;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Parameters {
    private final Map<String, Deque<String>> params;

    public Parameters(HttpServerExchange exchange) {
        this(exchange.getQueryParameters());
    }

    public Parameters(Map<String, Deque<String>> params) {
        this.params = params;
    }

    public long mandatoryLong(String name) {
        return Long.parseLong(this.params.get(name).getFirst());
    }

    public Optional<Long> optionalLong(String name) {
        if (!this.exists(name)) {
            return Optional.empty();
        }
        return Optional.of(this.mandatoryLong(name));
    }

    public List<Long> mandatoryLongList(String name) {
        return Arrays.stream(this.mandatoryString(name).split(",")).filter(item -> item.length() > 0).map(Long::parseLong).collect(Collectors.toList());
    }

    public List<Long> longList(String name) {
        return this.stringList(name).stream().map(Long::parseLong).collect(Collectors.toList());
    }

    public int mandatoryInt(String name) {
        return Integer.parseInt(this.params.get(name).getFirst());
    }

    public Optional<Integer> optionalInt(String name) {
        if (!this.exists(name)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.mandatoryInt(name));
        }
        catch (NumberFormatException e2) {
            return Optional.empty();
        }
    }

    public boolean optionalBoolean(String name) {
        return this.exists(name) && "true".equalsIgnoreCase(this.params.get(name).getFirst());
    }

    public boolean bool(String name) {
        return this.exists(name) && "true".equalsIgnoreCase(this.params.get(name).getFirst());
    }

    public List<String> stringList(String name) {
        if (!this.exists(name)) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.params.get(name).getFirst().split(","));
    }

    public String mandatoryString(String name) {
        return this.params.get(name).getFirst();
    }

    public Optional<String> optionalString(String name) {
        if (!this.exists(name)) {
            return Optional.empty();
        }
        return Optional.of(this.mandatoryString(name));
    }

    public Color mandatoryColor(String name) {
        return Color.decode("#" + this.mandatoryString(name));
    }

    public boolean exists(String name) {
        return this.params.containsKey(name) && null != this.params.get(name).getFirst() && !"".equals(this.params.get(name).getFirst());
    }

    public String toString() {
        return this.params.toString();
    }
}

