/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.wasserstand.abflussmessung;

import java.time.Instant;
import java.time.ZonedDateTime;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import luwa.marlin.wasserstand.Parameter;
import luwa.marlin.wasserstand.abflussmessung.Pr\u00fcfstatus;
import luwa.marlin.wasserstand.abflussmessung.Qualit\u00e4t;

public class Abflussmessung {
    private final long id;
    private final ZonedDateTime zeit;
    private final double W;
    private final double Q;
    private final Quantity<Length> minimalerWasserstand;
    private final Quantity<Length> maximalerWasserstand;
    private final Qualit\u00e4t qualit\u00e4t;
    private final Pr\u00fcfstatus pr\u00fcfstatus;
    private final ZonedDateTime messungsStartzeitpunkt;
    private final ZonedDateTime messungsEndzeitpunkt;

    public Abflussmessung(long id, ZonedDateTime zeit, double W, double Q, Quantity<Length> minimalerWasserstand, Quantity<Length> maximalerWasserstand, Qualit\u00e4t qualit\u00e4t, Pr\u00fcfstatus pr\u00fcfstatus, ZonedDateTime messungsStartzeitpunkt, ZonedDateTime messungsEndzeitpunkt) {
        this.id = id;
        this.zeit = zeit;
        this.W = W;
        this.Q = Q;
        this.minimalerWasserstand = minimalerWasserstand;
        this.maximalerWasserstand = maximalerWasserstand;
        this.qualit\u00e4t = qualit\u00e4t;
        this.pr\u00fcfstatus = pr\u00fcfstatus;
        this.messungsStartzeitpunkt = messungsStartzeitpunkt;
        this.messungsEndzeitpunkt = messungsEndzeitpunkt;
    }

    public long id() {
        return this.id;
    }

    public ZonedDateTime zeit() {
        return this.zeit;
    }

    public double W() {
        return this.W;
    }

    public double Q() {
        return this.Q;
    }

    public Qualit\u00e4t qualit\u00e4t() {
        return this.qualit\u00e4t;
    }

    public Pr\u00fcfstatus pr\u00fcfstatus() {
        return this.pr\u00fcfstatus;
    }

    public double wertF\u00fcr(Parameter parameter) {
        if (Parameter.W == parameter) {
            return this.W;
        }
        if (Parameter.Q == parameter) {
            return this.Q;
        }
        throw new IllegalArgumentException("Abflussmessung hat keinen Wert f\u00fcr Parameter " + parameter + ".");
    }

    public ZonedDateTime messungsStartzeitpunkt() {
        return this.messungsStartzeitpunkt;
    }

    public ZonedDateTime messungsEndzeitpunkt() {
        return this.messungsEndzeitpunkt;
    }

    public ZonedDateTime mittlererMesszeitpunkt() {
        long messendeMillis = this.messungsEndzeitpunkt.toInstant().toEpochMilli();
        long messanfangMillis = this.messungsStartzeitpunkt.toInstant().toEpochMilli();
        long diffMillis = messendeMillis - messanfangMillis;
        long mitteMillis = messanfangMillis + diffMillis / 2L;
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(mitteMillis), this.messungsStartzeitpunkt.getZone());
    }

    public Quantity<Length> minimalerWasserstand() {
        return this.minimalerWasserstand;
    }

    public Quantity<Length> maximalerWasserstand() {
        return this.maximalerWasserstand;
    }
}

