/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.wasserstand;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.Pegelnullpunkte;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.wasserstand.abflussmessung.Abflussmessung;

public interface TranformToNHN<VALUE> {
    public VALUE apply(ZonedDateTime var1, VALUE var2, Pegelnullpunkte var3);

    public static <VALUE> Function<Map<ZonedDateTime, VALUE>, Map<ZonedDateTime, VALUE>> transfromFor(WasserstandBezugsh\u00f6he bezugsh\u00f6he, TranformToNHN<VALUE> transformValue, List<Pegelnullpunkt> pegelnullpunkte) {
        return werte -> {
            if (bezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
                return TranformToNHN.transformMapToNHN(werte, new Pegelnullpunkte(pegelnullpunkte), transformValue);
            }
            return werte;
        };
    }

    public static <VALUE> Map<ZonedDateTime, VALUE> transformMapToNHN(Map<ZonedDateTime, VALUE> werteInCMwrtPegellatte, Pegelnullpunkte pegelnullpunkte, TranformToNHN<VALUE> transformValue) {
        HashMap nhnWerteInMeter = new HashMap();
        werteInCMwrtPegellatte.keySet().forEach(zeitpunkt -> {
            Object nhnWertInMeter = transformValue.apply((ZonedDateTime)zeitpunkt, (Object)werteInCMwrtPegellatte.get(zeitpunkt), pegelnullpunkte);
            nhnWerteInMeter.put(zeitpunkt, nhnWertInMeter);
        });
        return nhnWerteInMeter;
    }

    public static Abflussmessung transformAbflussmessungToNHN(ZonedDateTime zeitpunkt, Abflussmessung abflussmessung, Pegelnullpunkte pegelnullpunkte) {
        return new Abflussmessung(abflussmessung.id(), abflussmessung.zeit(), TranformToNHN.transformDoubleValueToNHN(abflussmessung.zeit(), abflussmessung.W(), pegelnullpunkte), abflussmessung.Q(), abflussmessung.minimalerWasserstand(), abflussmessung.maximalerWasserstand(), abflussmessung.qualit\u00e4t(), abflussmessung.pr\u00fcfstatus(), abflussmessung.messungsStartzeitpunkt(), abflussmessung.messungsEndzeitpunkt());
    }

    public static Double transformDoubleValueToNHN(ZonedDateTime zeitpunkt, Double wertInCMwrtPegellatte, Pegelnullpunkte pegelnullpunkte) {
        Optional<Double> m\u00dcberNHNinHS170FallsBekannt = pegelnullpunkte.amZeitpunkt(zeitpunkt).flatMap(Pegelnullpunkt::m\u00dcberNHNInHS170);
        Optional<Double> nhnWertInMeter = m\u00dcberNHNinHS170FallsBekannt.map(\u00fcberNHNInMeter -> {
            if (wertInCMwrtPegellatte == null) {
                return Double.NaN;
            }
            return wertInCMwrtPegellatte * 0.01 + \u00fcberNHNInMeter;
        });
        return nhnWertInMeter.orElse(Double.NaN);
    }

    public static Function<Map<ZonedDateTime, Double>, Map<ZonedDateTime, Double>> doubleMapTransformFor(WasserstandBezugsh\u00f6he bezugsh\u00f6he, List<Pegelnullpunkt> pegelnullpunkte) {
        return TranformToNHN.transfromFor(bezugsh\u00f6he, TranformToNHN::transformDoubleValueToNHN, pegelnullpunkte);
    }

    public static Function<Map<ZonedDateTime, Abflussmessung>, Map<ZonedDateTime, Abflussmessung>> abflussmessungenTransformFor(WasserstandBezugsh\u00f6he bezugsh\u00f6he, List<Pegelnullpunkt> pegelnullpunkte) {
        return TranformToNHN.transfromFor(bezugsh\u00f6he, TranformToNHN::transformAbflussmessungToNHN, pegelnullpunkte);
    }
}

