/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.wasserstand;

import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import luwa.marlin.wasserstand.Pegelnullpunkt;

public class Pegelnullpunkte {
    private final List<Pegelnullpunkt> pegelnullpunkte;

    public Pegelnullpunkte(List<Pegelnullpunkt> pegelnullpunkte) {
        this.pegelnullpunkte = pegelnullpunkte;
        this.pegelnullpunkte.sort(Comparator.comparing(Pegelnullpunkt::g\u00fcltigVon).reversed());
    }

    public Optional<Pegelnullpunkt> amZeitpunkt(ZonedDateTime zeitpunkt) {
        return this.pegelnullpunkte.stream().filter(pegelnullpunkt -> pegelnullpunkt.g\u00fcltigVon().isBefore(zeitpunkt) || pegelnullpunkt.g\u00fcltigVon().isEqual(zeitpunkt)).findFirst();
    }

    public Optional<Pegelnullpunkt> eindeutigImZeitbereich(ZonedDateTime start, ZonedDateTime ende) {
        List kandidaten = this.pegelnullpunkte.stream().filter(pegelnullpunkt -> (pegelnullpunkt.g\u00fcltigVon().isAfter(start) || pegelnullpunkt.g\u00fcltigVon().isEqual(start)) && ende.isAfter(pegelnullpunkt.g\u00fcltigVon())).collect(Collectors.toList());
        if (kandidaten.size() == 1) {
            return Optional.of((Pegelnullpunkt)kandidaten.get(0));
        }
        return Optional.empty();
    }
}

