/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.wasserstand;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Optional;

public class Pegelnullpunkt {
    private final ZonedDateTime g\u00fcltigVon;
    private final double \u00fcberNN;
    private final String einheit;
    private final String h\u00f6hensystem;
    private final Optional<Double> m\u00dcberNNInHS170;
    private static final String h\u00f6hensystemHS170 = "DHHN2016 (HS170)";
    private static final String einheitHS170 = "NHN+m";
    private static final DecimalFormat format = new DecimalFormat("#.00", DecimalFormatSymbols.getInstance(Locale.GERMAN));

    public Pegelnullpunkt(ZonedDateTime g\u00fcltigVon, double \u00fcberNN, String einheit, String h\u00f6hensystem, double m\u00dcberNNInHS170) {
        this.g\u00fcltigVon = g\u00fcltigVon;
        this.\u00fcberNN = \u00fcberNN;
        this.einheit = einheit;
        this.h\u00f6hensystem = h\u00f6hensystem;
        this.m\u00dcberNNInHS170 = Optional.of(m\u00dcberNNInHS170);
    }

    public Pegelnullpunkt(ZonedDateTime g\u00fcltigVon, double \u00fcberNN, String einheit, String h\u00f6hensystem) {
        this.g\u00fcltigVon = g\u00fcltigVon;
        this.\u00fcberNN = \u00fcberNN;
        this.einheit = einheit;
        this.h\u00f6hensystem = h\u00f6hensystem;
        this.m\u00dcberNNInHS170 = h\u00f6hensystem.equals(h\u00f6hensystemHS170) && einheit.equals(einheitHS170) ? Optional.of(\u00fcberNN) : Optional.empty();
    }

    public ZonedDateTime g\u00fcltigVon() {
        return this.g\u00fcltigVon;
    }

    public double \u00fcberNN() {
        return this.\u00fcberNN;
    }

    public String einheit() {
        return this.einheit;
    }

    public String h\u00f6hensystem() {
        return this.h\u00f6hensystem;
    }

    public Optional<Double> m\u00dcberNHNInHS170() {
        return this.m\u00dcberNNInHS170;
    }

    public String darstellung() {
        return this.m\u00dcberNHNInHS170().map(wert -> Pegelnullpunkt.formatiere(wert, einheitHS170, h\u00f6hensystemHS170)).orElse(Pegelnullpunkt.formatiere(this.\u00fcberNN(), this.einheit(), this.h\u00f6hensystem()));
    }

    private static String formatiere(double wert, String einheit, String h\u00f6hensystem) {
        return format.format(wert) + " " + einheit + " " + h\u00f6hensystem;
    }

    public String toString() {
        return this.darstellung();
    }
}

