/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.time;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Objects;
import java.util.Optional;

public class Interval {
    private final ZonedDateTime start;
    private final ZonedDateTime end;

    public Interval(ZonedDateTime start, ZonedDateTime end) {
        this.start = start;
        this.end = end;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public boolean contains(ZonedDateTime date) {
        return !this.start.isAfter(date) && !this.end.isBefore(date);
    }

    public static Optional<Interval> smallestContainingAll(Iterable<ZonedDateTime> times) {
        Optional<Object> start = Optional.empty();
        Optional<Object> end = Optional.empty();
        for (ZonedDateTime time : times) {
            if (start.isPresent()) {
                if (time.isBefore((ChronoZonedDateTime)start.get())) {
                    start = Optional.of(time);
                }
            } else {
                start = Optional.of(time);
            }
            if (!end.isPresent() || !((ZonedDateTime)end.get()).isBefore(time)) continue;
            end = Optional.of(time);
        }
        if (start.isPresent() && end.isPresent()) {
            return Optional.of(new Interval((ZonedDateTime)start.get(), (ZonedDateTime)end.get()));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Interval interval = (Interval)o2;
        return Objects.equals(this.start, interval.start) && Objects.equals(this.end, interval.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

