/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.util.List;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.EinheitlicherPr\u00fcfungszustand;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.Gepr\u00fcfteZeitbereiche;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.Liste;
import luwa.marlin.ship_library.view.text.helpers.Listenprodukt;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import org.joda.time.Interval;

public class WeitereGanglinie
extends Liste {
    private final String ganglinienName;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;

    public WeitereGanglinie(DatenRepository source, List<Long> messstellenNummern, Interval zeitbereich, Parameter parameter, long benutzerId, String ganglinienName, Trennzeichen trennzeichen, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        super(source, messstellenNummern, zeitbereich, parameter, benutzerId, Listenprodukt.weitereGanglinie, false, trennzeichen, wasserstandBezugsh\u00f6he);
        this.ganglinienName = ganglinienName;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
    }

    @Override
    Gepr\u00fcfteZeitbereiche ladeGepr\u00fcfteZeitbereiche(long messstellenNummer) {
        return new EinheitlicherPr\u00fcfungszustand(true);
    }

    @Override
    List<? extends TimestampedValue> werte(long messstellenNummer) throws Exception {
        NHNTransformationOfTimestampedValues transformation = NHNTransformationOfTimestampedValues.buildNHNTransform(messstellenNummer, this.source(), this.wasserstandBezugsh\u00f6he);
        return this.source().weitereGanglinie(messstellenNummer, this.parameter(), this.ganglinienName, this.zeitraum(), transformation);
    }

    @Override
    String resolution(Listenprodukt listenprodukt) {
        return this.ganglinienName;
    }
}

