/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.math.Meaner;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import org.joda.time.Interval;

public class MQundMNQ
implements OutputView {
    private final DatenRepository source;
    private final List<Long> messstellenNummern;
    private final Interval zeitraum;
    private final Trennzeichen trennzeichen;

    public MQundMNQ(DatenRepository source, List<Long> messstellenNummern, Interval zeitraum, Trennzeichen trennzeichen) {
        this.source = source;
        this.messstellenNummern = messstellenNummern;
        this.zeitraum = zeitraum;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "MQ und MNQ";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private Mittelwerte berechneMittelwerte(long messstellenNummer, Interval interval) throws Exception {
        Ausfalljahre ausfalljahre = this.source.ausfalljahre(messstellenNummer, Parameter.q, interval);
        Tagesmittelwerte tagesmittelwerte = this.source.tagesmittelwerte(messstellenNummer, Parameter.q, interval, ausfalljahre, 1.0);
        int startYear = interval.getStart().getYear();
        int endYear = interval.getEnd().getYear();
        Meaner<TimestampedValue> yearsMinMeaner = new Meaner<TimestampedValue>();
        Meaner<TimestampedValue> yearsMeaner = new Meaner<TimestampedValue>();
        for (int year = startYear; year <= endYear; ++year) {
            Abflussjahr abflussjahr = new Abflussjahr(year);
            if (ausfalljahre.contain(abflussjahr)) continue;
            Kalenderjahr kalenderjahr = new Kalenderjahr(year);
            List<Tagesmittelwert> yearNW = tagesmittelwerte.yearNW(kalenderjahr);
            if (yearNW.size() > 0) {
                yearsMinMeaner.add(yearNW.get(0));
            }
            yearsMeaner.add(tagesmittelwerte.yearMW(kalenderjahr));
        }
        return new Mittelwerte(yearsMinMeaner.mean(), yearsMeaner.mean());
    }

    private void writeTo(PrintStream out) throws Exception {
        out.print("Messstellen-Nr");
        this.trennzeichen(out);
        out.print("Standort");
        this.trennzeichen(out);
        out.print("Gew\u00e4sser");
        this.trennzeichen(out);
        out.print("MNQ");
        this.trennzeichen(out);
        out.print("MQ");
        out.println();
        for (long messstellenNummer : this.messstellenNummern) {
            Messstelle messstelle = this.source.messstelle(messstellenNummer);
            Mittelwerte means = this.berechneMittelwerte(messstellenNummer, this.zeitraum);
            out.print(messstelle.nummer());
            this.trennzeichen(out);
            out.print(messstelle.standort());
            this.trennzeichen(out);
            out.print(messstelle.gew\u00e4sser());
            this.trennzeichen(out);
            out.print(Parameter.q.formatValue(means.MNQ()));
            this.trennzeichen(out);
            out.print(Parameter.q.formatValue(means.MQ()));
            out.println();
        }
    }

    private void trennzeichen(PrintStream out) {
        out.print(this.trennzeichen.zeichen());
    }

    private static class Mittelwerte {
        private final TimestampedValue MNQ;
        private final TimestampedValue MQ;

        private Mittelwerte(TimestampedValue MNQ, TimestampedValue MQ) {
            this.MNQ = MNQ;
            this.MQ = MQ;
        }

        private TimestampedValue MNQ() {
            return this.MNQ;
        }

        private TimestampedValue MQ() {
            return this.MQ;
        }
    }
}

