/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.OutputStream;
import luwa.marlin.ship_library.model.Jahreshauptwerte;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.web.OutputView;

public class HauptwerteJson
implements OutputView {
    private final Jahreshauptwerte hauptwerte;

    public HauptwerteJson(Jahreshauptwerte hauptwerte) {
        this.hauptwerte = hauptwerte;
    }

    @Override
    public String name() {
        return "Hauptwerte";
    }

    @Override
    public String contentType() {
        return "text/json";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        try (JsonGenerator json = new JsonFactory().createGenerator(out);){
            json.setPrettyPrinter(new DefaultPrettyPrinter());
            json.writeStartObject();
            json.writeNumberField("N", this.hauptwerte.N());
            json.writeNumberField("N Jahr", this.hauptwerte.NJahr());
            json.writeNumberField("MN", this.hauptwerte.MN());
            json.writeNumberField("M", this.hauptwerte.M());
            json.writeNumberField("MH", this.hauptwerte.MH());
            json.writeNumberField("H", this.hauptwerte.H());
            json.writeNumberField("H Jahr", this.hauptwerte.HJahr());
            json.writeNumberField("NN", this.hauptwerte.NN());
            json.writeStringField("NN Datum", Format.formatDay(this.hauptwerte.NNDatum()));
            json.writeNumberField("HH", this.hauptwerte.HH());
            json.writeStringField("HH Datum", Format.formatDay(this.hauptwerte.HHDatum()));
            json.writeEndObject();
        }
    }
}

