/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.BiFunction;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Dauerzahlen;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.CalendarYearsRange;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.DauertabelleRenderModel;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.ViewHelper;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;
import luwa.marlin.ship_library.view.text.helpers.Padding;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class Dauertabelle
implements OutputView {
    private final Parameter parameter;
    private final Abflussjahresreihe hydrologicalYears;
    private final DatenRepository source;
    private final long messstellenNummer;
    private final long benutzerId;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private NHNTransformationOfTimestampedValues nhntransform;

    public Dauertabelle(long messstellenNummer, Parameter parameter, long benutzerId, Abflussjahresreihe hydrologicalYears, DatenRepository source, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.messstellenNummer = messstellenNummer;
        this.parameter = parameter;
        this.hydrologicalYears = hydrologicalYears;
        this.source = source;
        this.benutzerId = benutzerId;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
    }

    private void writeTo(PrintStream out) throws Exception {
        Messstelle messstelle = this.source.messstelle(this.messstellenNummer);
        Benutzer benutzer = this.source.benutzer(this.benutzerId);
        this.nhntransform = NHNTransformationOfTimestampedValues.buildNHNTransform(this.messstellenNummer, this.source, this.wasserstandBezugsh\u00f6he);
        TabellenHeaderRenderModel header = ViewHelper.headerModel(this.source, messstelle, benutzer, this.wasserstandBezugsh\u00f6he);
        int startYear = ((Abflussjahr)this.hydrologicalYears.startYear()).year();
        int endYear = ((Abflussjahr)this.hydrologicalYears.endYear()).year();
        Interval dataLoadingInterval = new Interval((ReadableInstant)new Abflussjahr(startYear).interval().getStart(), (ReadableInstant)new Kalenderjahr(endYear).interval().getEnd());
        Ausfalljahre ausfalljahre = this.source.ausfalljahre(this.messstellenNummer, this.parameter, dataLoadingInterval);
        int numberOfYears = new CalendarYearsRange(startYear, endYear).numberOfYears() - ausfalljahre.count();
        Tagesmittelwerte values = this.source.tagesmittelwerte(this.messstellenNummer, this.parameter, dataLoadingInterval, ausfalljahre, 1.0, this.nhntransform, TimestampedValue::compareTo);
        luwa.marlin.ship_library.model.Dauertabelle dauertabelle = new luwa.marlin.ship_library.model.Dauertabelle(values, ausfalljahre, this.wasserstandBezugsh\u00f6he);
        this.writeKopf(out, header, endYear, numberOfYears);
        try {
            DauertabelleRenderModel dauertabelleModel = new DauertabelleRenderModel(new Kalenderjahr(endYear), new Abflussjahr(endYear), this.hydrologicalYears, dauertabelle, AbflussOderWasserstand.fromParameter(this.parameter), new WertFormatierer("-", this.wasserstandBezugsh\u00f6he, false));
            this.writeDauertabellen(out, dauertabelleModel);
        }
        catch (Exception e2) {
            this.writeErrorMessage(out, e2);
        }
    }

    private void writeErrorMessage(PrintStream out, Exception e2) {
        out.println("FEHLER: Evtl. fehlen Daten oder NHN-Angaben f\u00fcr einen Pegelnullpunkt.");
    }

    private void writeDauertabellen(PrintStream out, DauertabelleRenderModel dauertabelleRenderModel) {
        BiFunction<DauertabelleRenderModel.Spalte, String, String> model = (spalte, tag) -> dauertabelleRenderModel.model((DauertabelleRenderModel.Spalte)((Object)spalte), Dauerzahlen.AlleTage).get(tag);
        DauertabelleRenderModel.tage(Dauerzahlen.AlleTage).forEach(tag -> {
            out.print(Padding.leftPad(tag, 15));
            out.print(Padding.leftPadAdaptSpaces((String)model.apply(DauertabelleRenderModel.Spalte.abflussjahr, (String)tag), 18));
            out.print(Padding.leftPadAdaptSpaces((String)model.apply(DauertabelleRenderModel.Spalte.kalenderjahr, (String)tag), 11));
            out.print(Padding.leftPadAdaptSpaces((String)model.apply(DauertabelleRenderModel.Spalte.obereH\u00fcllwerte, (String)tag), 14));
            out.print(Padding.leftPadAdaptSpaces((String)model.apply(DauertabelleRenderModel.Spalte.mittlereWerte, (String)tag), 10));
            out.print(Padding.leftPadAdaptSpaces((String)model.apply(DauertabelleRenderModel.Spalte.untereH\u00fcllwerte, (String)tag), 10));
            out.println();
        });
    }

    private void writeKopf(PrintStream out, TabellenHeaderRenderModel header, int endYear, int numberOfYears) {
        String[] parameterAsHeadline = this.parameterBig(this.parameter);
        out.println("      Dauertabelle");
        out.println("                                                           " + parameterAsHeadline[0]);
        out.println("      AEo   : " + Padding.rightPad(header.einzugsgebietF\u00fcrAusgabe(12), 44) + " " + parameterAsHeadline[1] + "      Standort  : " + Padding.rightPad(header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegel), 34) + " Nr.  : " + Padding.leftPad(header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nr), 10));
        out.println("                                                           " + parameterAsHeadline[2]);
        out.println("      PNP   : " + Padding.rightPad(header.nullpunktF\u00fcrAusgabe(12), 44) + " " + parameterAsHeadline[3] + "      Gew\u00e4sser  : " + header.wertF\u00fcr(TabellenHeaderRenderModel.felder.gew\u00e4sser));
        out.println("                                                           " + parameterAsHeadline[4]);
        out.println("      Lage  : " + Padding.rightPad(header.lageF\u00fcrAusgabe(12), 59) + " Teilgebiet: " + Padding.rightPad(header.wertF\u00fcr(TabellenHeaderRenderModel.felder.teilgebiet), 29) + " Datenstand: " + header.wertF\u00fcr(TabellenHeaderRenderModel.felder.datenstand));
        out.println();
        out.println("      Pegelbetreiber: " + Padding.rightPad(header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegelbetreiber), 35) + "Herausgeber: " + Padding.rightPad(header.wertF\u00fcr(TabellenHeaderRenderModel.felder.herausgeber), 55) + " Quelle: " + header.wertF\u00fcr(TabellenHeaderRenderModel.felder.quelle));
        out.println("      _____________________________________________________________________________________________________________________________________");
        out.println();
        out.println("         ----------------" + Padding.pad("Unterschrittene " + this.parameter.namePlural() + " in " + AbflussOderWasserstand.fromParameter(this.parameter).einheitLang(this.wasserstandBezugsh\u00f6he), 39) + "-----------------");
        out.println("           Unter-         Abfluss-  Kalender-     " + this.hydrologicalYears.representation() + Padding.leftPad(String.valueOf(numberOfYears), 4) + " Abflussjahre");
        out.println("           schreitungs-     jahr      jahr          Obere    Mittlere   Untere");
        out.println("           tage             " + endYear + "      " + endYear + "        H\u00fcllwerte    Werte  H\u00fcllwerte");
    }

    @Override
    public String name() {
        return "Dauertabelle";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private String[] parameterBig(Parameter p2) {
        if (p2 == Parameter.q) {
            return new String[]{"  QQQQQ  ", " Q     Q ", " Q     Q ", " Q   Q Q ", "  QQQQQ  "};
        }
        return new String[]{"W       W", "W       W", "W   W   W", " W W W W ", "  W   W  "};
    }
}

