/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import luwa.marlin.ship_library.model.Datenpr\u00fcfung;
import luwa.marlin.ship_library.model.Datenpr\u00fcfungTyp;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import org.joda.time.Interval;

public class Datenpr\u00fcfungen
implements OutputView {
    private final long messstellenNummer;
    private final Datenpr\u00fcfungTyp typ;
    private final Interval zeitraum;
    private final DatenRepository source;
    private final Trennzeichen trennzeichen;

    public Datenpr\u00fcfungen(long messstellenNummer, Datenpr\u00fcfungTyp typ, Interval zeitraum, DatenRepository source, Trennzeichen trennzeichen) {
        this.messstellenNummer = messstellenNummer;
        this.zeitraum = zeitraum;
        this.typ = typ;
        this.source = source;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Datenpr\u00fcfung";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        List<Datenpr\u00fcfung> datenpr\u00fcfungen = this.source.datenpr\u00fcfungen(this.messstellenNummer, this.typ, this.zeitraum);
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream, datenpr\u00fcfungen);
        printStream.flush();
    }

    private void write\u00dcberschriften(PrintStream out) {
        out.print("Messstellen-Nr.");
        this.trennzeichen.trennzeichen(out);
        out.print("Standort");
        this.trennzeichen.trennzeichen(out);
        out.print("Gew\u00e4sser");
        this.trennzeichen.trennzeichen(out);
        out.print("Messnetz");
        this.trennzeichen.trennzeichen(out);
        out.print("Eigent\u00fcmer");
        this.trennzeichen.trennzeichen(out);
        out.print("Betreiber");
        this.trennzeichen.trennzeichen(out);
        out.print("Parameter/Typ");
        this.trennzeichen.trennzeichen(out);
        out.print("Gepr\u00fcft von");
        this.trennzeichen.trennzeichen(out);
        out.print("Gepr\u00fcft bis");
        this.trennzeichen.trennzeichen(out);
        out.print("Organisationseinheiten");
        this.trennzeichen.trennzeichen(out);
        out.print("Pr\u00fcfzeitpunkt");
        this.trennzeichen.trennzeichen(out);
        out.print("Bemerkung");
        out.println();
    }

    private void writeTo(PrintStream out, List<Datenpr\u00fcfung> datenpr\u00fcfungen) throws Exception {
        this.write\u00dcberschriften(out);
        for (Datenpr\u00fcfung datenpr\u00fcfung : datenpr\u00fcfungen) {
            out.print(datenpr\u00fcfung.messtellenNummer());
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.standort());
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.gew\u00e4sser());
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.messnetz());
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.eigent\u00fcmer());
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.betreiber());
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.typ().nameSingular());
            this.trennzeichen.trennzeichen(out);
            out.print(Format.formatFullDayAndTime(datenpr\u00fcfung.zeitraum().getStart()));
            this.trennzeichen.trennzeichen(out);
            out.print(Format.formatFullDayAndTime(datenpr\u00fcfung.zeitraum().getEnd()));
            this.trennzeichen.trennzeichen(out);
            out.print(datenpr\u00fcfung.organisationseinheiten());
            this.trennzeichen.trennzeichen(out);
            out.print(Format.formatFullDayAndTime(datenpr\u00fcfung.zeit()));
            this.trennzeichen.trennzeichen(out);
            out.print(Datenpr\u00fcfungen.ohneZeilenumbr\u00fcche(datenpr\u00fcfung.bemerkung()));
            out.println();
        }
    }

    private static String ohneZeilenumbr\u00fcche(String text) {
        return text.replaceAll("[\\n\\r]+", " ");
    }
}

