/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import luwa.marlin.ship_library.model.Bemerkungstext;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import org.joda.time.Interval;

public class Bemerkungstexte
implements OutputView {
    private final long messstellenNummer;
    private final Parameter parameter;
    private final Interval zeitraum;
    private final DatenRepository source;
    private final Trennzeichen trennzeichen;

    public Bemerkungstexte(long messstellenNummer, Parameter parameter, Interval zeitraum, DatenRepository source, Trennzeichen trennzeichen) {
        this.messstellenNummer = messstellenNummer;
        this.zeitraum = zeitraum;
        this.parameter = parameter;
        this.source = source;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Bemerkungstexte";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        List<Bemerkungstext> bemerkungstexte = this.source.bemerkungstexte(this.messstellenNummer, this.parameter, this.zeitraum);
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream, bemerkungstexte);
        printStream.flush();
    }

    private void write\u00dcberschriften(PrintStream out) throws Exception {
        out.print("Messstellen-Nr.");
        this.trennzeichen.trennzeichen(out);
        out.print("Standort");
        this.trennzeichen.trennzeichen(out);
        out.print("Gew\u00e4sser");
        this.trennzeichen.trennzeichen(out);
        out.print("Messnetz");
        this.trennzeichen.trennzeichen(out);
        out.print("Eigent\u00fcmer");
        this.trennzeichen.trennzeichen(out);
        out.print("Betreiber");
        this.trennzeichen.trennzeichen(out);
        out.print("Parameter");
        this.trennzeichen.trennzeichen(out);
        out.print("Bemerkung von");
        this.trennzeichen.trennzeichen(out);
        out.print("Bemerkung bis");
        this.trennzeichen.trennzeichen(out);
        out.print("Verfassende Institution");
        this.trennzeichen.trennzeichen(out);
        out.print("Schl\u00fcssel");
        this.trennzeichen.trennzeichen(out);
        out.print("Abgearbeitet?");
        this.trennzeichen.trennzeichen(out);
        out.print("Bemerkungstext");
        out.println();
    }

    private void writeTo(PrintStream out, List<Bemerkungstext> bemerkungstexte) throws Exception {
        this.write\u00dcberschriften(out);
        for (Bemerkungstext bemerkungstext : bemerkungstexte) {
            out.print(bemerkungstext.messtellenNummer());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.standort());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.gew\u00e4sser());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.messnetz());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.eigent\u00fcmer());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.betreiber());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.parameter().symbol());
            this.trennzeichen.trennzeichen(out);
            out.print(Format.formatFullDayAndTime(bemerkungstext.zeitraum().getStart()));
            this.trennzeichen.trennzeichen(out);
            out.print(Format.formatFullDayAndTime(bemerkungstext.zeitraum().getEnd()));
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.verfassendeInstitution());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.typ());
            this.trennzeichen.trennzeichen(out);
            out.print(bemerkungstext.abgearbeitet() ? "Ja" : "Nein");
            this.trennzeichen.trennzeichen(out);
            out.print(Bemerkungstexte.ohneZeilenumbr\u00fcche(bemerkungstext.text()));
            out.println();
        }
    }

    private static String ohneZeilenumbr\u00fcche(String text) {
        return text.replaceAll("[\\n\\r]+", " ");
    }
}

