/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.Abflusskurve;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Kurveng\u00fcltigkeit;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.value.WQWert;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.util.UnzureichendeDatenlage;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;
import luwa.marlin.ship_library.view.text.helpers.MetaInformationen;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.Pegelnullpunkte;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.joda.time.DateTime;

public class Abflusskurvenliste
implements OutputView {
    private final Model model;
    private final Trennzeichen trennzeichen;
    private final WertFormatierer wertFormatierer;

    public Abflusskurvenliste(Model model, Trennzeichen trennzeichen) {
        this.model = model;
        this.trennzeichen = trennzeichen;
        this.wertFormatierer = new WertFormatierer("-", model.wasserstandBezugsh\u00f6he(), false);
    }

    @Override
    public String name() {
        return "Abflusskurvenliste";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    public static String textZuKurveng\u00fcltigkeit(Optional<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeit) {
        if (kurveng\u00fcltigkeit.isEmpty()) {
            return "";
        }
        Optional<DateTime> bis = kurveng\u00fcltigkeit.get().bis();
        if (bis.isEmpty()) {
            return "Aktuell g\u00fcltig seit " + Format.formatDay(kurveng\u00fcltigkeit.get().von());
        }
        return "";
    }

    private void writeTo(PrintStream out) throws Exception {
        out.print("Kurventabelle von " + this.model.abflusskurve().name());
        out.print(this.trennzeichen.zeichen());
        out.println(Abflusskurvenliste.textZuKurveng\u00fcltigkeit(this.model.kurveng\u00fcltigkeit()));
        new MetaInformationen(this.model.benutzer(), this.model.messstelle(), this.trennzeichen).writeTo(out);
        if (this.model.wasserstandBezugsh\u00f6he() == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
            Optional<Pegelnullpunkt> maybePNP = this.model.transformation().PNP(Optional.empty());
            if (!maybePNP.isPresent() || !maybePNP.get().m\u00dcberNHNInHS170().isPresent()) {
                out.println("Umrechnung in NHN nicht m\u00f6glich, da kein passender Pegelnullpunkt mit H\u00f6henangabe in DHHN2016 (HS170) gefunden wurde.");
                return;
            }
            out.println("Umrechnung in NHN mit Pegelnullpunkt: NHN + " + Format.formatZeroPoint(maybePNP.get().m\u00dcberNHNInHS170().get()) + " m DHHN2016 (HS170)  G\u00fcltig ab: " + Format.formatFullDayAndTime(maybePNP.get().g\u00fcltigVon()));
            out.print("W NHN+m");
        } else {
            out.print("W in " + Parameter.w.unit());
        }
        out.print(this.trennzeichen.zeichen());
        out.print("Q in " + Parameter.q.unit());
        out.println();
        for (WQWert wertepaar : this.model.abflusskurve().werte()) {
            if (this.model.wasserstandBezugsh\u00f6he() == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
                out.print(this.nhnWasserstandF\u00fcr(this.model.transformation(), wertepaar));
            } else {
                out.print(Parameter.w.formatValue(wertepaar.W()));
            }
            out.print(this.trennzeichen.zeichen());
            out.print(Parameter.q.formatValue(wertepaar.Q()));
            out.println();
        }
    }

    private String nhnWasserstandF\u00fcr(NHNTransformationOfTimestampedValues transformation, WQWert value) {
        if (value.W().istL\u00fccke()) {
            return "";
        }
        return this.wertFormatierer.wasserstandMitInMillimetern(transformation.forValue(value.W().wert()));
    }

    public static class Model {
        private final Messstelle messstelle;
        private final Abflusskurve abflusskurve;
        private final Benutzer benutzer;
        private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
        private final NHNTransformationOfTimestampedValues transformation;
        private final Optional<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeit;

        public Model(Messstelle messstelle, Abflusskurve abflusskurve, Optional<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeit, Benutzer benutzer, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he, NHNTransformationOfTimestampedValues transformation) {
            this.messstelle = messstelle;
            this.abflusskurve = abflusskurve;
            this.kurveng\u00fcltigkeit = kurveng\u00fcltigkeit;
            this.benutzer = benutzer;
            this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
            this.transformation = transformation;
        }

        public Benutzer benutzer() {
            return this.benutzer;
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        public Abflusskurve abflusskurve() {
            return this.abflusskurve;
        }

        public Optional<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeit() {
            return this.kurveng\u00fcltigkeit;
        }

        public static Model lade(DatenRepository source, long abflusskurvenId, long benutzerId, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) throws Exception {
            Abflusskurve abflusskurve = source.abflusskurve(abflusskurvenId);
            Benutzer benutzer = source.benutzer(benutzerId);
            Optional<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeit = source.letzteG\u00fcltigkeitVon(abflusskurvenId);
            Messstelle messstelle = source.messstelle(abflusskurve.messstellenNummer());
            if (wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
                if (kurveng\u00fcltigkeit.isEmpty()) {
                    throw new UnzureichendeDatenlage("Abflusskurve hat keine G\u00fcltigkeit, es ist aber ein Datum f\u00fcr die NHN-Umrechnung n\u00f6tig.");
                }
                ZonedDateTime datumF\u00fcrUmrechnung = kurveng\u00fcltigkeit.get().bis().map(TimestampedValue::jodaDateTimeToZonedDateTime).orElseGet(ZonedDateTime::now);
                List<Pegelnullpunkt> pegelnullpunkte = source.pegelnullpunkte(abflusskurve.messstellenNummer());
                Optional<Pegelnullpunkt> vielleichtPegelnullpunkt = new Pegelnullpunkte(pegelnullpunkte).amZeitpunkt(datumF\u00fcrUmrechnung);
                ArrayList<Pegelnullpunkt> alsListe = new ArrayList<Pegelnullpunkt>();
                vielleichtPegelnullpunkt.map(alsListe::add);
                NHNTransformationOfTimestampedValues transformation = new NHNTransformationOfTimestampedValues(alsListe, wasserstandBezugsh\u00f6he);
                return new Model(messstelle, abflusskurve, kurveng\u00fcltigkeit, benutzer, wasserstandBezugsh\u00f6he, transformation);
            }
            return new Model(messstelle, abflusskurve, kurveng\u00fcltigkeit, benutzer, wasserstandBezugsh\u00f6he, NHNTransformationOfTimestampedValues.doNothing());
        }

        public WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he() {
            return this.wasserstandBezugsh\u00f6he;
        }

        public NHNTransformationOfTimestampedValues transformation() {
            return this.transformation;
        }
    }
}

