/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf.helpers;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.stream.DoubleStream;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class XYStepPathRenderer
extends XYStepRenderer {
    private static final long serialVersionUID = -8918141928884796108L;
    private double stepPoint;

    public XYStepPathRenderer() {
        this(null, null);
    }

    public XYStepPathRenderer(XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        super(toolTipGenerator, urlGenerator);
    }

    @Override
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (this.getItemVisible(series, item)) {
            double yy;
            double xx;
            double transY1;
            XYLineAndShapeRenderer.State s2 = (XYLineAndShapeRenderer.State)state;
            PlotOrientation orientation = plot.getOrientation();
            Paint seriesPaint = this.getItemPaint(series, item);
            Stroke seriesStroke = this.getItemStroke(series, item);
            g2.setPaint(seriesPaint);
            g2.setStroke(seriesStroke);
            double x1 = dataset.getXValue(series, item);
            double y1 = dataset.getYValue(series, item);
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
            double d2 = transY1 = Double.isNaN(y1) ? Double.NaN : rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
            if (pass == 0 && item == s2.getFirstItemIndex() && this.getDrawSeriesLineAsPath()) {
                s2.seriesPath.moveTo(transX1, transY1);
            }
            if (pass == 0 && item > s2.getFirstItemIndex()) {
                double transY0;
                xx = dataset.getXValue(series, item - 1);
                yy = dataset.getYValue(series, item - 1);
                double transX0 = domainAxis.valueToJava2D(xx, dataArea, xAxisLocation);
                double d3 = transY0 = Double.isNaN(yy) ? Double.NaN : rangeAxis.valueToJava2D(yy, dataArea, yAxisLocation);
                if (this.getDrawSeriesLineAsPath()) {
                    if (!Double.isNaN(transX0) && !Double.isNaN(transY0)) {
                        if (orientation == PlotOrientation.HORIZONTAL) {
                            if (transY0 == transY1) {
                                s2.seriesPath.lineTo(transY1, transX1);
                            } else {
                                double domainAxisIndex = transX0 + this.getStepPoint() * (transX1 - transX0);
                                s2.seriesPath.lineTo(transY0, domainAxisIndex);
                                if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
                                    s2.seriesPath.lineTo(transY1, domainAxisIndex);
                                    if (domainAxisIndex != transX1) {
                                        s2.seriesPath.lineTo(transY1, transX1);
                                    }
                                }
                            }
                        } else if (orientation == PlotOrientation.VERTICAL) {
                            if (transY0 == transY1) {
                                s2.seriesPath.lineTo(transX1, transY1);
                            } else {
                                double domainAxisIndex = transX0 + this.getStepPoint() * (transX1 - transX0);
                                s2.seriesPath.lineTo(domainAxisIndex, transY0);
                                if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
                                    s2.seriesPath.lineTo(domainAxisIndex, transY1);
                                    if (domainAxisIndex != transX1) {
                                        s2.seriesPath.lineTo(transX1, transY1);
                                    }
                                }
                            }
                        }
                    } else if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
                        if (orientation == PlotOrientation.HORIZONTAL) {
                            s2.seriesPath.moveTo(transY1, transX1);
                        } else if (orientation == PlotOrientation.VERTICAL) {
                            s2.seriesPath.moveTo(transX1, transY1);
                        }
                    }
                } else if (orientation == PlotOrientation.HORIZONTAL) {
                    if (transY0 == transY1) {
                        this.drawLine(g2, state.workingLine, transY0, transX0, transY1, transX1);
                    } else {
                        double domainAxisIndex = transX0 + this.getStepPoint() * (transX1 - transX0);
                        this.drawLine(g2, state.workingLine, transY0, transX0, transY0, domainAxisIndex);
                        this.drawLine(g2, state.workingLine, transY0, domainAxisIndex, transY1, domainAxisIndex);
                        if (domainAxisIndex != transX1) {
                            this.drawLine(g2, state.workingLine, transY1, domainAxisIndex, transY1, transX1);
                        }
                    }
                } else if (orientation == PlotOrientation.VERTICAL) {
                    if (transY0 == transY1) {
                        this.drawLine(g2, state.workingLine, transX0, transY0, transX1, transY1);
                    } else {
                        double domainAxisIndex = transX0 + this.getStepPoint() * (transX1 - transX0);
                        this.drawLine(g2, state.workingLine, transX0, transY0, domainAxisIndex, transY0);
                        this.drawLine(g2, state.workingLine, domainAxisIndex, transY0, domainAxisIndex, transY1);
                        if (domainAxisIndex != transX1) {
                            this.drawLine(g2, state.workingLine, domainAxisIndex, transY1, transX1, transY1);
                        }
                    }
                }
                int domainAxisIndex1 = plot.getDomainAxisIndex(domainAxis);
                int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
                this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex1, rangeAxisIndex, transX1, transY1, orientation);
                EntityCollection entities = state.getEntityCollection();
                if (entities != null) {
                    this.addEntity(entities, null, dataset, series, item, transX1, transY1);
                }
                if (item == s2.getLastItemIndex()) {
                    this.drawFirstPassShape(g2, pass, series, item, s2.seriesPath);
                }
            }
            if (pass == 1 && this.isItemLabelVisible(series, item)) {
                xx = transX1;
                yy = transY1;
                if (orientation == PlotOrientation.HORIZONTAL) {
                    xx = transY1;
                    yy = transX1;
                }
                this.drawItemLabel(g2, orientation, dataset, series, item, xx, yy, y1 < 0.0);
            }
        }
    }

    private void drawLine(Graphics2D g2, Line2D line, double x0, double y0, double x1, double y1) {
        if (DoubleStream.of(x0, x1, y0, y1).noneMatch(Double::isNaN)) {
            line.setLine(x0, y0, x1, y1);
            g2.draw(line);
        }
    }
}

