/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf.helpers;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.util.OptionalMitMarkierung;
import luwa.marlin.ship_library.util.UnzureichendeDatenlage;
import luwa.marlin.ship_library.util.math.DecimalArithmetic;
import luwa.marlin.ship_library.view.pdf.helpers.FehlenderWertFehler;
import luwa.marlin.ship_library.view.pdf.helpers.FehlerInformation;
import luwa.marlin.ship_library.view.pdf.helpers.FormatierungsErgebnis;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import org.joda.time.DateTime;

public class WertFormatierer {
    private final String zeichenFuerFehlendeWerte;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final boolean l\u00fcckeFormatierenIstFehler;
    private static final String figureSpace = "  ";
    private static final String kommaLeerzeichen = " ";

    public WertFormatierer() {
        this("-");
    }

    public WertFormatierer(String zeichenFuerFehlendeWerte) {
        this(zeichenFuerFehlendeWerte, WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt, true);
    }

    public WertFormatierer(String zeichenFuerFehlendeWerte, boolean l\u00fcckeFormatierenIstFehler) {
        this(zeichenFuerFehlendeWerte, WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt, l\u00fcckeFormatierenIstFehler);
    }

    public WertFormatierer(String zeichenFuerFehlendeWerte, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he, boolean l\u00fcckeFormatierenIstFehler) {
        this.zeichenFuerFehlendeWerte = zeichenFuerFehlendeWerte;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
        this.l\u00fcckeFormatierenIstFehler = l\u00fcckeFormatierenIstFehler;
    }

    public String nurSignifikanteStellenVonTimeStampedValue(Optional<? extends TimestampedValue> wert, AbflussOderWasserstand QoderW) {
        return this.nurSignifikanteStellenVonTimeStampedValue(wert, QoderW, this.wasserstandBezugsh\u00f6he);
    }

    public String nurSignifikanteStellenVonTimeStampedValue(Optional<? extends TimestampedValue> wert, AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        if (this.l\u00fcckeFormatierenIstFehler) {
            return this.nurSignifikanteStellen(wert.flatMap(TimestampedValue::toOptional).map(TimestampedValue::wert), QoderW, wasserstandBezugsh\u00f6he);
        }
        return this.nurSignifikanteStellen(wert.flatMap(TimestampedValue::toOptional).flatMap(TimestampedValue::vielleichtWert), QoderW, wasserstandBezugsh\u00f6he);
    }

    public FormatierungsErgebnis nurSignifikanteStellenVonTimeStampedValue(Optional<? extends TimestampedValue> wert, AbflussOderWasserstand QoderW, FehlerInformation fehlerInformation) {
        return this.nurSignifikanteStellenVonTimeStampedValue(wert, QoderW, this.wasserstandBezugsh\u00f6he, fehlerInformation);
    }

    public FormatierungsErgebnis nurSignifikanteStellenVonTimeStampedValue(Optional<? extends TimestampedValue> wert, AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he, FehlerInformation fehlerInformation) {
        try {
            return new FormatierungsErgebnis(this.nurSignifikanteStellenVonTimeStampedValue(wert, QoderW, wasserstandBezugsh\u00f6he));
        }
        catch (UnzureichendeDatenlage unzureichendeDatenlage) {
            return new FormatierungsErgebnis(this.zeichenFuerFehlendeWerte, Optional.of(new FehlenderWertFehler(fehlerInformation, wert.flatMap(TimestampedValue::zeitpunkt))));
        }
    }

    public String nurSignifikanteStellen(Optional<Double> wert, AbflussOderWasserstand QoderW) {
        return this.nurSignifikanteStellen(wert, QoderW, this.wasserstandBezugsh\u00f6he);
    }

    public String nurSignifikanteStellen(Optional<Double> wert, AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        if (wert.isPresent()) {
            switch (QoderW) {
                case Q: {
                    return this.formatValuePaddedQ(wert.get());
                }
                case W: {
                    return this.formatValueW(wert.get(), wasserstandBezugsh\u00f6he);
                }
            }
            throw new IllegalStateException("Missing case.");
        }
        return this.zeichenFuerFehlendeWerte;
    }

    public String nurSignifikanteStellenNoPadding(Optional<Double> wert, AbflussOderWasserstand QoderW) {
        if (wert.isPresent()) {
            switch (QoderW) {
                case Q: {
                    return this.formatValueQ(wert.get());
                }
                case W: {
                    return this.formatValueW(wert.get(), this.wasserstandBezugsh\u00f6he);
                }
            }
            throw new IllegalStateException("Missing case.");
        }
        return this.zeichenFuerFehlendeWerte;
    }

    public String wasserstandMitInMillimetern(Double wert) {
        switch (this.wasserstandBezugsh\u00f6he) {
            case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                return new DecimalFormat("#.0").format(DecimalArithmetic.RoundWithAssumedPrecision(wert, 6, 1)).replace('.', ',');
            }
            case Meter\u00dcberNHNnachHS170: {
                return new DecimalFormat("#.000").format(DecimalArithmetic.RoundWithAssumedPrecision(wert, 8, 3)).replace('.', ',');
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.wasserstandBezugsh\u00f6he);
    }

    public String mitEinheitNoPadding(Optional<Double> wert, AbflussOderWasserstand QoderW) {
        switch (QoderW) {
            case Q: {
                return this.nurSignifikanteStellenNoPadding(wert, QoderW) + " m\u00b3/s";
            }
            case W: {
                switch (this.wasserstandBezugsh\u00f6he) {
                    case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                        return this.nurSignifikanteStellenNoPadding(wert, QoderW) + " cm";
                    }
                    case Meter\u00dcberNHNnachHS170: {
                        return this.nurSignifikanteStellenNoPadding(wert, QoderW) + " NHN+m (HS170)";
                    }
                }
                throw new IllegalStateException("Unexpected value: " + this.wasserstandBezugsh\u00f6he);
            }
        }
        throw new IllegalStateException("Unexpected value: " + QoderW);
    }

    public String nurSignifikanteStellen(double wert, AbflussOderWasserstand QoderW) {
        return this.nurSignifikanteStellen(Optional.of(wert), QoderW);
    }

    public String datumMitMehrfachMarkierung(OptionalMitMarkierung<? extends TimestampedValue> wertMitVielfachheit) {
        Optional<TimestampedValue> timestampedValue = wertMitVielfachheit.timestampedValue();
        String mehrfachMarkierung = wertMitVielfachheit.mehrfach() ? " +" : "";
        return timestampedValue.map(wert -> this.datum(wert.timestamp()) + mehrfachMarkierung).orElse(this.zeichenF\u00fcrFehlendeWerte());
    }

    public String datum(OptionalMitMarkierung<? extends TimestampedValue> wertMitVielfachheit) {
        return wertMitVielfachheit.timestampedValue().map(wert -> this.datum(wert.timestamp())).orElse(this.zeichenF\u00fcrFehlendeWerte());
    }

    public String datum(DateTime datum) {
        return Format.formatDay(datum);
    }

    public String jahrMitMehrfachMarkierung(OptionalMitMarkierung<? extends TimestampedValue> wertMitVielfachheit) {
        Optional<Integer> jahrOptional = wertMitVielfachheit.jahr();
        String mehrfachMarkierung = wertMitVielfachheit.mehrfach() ? " +" : "";
        return jahrOptional.map(jahr -> jahr + mehrfachMarkierung).orElse("");
    }

    public String tagDesMonatsMitMehrfachMarkierung(OptionalMitMarkierung<? extends TimestampedValue> wertMitVielfachheit) {
        Optional<Integer> tagOptional = wertMitVielfachheit.day();
        String mehrfachMarkierung = wertMitVielfachheit.mehrfach() ? " +" : "";
        return tagOptional.map(tag -> tag + "." + mehrfachMarkierung).orElse("");
    }

    public String tagDesMonats(TimestampedValue wertMitVielfachheit) {
        return this.tagDesMonats(new OptionalMitMarkierung<TimestampedValue>(wertMitVielfachheit));
    }

    public String tagDesMonats(OptionalMitMarkierung<? extends TimestampedValue> wertMitVielfachheit) {
        return wertMitVielfachheit.day().map(tag -> tag + ".").orElse("");
    }

    public String uhrzeit(TimestampedValue wertMitVielfachheit) {
        return this.uhrzeit(new OptionalMitMarkierung<TimestampedValue>(wertMitVielfachheit));
    }

    public String uhrzeit(OptionalMitMarkierung<? extends TimestampedValue> wertMitVielfachheit) {
        Optional<DateTime> zeitpunkt = wertMitVielfachheit.timestampedValue().map(TimestampedValue::timestamp);
        return zeitpunkt.map(Format::formatTime).orElseGet(this::zeichenF\u00fcrFehlendeWerte);
    }

    public String nurSignifikanteStellenF\u00fcrSpende(Optional<Double> wert) {
        return wert.map(this::formatValuePaddedQ).orElseGet(this::zeichenF\u00fcrFehlendeWerte);
    }

    public String zeichenF\u00fcrFehlendeWerte() {
        return this.zeichenFuerFehlendeWerte;
    }

    public double gerundeterWert(double wert, AbflussOderWasserstand abflussOderWasserstand, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        switch (abflussOderWasserstand) {
            case Q: {
                BigDecimal bd = new BigDecimal(wert);
                bd = bd.round(new MathContext(3));
                return bd.doubleValue();
            }
            case W: {
                switch (wasserstandBezugsh\u00f6he) {
                    case Meter\u00dcberNHNnachHS170: {
                        return DecimalArithmetic.RoundWithAssumedPrecision(wert, 8, 2).doubleValue();
                    }
                    case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                        return Math.round(wert);
                    }
                }
                throw new IllegalArgumentException(wasserstandBezugsh\u00f6he.toString());
            }
        }
        throw new IllegalArgumentException(abflussOderWasserstand.toString());
    }

    private String formatValueQ(double wert) {
        BigDecimal bd = new BigDecimal(wert);
        if ((bd = bd.round(new MathContext(3))).doubleValue() < 1.0) {
            return new DecimalFormat("0.000").format(bd).replace('.', ',');
        }
        if (bd.doubleValue() < 10.0) {
            return new DecimalFormat("#.00").format(bd).replace('.', ',');
        }
        if (bd.doubleValue() < 100.0) {
            return new DecimalFormat("##.0").format(bd).replace('.', ',');
        }
        return bd.toPlainString().replace('.', ',');
    }

    private String formatValuePaddedQ(double value) {
        String formatted = this.formatValueQ(value);
        Object rightPad = kommaLeerzeichen + Format.repeat(figureSpace, 3);
        int indexOfComma = formatted.indexOf(",");
        if (indexOfComma >= 0) {
            rightPad = Format.repeat(figureSpace, 3 - (formatted.length() - indexOfComma - 1));
        }
        return formatted + (String)rightPad;
    }

    private String formatValueW(double value, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        switch (wasserstandBezugsh\u00f6he) {
            case Meter\u00dcberNHNnachHS170: {
                return new DecimalFormat("#.00").format(DecimalArithmetic.RoundWithAssumedPrecision(value, 8, 2)).replace('.', ',');
            }
            case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                return String.valueOf(Math.round(value));
            }
        }
        throw new IllegalArgumentException(wasserstandBezugsh\u00f6he.toString());
    }
}

