/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import luwa.marlin.ship_library.view.pdf.helpers.Rendering;
import luwa.marlin.ship_library.view.pdf.helpers.TextBuilder;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class Column {
    private final List<Row> rows;
    private final float lineHeightOffset;
    private final PDFont font;
    private final float fontSize;

    public Column(PDFont font, float fontSize) {
        this(0.0f, font, fontSize);
    }

    public Column(float lineHeightOffset, PDFont font, float fontSize) {
        this.lineHeightOffset = lineHeightOffset;
        this.font = font;
        this.fontSize = fontSize;
        this.rows = new ArrayList<Row>();
    }

    public void add(String rowContent) {
        this.add(new Rendering.Text(rowContent, this.font, this.fontSize));
    }

    public void add(Rendering.TextRenderable rowContent) {
        this.rows.add(new Row(rowContent));
    }

    public void addWithAddOn(String rowContent, String addOn) {
        this.rows.add(new Row(new Rendering.Text(rowContent, this.font, this.fontSize), addOn));
    }

    public void addWithAddOn(Rendering.TextRenderable rowContent, String addOn) {
        this.rows.add(new Row(rowContent, addOn));
    }

    public void draw(PDPageContentStream content, float x2, float y2) throws IOException {
        float lineHeight = this.font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * this.fontSize;
        content.beginText();
        content.newLineAtOffset(x2, y2);
        for (Row row : this.rows) {
            row.text().render(content);
            content.newLineAtOffset(0.0f, -(lineHeight + this.lineHeightOffset));
        }
        content.endText();
    }

    public void drawRightAligned(PDPageContentStream content, float x2, float y2) throws IOException {
        float lineHeight = this.font.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * this.fontSize;
        content.beginText();
        content.newLineAtOffset(x2, y2);
        for (Row row : this.rows) {
            new Rendering.RightAligned(row.text()).render(content);
            if (row.hasAddOn()) {
                float addOnXOffset = 2.0f;
                content.newLineAtOffset(2.0f, 0.0f);
                content.showText(row.addOn());
                content.newLineAtOffset(-2.0f, 0.0f);
            }
            content.newLineAtOffset(0.0f, -(lineHeight + this.lineHeightOffset));
        }
        content.endText();
    }

    public TextBuilder text() {
        return new TextBuilder(this.font, this.fontSize);
    }

    private static class Row {
        private final Rendering.TextRenderable text;
        private final String addOn;

        public Row(Rendering.TextRenderable text) {
            this(text, null);
        }

        public Row(Rendering.TextRenderable text, String addOn) {
            this.text = text;
            this.addOn = addOn;
        }

        public Rendering.TextRenderable text() {
            return this.text;
        }

        public String addOn() {
            return this.addOn;
        }

        public boolean hasAddOn() {
            return null != this.addOn();
        }
    }
}

