/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Aufl\u00f6sung;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Stundenmittelwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.Stundenmittelwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.pdf.helpers.Chart;
import luwa.marlin.ship_library.view.pdf.helpers.MonthlyTicks;
import luwa.marlin.ship_library.view.pdf.helpers.XYStepPathRenderer;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.LogTick;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.text.TextUtilities;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ShapeUtilities;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class Wertegrafik
implements OutputView {
    private final long messstellenNummer;
    private final Parameter parameter;
    private final DatenRepository datenRepository;
    private final Color color;
    private final Aufl\u00f6sung aufl\u00f6sung;
    private final boolean showPeaks;
    private final Optional<Integer> wMin;
    private final Optional<Integer> wMax;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;

    public Wertegrafik(long messstellenNummer, Parameter parameter, DatenRepository datenRepository, Color color, Aufl\u00f6sung aufl\u00f6sung, boolean showPeaks, Optional<Integer> wMin, Optional<Integer> wMax, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.messstellenNummer = messstellenNummer;
        this.parameter = parameter;
        this.datenRepository = datenRepository;
        this.color = color;
        this.aufl\u00f6sung = aufl\u00f6sung;
        this.showPeaks = showPeaks;
        this.wMin = wMin;
        this.wMax = wMax;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
    }

    protected abstract Interval interval();

    private DateTickUnit dateTickUnit() {
        if (Days.daysIn(this.interval()).getDays() <= 0) {
            return new HourlyTicks();
        }
        if (Days.daysIn(this.interval()).getDays() <= 2) {
            return new HourlyTicks(3);
        }
        if (Days.daysIn(this.interval()).getDays() <= 7) {
            return new HourlyTicks(6);
        }
        if (Days.daysIn(this.interval()).getDays() <= 30) {
            return new DailyTicks(1);
        }
        if (Days.daysIn(this.interval()).getDays() <= 125) {
            return new WeeklyTicks(this.interval().getStart());
        }
        if (Days.daysIn(this.interval()).getDays() <= 220) {
            return new WeeklyTicks(this.interval().getStart(), 2, 14);
        }
        if (Years.yearsIn(this.interval()).getYears() <= 1) {
            return new MonthlyTicks();
        }
        if (Years.yearsIn(this.interval()).getYears() <= 25) {
            return new YearlyTicks(1);
        }
        if (Years.yearsIn(this.interval()).getYears() <= 100) {
            return new YearlyTicks(5);
        }
        return new YearlyTicks(10);
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        Chart.writeAsPDF(out, this.chart());
    }

    private RegularTimePeriod periodOf(DateTime ts) {
        return new FixedMillisecond(ts.toDate().getTime());
    }

    private ChartData data() throws Exception {
        TimeSeries series;
        Object values;
        TimeSeries peakSeries = new TimeSeries((Comparable)((Object)(this.parameter.symbol() + " Scheitelwerte")));
        NHNTransformationOfTimestampedValues transformation = NHNTransformationOfTimestampedValues.buildNHNTransform(this.messstellenNummer, this.datenRepository, this.wasserstandBezugsh\u00f6he);
        for (Scheitelwert peak : this.datenRepository.scheitelwerte(this.messstellenNummer, this.parameter, this.interval(), Ausfalljahre.keine, 1.0, transformation).values()) {
            if (peak.istL\u00fccke()) continue;
            peakSeries.add(this.periodOf(peak.timestamp()), peak.wert());
        }
        if (this.aufl\u00f6sung == Aufl\u00f6sung.stunden15MinutenMittel) {
            values = this.datenRepository.stunden15MinutenMittelwerte(this.messstellenNummer, this.parameter, this.interval(), 1.0, transformation);
            series = new TimeSeries((Comparable)((Object)(this.parameter.symbol() + " 15min-Mittel")));
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                TimestampedValue value = (TimestampedValue)iterator.next();
                DateTime ts = value.timestamp();
                RegularTimePeriod h2 = this.periodOf(ts);
                if (value.istL\u00fccke()) {
                    series.add(h2, null);
                    continue;
                }
                series.add(h2, value.wert());
            }
            return new ChartData(series, peakSeries);
        }
        if (this.aufl\u00f6sung == Aufl\u00f6sung.stundenmittel) {
            values = this.datenRepository.stundenmittelwerte(this.messstellenNummer, this.parameter, this.interval(), Ausfalljahre.keine, 1.0, transformation);
            series = new TimeSeries((Comparable)((Object)(this.parameter.symbol() + " Stundenmittel")));
            for (Stundenmittelwert value : ((Stundenmittelwerte)values).values()) {
                DateTime ts = value.timestamp();
                RegularTimePeriod h3 = this.periodOf(ts);
                if (value.istL\u00fccke()) {
                    series.add(h3, null);
                    continue;
                }
                series.add(h3, value.wert());
            }
            return new ChartData(series, peakSeries);
        }
        if (this.aufl\u00f6sung == Aufl\u00f6sung.tagesmittel) {
            values = this.datenRepository.tagesmittelwerte(this.messstellenNummer, this.parameter, this.interval(), Ausfalljahre.keine, 1.0, transformation, TimestampedValue::compareTo);
            series = new TimeSeries((Comparable)((Object)(this.parameter.symbol() + " Tagesmittel")));
            for (Tagesmittelwert value : ((Tagesmittelwerte)values).values()) {
                DateTime ts = value.timestamp();
                RegularTimePeriod h4 = this.periodOf(ts);
                if (value.istL\u00fccke()) {
                    series.add(h4, null);
                    continue;
                }
                series.add(h4, value.wert());
            }
            return new ChartData(series, peakSeries);
        }
        throw new IllegalArgumentException("Aufl\u00f6sung '" + this.aufl\u00f6sung + "' wird nicht unterst\u00fctzt");
    }

    private String contentTitle() {
        return this.name() + " " + this.contentParameterAndResolution();
    }

    private String contentParameterAndResolution() {
        if (this.aufl\u00f6sung == Aufl\u00f6sung.stunden15MinutenMittel) {
            return this.parameter.symbol() + " 15min-Mittel";
        }
        if (this.aufl\u00f6sung == Aufl\u00f6sung.stundenmittel) {
            return this.parameter.symbol() + " Stundenmittel";
        }
        if (this.aufl\u00f6sung == Aufl\u00f6sung.tagesmittel) {
            return this.parameter.symbol() + " Tagesmittel";
        }
        return "";
    }

    private JFreeChart chart() throws Exception {
        Messstelle messstelle = this.datenRepository.messstelle(this.messstellenNummer);
        ChartData data = this.data();
        TimeSeries series = data.timeSeries();
        TimeSeriesCollection dataset = new TimeSeriesCollection(TimeZone.getTimeZone("GMT+1:00"));
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createTimeSeriesChart(this.messstellenNummer + " - " + messstelle.standort() + " - " + messstelle.gew\u00e4sser(), "Zeit", this.parameter.symbol() + " in " + AbflussOderWasserstand.fromParameter(this.parameter).einheitLang(this.wasserstandBezugsh\u00f6he), dataset, true, false, false);
        chart.setBackgroundPaint(Color.white);
        chart.setBackgroundImageAlpha(0.0f);
        Font arial = new Font("Arial", 0, 14);
        chart.getTitle().setFont(arial);
        chart.getTitle().setPadding(10.0, 1.0, 1.0, 1.0);
        chart.getLegend().setItemFont(arial);
        chart.getLegend().setMargin(0.0, 0.0, 20.0, 0.0);
        TextTitle dataStatus = new TextTitle("Stand: " + Format.formatDay(new DateTime()));
        dataStatus.setFont(arial.deriveFont(12.0f));
        dataStatus.setPosition(RectangleEdge.TOP);
        dataStatus.setTextAlignment(HorizontalAlignment.RIGHT);
        dataStatus.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        dataStatus.setPadding(1.0, 1.0, 1.0, 12.0);
        dataStatus.setMargin(-16.0, 0.0, 0.0, 0.0);
        chart.addSubtitle(dataStatus);
        TextTitle type = new TextTitle(this.contentTitle());
        type.setFont(arial.deriveFont(12.0f));
        type.setPosition(RectangleEdge.TOP);
        type.setTextAlignment(HorizontalAlignment.LEFT);
        type.setHorizontalAlignment(HorizontalAlignment.LEFT);
        type.setPadding(1.0, 1.0, 1.0, 1.0);
        type.setMargin(-16.0, 50.0, 0.0, 0.0);
        chart.addSubtitle(type);
        XYPlot plot = chart.getXYPlot();
        MonthBasedDateAxis x2 = new MonthBasedDateAxis("Zeit (" + Format.formatDay(this.interval().getStart()) + " - " + Format.formatDay(this.interval().getEnd()) + ")", TimeZone.getTimeZone("GMT+1:00"), Locale.getDefault());
        x2.setLabelFont(arial);
        x2.setTickLabelFont(arial.deriveFont(12.0f));
        x2.setTimeZone(TimeZone.getTimeZone("GMT+1:00"));
        x2.setRange(this.interval().getStart().toDate(), this.interval().getEnd().toDate());
        TickUnits ticks = new TickUnits();
        ticks.add(this.dateTickUnit());
        x2.setStandardTickUnits(ticks);
        plot.setDomainAxis(x2);
        plot.getRangeAxis().setLabelFont(arial);
        plot.getRangeAxis().setTickLabelFont(arial.deriveFont(12.0f));
        plot.setBackgroundPaint(Color.white);
        plot.setBackgroundImageAlpha(0.0f);
        plot.setDomainGridlinePaint(Color.gray);
        plot.setRangeGridlinePaint(Color.gray);
        XYStepPathRenderer step = new XYStepPathRenderer();
        step.setDrawSeriesLineAsPath(true);
        step.setSeriesPaint(0, this.color);
        step.setDrawSeriesLineAsPath(true);
        step.setSeriesPaint(0, this.color);
        plot.setRenderer(0, step);
        if (this.showPeaks) {
            plot.setDataset(1, new TimeSeriesCollection(data.peakSeries()));
            XYLineAndShapeRenderer triangle = new XYLineAndShapeRenderer(false, true);
            triangle.setSeriesShape(0, ShapeUtilities.createDownTriangle(3.5f));
            triangle.setSeriesShapesFilled(0, false);
            triangle.setSeriesPaint(0, this.color);
            plot.setRenderer(1, triangle);
        }
        this.wMin.ifPresent(W -> plot.getRangeAxis().setLowerBound(W.intValue()));
        this.wMax.ifPresent(W -> plot.getRangeAxis().setUpperBound(W.intValue()));
        return chart;
    }

    private static class HourlyTicks
    extends DateTickUnit
    implements MajorMinorTicks {
        private static final long serialVersionUID = 4961989321735530778L;

        private HourlyTicks() {
            this(1);
        }

        private HourlyTicks(int multiple) {
            super(DateTickUnitType.HOUR, multiple);
        }

        @Override
        public String valueToString(double ms) {
            DateTime time = new DateTime((long)ms, DateTimeZone.forOffsetHours(1));
            if (time.getHourOfDay() == 0) {
                return Format.formatHour(time) + "\n" + Format.formatDayMonth(time);
            }
            if (time.getHourOfDay() % (2 * this.getMultiple()) == 0) {
                return Format.formatHour(time);
            }
            return "";
        }

        @Override
        public String dateToString(Date date) {
            return this.valueToString(date.getTime());
        }

        @Override
        public boolean isMajor(double ms) {
            return this.getMultiple() > 1 && new DateTime((long)ms, DateTimeZone.forOffsetHours(1)).getHourOfDay() == 0;
        }
    }

    private static class DailyTicks
    extends DateTickUnit {
        private static final long serialVersionUID = -5089539048461936763L;

        private DailyTicks(int multiple) {
            super(DateTickUnitType.DAY, multiple);
        }

        @Override
        public String valueToString(double ms) {
            DateTime time = new DateTime((long)ms, DateTimeZone.forOffsetHours(1));
            if (time.getDayOfMonth() % (3 * this.getMultiple()) != 0) {
                return "";
            }
            return Format.formatDayMonth(time);
        }

        @Override
        public String dateToString(Date date) {
            return this.valueToString(date.getTime());
        }
    }

    private static class WeeklyTicks
    extends DateTickUnit
    implements MajorMinorTicks {
        private static final long serialVersionUID = -6138449720772481812L;
        private final int days;
        private final DateTime start;

        private WeeklyTicks(DateTime start) {
            this(start, 1, 7);
        }

        private WeeklyTicks(DateTime start, int tickEveryNthDay, int majorTickPerDays) {
            super(DateTickUnitType.DAY, tickEveryNthDay);
            this.start = start;
            this.days = majorTickPerDays;
        }

        @Override
        public String valueToString(double ms) {
            DateTime time = new DateTime((long)ms, DateTimeZone.forOffsetHours(1));
            if (Days.daysIn(new Interval((ReadableInstant)this.start, (ReadableInstant)time)).getDays() % this.days == 0) {
                return Format.formatDayMonth(time);
            }
            return "";
        }

        @Override
        public boolean isMajor(double ms) {
            return Days.daysIn(new Interval((ReadableInstant)this.start, (ReadableInstant)new DateTime((long)ms, DateTimeZone.forOffsetHours(1)))).getDays() % this.days == 0;
        }

        @Override
        public String dateToString(Date date) {
            return this.valueToString(date.getTime());
        }
    }

    private static class YearlyTicks
    extends DateTickUnit
    implements MajorMinorTicks {
        private static final long serialVersionUID = -5840110872112823242L;
        private static final DateTimeFormatter yearFormat = DateTimeFormat.forPattern("yyyy");
        private final int years;

        YearlyTicks(int years) {
            super(DateTickUnitType.YEAR, 1);
            this.years = years;
        }

        @Override
        public boolean isMajor(double ms) {
            return new DateTime((long)ms, DateTimeZone.forOffsetHours(1)).getYear() % this.years == 0;
        }

        @Override
        public String valueToString(double ms) {
            DateTime time = new DateTime((long)ms, DateTimeZone.forOffsetHours(1));
            if (time.getYear() % this.years != 0) {
                return "";
            }
            return yearFormat.print(time);
        }

        @Override
        public String dateToString(Date date) {
            return this.valueToString(date.getTime());
        }
    }

    private static class ChartData {
        private final TimeSeries timeSeries;
        private final TimeSeries peakSeries;

        private ChartData(TimeSeries timeSeries, TimeSeries peakSeries) {
            this.timeSeries = timeSeries;
            this.peakSeries = peakSeries;
        }

        private TimeSeries timeSeries() {
            return this.timeSeries;
        }

        private TimeSeries peakSeries() {
            return this.peakSeries;
        }
    }

    private static class MonthBasedDateAxis
    extends DateAxis {
        private static final long serialVersionUID = 9089198288765346630L;

        private MonthBasedDateAxis(String label, TimeZone zone, Locale locale) {
            super(label, zone, locale);
        }

        @Override
        public Date calculateLowestVisibleTickValue(DateTickUnit unit) {
            return this.getMinimumDate();
        }

        @Override
        protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
            ArrayList<DateTick> result = new ArrayList<DateTick>();
            List refreshed = super.refreshTicksHorizontal(g2, dataArea, edge);
            for (Object t2 : refreshed) {
                DateTick tick = (DateTick)t2;
                result.add(new DateTick(tick.getTickType(), tick.getDate(), tick.getText(), TextAnchor.TOP_LEFT, tick.getRotationAnchor(), tick.getAngle()));
            }
            return result;
        }

        @Override
        protected double findMaximumTickLabelHeight(List ticks, Graphics2D g2, Rectangle2D drawArea, boolean vertical) {
            double height = super.findMaximumTickLabelHeight(ticks, g2, drawArea, vertical);
            for (Object tick : ticks) {
                if (!((Tick)tick).getText().contains("\n")) continue;
                return height * 2.0;
            }
            return height;
        }

        Paint getTickMarkPaint(Tick tick) {
            DateTickUnit tickUnit = this.getTickUnit();
            if (tickUnit instanceof MajorMinorTicks && ((MajorMinorTicks)((Object)tickUnit)).isMajor(((ValueTick)tick).getValue())) {
                return Color.black;
            }
            return super.getTickMarkPaint();
        }

        Stroke getTickMarkStroke(Tick tick) {
            DateTickUnit tickUnit = this.getTickUnit();
            if (tickUnit instanceof MajorMinorTicks && ((MajorMinorTicks)((Object)tickUnit)).isMajor(((ValueTick)tick).getValue())) {
                return new BasicStroke(((BasicStroke)super.getTickMarkStroke()).getLineWidth() * 2.0f);
            }
            return super.getTickMarkStroke();
        }

        @Override
        protected AxisState drawTickMarksAndLabels(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
            AxisState state = new AxisState(cursor);
            if (this.isAxisLineVisible()) {
                this.drawAxisLine(g2, cursor, dataArea, edge);
            }
            List ticks = this.refreshTicks(g2, state, dataArea, edge);
            state.setTicks(ticks);
            g2.setFont(this.getTickLabelFont());
            Object saved = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            for (Object it : ticks) {
                ValueTick tick = (ValueTick)it;
                if (this.isTickLabelsVisible()) {
                    g2.setPaint(this.getTickLabelPaint());
                    float[] anchorPoint = this.calculateAnchorPoint(tick, cursor, dataArea, edge);
                    if (tick instanceof LogTick) {
                        LogTick lt = (LogTick)tick;
                        if (lt.getAttributedLabel() == null) continue;
                        AttrStringUtils.drawRotatedString(lt.getAttributedLabel(), g2, anchorPoint[0], anchorPoint[1], tick.getTextAnchor(), tick.getAngle(), tick.getRotationAnchor());
                    } else {
                        if (tick.getText() == null) continue;
                        if (tick.getText().contains("\n")) {
                            float y2 = anchorPoint[1];
                            for (String line : tick.getText().split("\n")) {
                                TextUtilities.drawRotatedString(line, g2, anchorPoint[0], y2, tick.getTextAnchor(), tick.getAngle(), tick.getRotationAnchor());
                                y2 += 20.0f;
                            }
                        } else {
                            TextUtilities.drawRotatedString(tick.getText(), g2, anchorPoint[0], anchorPoint[1], tick.getTextAnchor(), tick.getAngle(), tick.getRotationAnchor());
                        }
                    }
                }
                if ((!this.isTickMarksVisible() || !tick.getTickType().equals(TickType.MAJOR)) && (!this.isMinorTickMarksVisible() || !tick.getTickType().equals(TickType.MINOR))) continue;
                boolean isBigTick = false;
                DateTickUnit tickUnit = this.getTickUnit();
                if (tickUnit instanceof MajorMinorTicks && ((MajorMinorTicks)((Object)tickUnit)).isMajor(tick.getValue())) {
                    isBigTick = true;
                }
                double ol = tick.getTickType().equals(TickType.MINOR) ? (double)this.getMinorTickMarkOutsideLength() : (double)(isBigTick ? this.getTickMarkOutsideLength() * 2.0f : this.getTickMarkOutsideLength());
                double il = tick.getTickType().equals(TickType.MINOR) ? (double)this.getMinorTickMarkInsideLength() : (double)this.getTickMarkInsideLength();
                float xx = (float)this.valueToJava2D(tick.getValue(), dataArea, edge);
                Line2D.Double mark = null;
                g2.setStroke(this.getTickMarkStroke(tick));
                g2.setPaint(this.getTickMarkPaint(tick));
                if (edge == RectangleEdge.LEFT) {
                    mark = new Line2D.Double(cursor - ol, xx, cursor + il, xx);
                } else if (edge == RectangleEdge.RIGHT) {
                    mark = new Line2D.Double(cursor + ol, xx, cursor - il, xx);
                } else if (edge == RectangleEdge.TOP) {
                    mark = new Line2D.Double(xx, cursor - ol, xx, cursor + il);
                } else if (edge == RectangleEdge.BOTTOM) {
                    mark = new Line2D.Double(xx, cursor + ol, xx, cursor - il);
                }
                g2.draw(mark);
            }
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, saved);
            double used = 0.0;
            if (this.isTickLabelsVisible()) {
                if (edge == RectangleEdge.LEFT) {
                    state.cursorLeft(used += this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels()));
                } else if (edge == RectangleEdge.RIGHT) {
                    used = this.findMaximumTickLabelWidth(ticks, g2, plotArea, this.isVerticalTickLabels());
                    state.cursorRight(used);
                } else if (edge == RectangleEdge.TOP) {
                    used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                    state.cursorUp(used);
                } else if (edge == RectangleEdge.BOTTOM) {
                    used = this.findMaximumTickLabelHeight(ticks, g2, plotArea, this.isVerticalTickLabels());
                    state.cursorDown(used);
                }
            }
            return state;
        }
    }

    private static interface MajorMinorTicks {
        public boolean isMajor(double var1);
    }
}

