/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.io.OutputStream;
import luwa.marlin.component.Component;
import luwa.marlin.configuration.ConfiguredNetwork;
import luwa.marlin.ship_library.model.SteckbriefTyp;
import luwa.marlin.ship_library.util.HTTPRequest;
import luwa.marlin.web.OutputView;

public class Steckbrief
implements OutputView {
    private final long messstellenNummer;
    private final SteckbriefTyp typ;
    private final String authToken;

    public Steckbrief(long messstellenNummer, SteckbriefTyp typ, String authToken) {
        this.messstellenNummer = messstellenNummer;
        this.typ = typ;
        this.authToken = authToken;
    }

    @Override
    public String name() {
        return this.typ.bezeichnung();
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        ConfiguredNetwork stammdatenDienst = ConfiguredNetwork.forService(Component.stammdaten);
        String stammdatenBaseURL = stammdatenDienst.protocol() + "://43fispegel.lubw.bwl.de:" + stammdatenDienst.port() + "/pegelstammdaten";
        String requestPath = stammdatenBaseURL + "/" + this.typ.urlPath(this.messstellenNummer);
        try {
            out.write(HTTPRequest.getWithDefaultProxy(requestPath));
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Steckbrief-Anfrage nicht beantworten", e2);
        }
    }
}

