/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Abflusshalbjahr;
import luwa.marlin.ship_library.model.Gepr\u00fcftstatus;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.Organisation;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.CalendarYearsRange;
import luwa.marlin.ship_library.model.year.ErweitertesJahr;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.view.DauertabelleRenderModel;
import luwa.marlin.ship_library.view.ExtremwerteRenderModel;
import luwa.marlin.ship_library.view.HauptwerteRenderModel;
import luwa.marlin.ship_library.view.JahrbuchseiteRenderModel;
import luwa.marlin.ship_library.view.MonatsHauptwerteRenderModel;
import luwa.marlin.ship_library.view.SpaltenHauptwerteDerZeitreihe;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.TageswerteRenderModel;
import luwa.marlin.ship_library.view.ZeilenHauptwerteDerZeitreihe;
import luwa.marlin.ship_library.view.pdf.helpers.Column;
import luwa.marlin.ship_library.view.pdf.helpers.Rendering;
import luwa.marlin.web.OutputView;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class JahrbuchseitePDF
implements OutputView {
    private final JahrbuchseiteRenderModel model;
    private static final NumberFormat kmFormat = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.GERMAN));
    private static final PDFont font = PDType1Font.HELVETICA;
    private static final int bigFontSize = 10;
    private static final float lineHeightOffset = -1.3f;
    private static final int topBound = 775;
    private static final int bottomBound = 77;
    private static final int leftBound = 62;
    private static final int rightBound = 554;
    private static final float thinLine = 0.5f;
    private static final float thickLine = 1.0f;
    private static final float monthColumnWidth = 31.8f;
    private static final String einheitAbflussspende = "l/s km\u00b2";
    private static final int extremewerteY = 190;
    private static final int extremwerteHeaderY = 200;
    private static final int extremwerteYearsHeaderY = 226;
    private static Map<ExtremwerteRenderModel.HochOderNiedrigwasser, Map<ExtremwerteRenderModel.Spalte, Integer>> translateXforExtremwertSpalte = Map.ofEntries(Map.entry(ExtremwerteRenderModel.HochOderNiedrigwasser.Niedrigwasser, Map.ofEntries(Map.entry(ExtremwerteRenderModel.Spalte.Wert, 2), Map.entry(ExtremwerteRenderModel.Spalte.Spende, 31), Map.entry(ExtremwerteRenderModel.Spalte.Wasserstand, 52), Map.entry(ExtremwerteRenderModel.Spalte.Datum, 90))), Map.entry(ExtremwerteRenderModel.HochOderNiedrigwasser.Hochwasser, Map.ofEntries(Map.entry(ExtremwerteRenderModel.Spalte.Wert, 0), Map.entry(ExtremwerteRenderModel.Spalte.Spende, 30), Map.entry(ExtremwerteRenderModel.Spalte.Wasserstand, 47), Map.entry(ExtremwerteRenderModel.Spalte.Datum, 87))));
    private static Map<ExtremwerteRenderModel.HochOderNiedrigwasser, Integer> xPositionsForHochwasserNiedrigwasserPages = Map.ofEntries(Map.entry(ExtremwerteRenderModel.HochOderNiedrigwasser.Niedrigwasser, 133), Map.entry(ExtremwerteRenderModel.HochOderNiedrigwasser.Hochwasser, 256));
    private static Map<ExtremwerteRenderModel.HochOderNiedrigwasser, Map<ExtremwerteRenderModel.Spalte, Integer>> extremwerteHeaderXPostions = Map.ofEntries(Map.entry(ExtremwerteRenderModel.HochOderNiedrigwasser.Niedrigwasser, Map.ofEntries(Map.entry(ExtremwerteRenderModel.Spalte.Wert, 115), Map.entry(ExtremwerteRenderModel.Spalte.Spende, 140), Map.entry(ExtremwerteRenderModel.Spalte.Wasserstand, 173), Map.entry(ExtremwerteRenderModel.Spalte.Datum, 198))), Map.entry(ExtremwerteRenderModel.HochOderNiedrigwasser.Hochwasser, Map.ofEntries(Map.entry(ExtremwerteRenderModel.Spalte.Wert, 235), Map.entry(ExtremwerteRenderModel.Spalte.Spende, 260), Map.entry(ExtremwerteRenderModel.Spalte.Wasserstand, 293), Map.entry(ExtremwerteRenderModel.Spalte.Datum, 318))));
    private final Iterable<String> tageFuerDauertabelle = DauertabelleRenderModel.tage();

    public JahrbuchseitePDF(JahrbuchseiteRenderModel model) {
        this.model = model;
    }

    @Override
    public String name() {
        if (this.model.configuration().modus() == JahrbuchModus.analog) {
            return "Darstellung analog Jahrbuchseite " + this.model.configuration().abflussOderWasserstand().symbol();
        }
        return "DGJ-Jahrbuchseite " + this.model.buchstabe();
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage(PDRectangle.A4);
            try (PDPageContentStream content = new PDPageContentStream(document, page);){
                this.adjustHeight(content);
                this.render(content);
            }
            document.addPage(page);
            document.save(out);
        }
    }

    private void adjustHeight(PDPageContentStream content) throws IOException {
        content.transform(new Matrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, -14.0f));
    }

    private void render(PDPageContentStream content) throws IOException {
        if (this.model.configuration().modus() == JahrbuchModus.nachRichtlinie) {
            this.topLineNachRichtlinie(content);
        } else {
            this.topLineAnalog(content);
        }
        this.linesAndBoxes(content);
        this.header(content);
        this.tageswerte(content);
        this.hauptwerte(content);
        this.extremwerte(content);
        this.dauertabelle(content);
        if (this.model.configuration().modus() == JahrbuchModus.nachRichtlinie) {
            this.footerNachRichtlinie(content);
        } else {
            this.footerAnalog(content);
        }
    }

    private void tageswerte(PDPageContentStream content) throws IOException {
        ErweitertesJahr erweitertesJahr = this.model.configuration().erweitertesJahr();
        TageswerteRenderModel model = this.model.tageswerte();
        float x2 = 102.5f;
        float y2 = 738.0f;
        float fontSize = 6.0f;
        Rendering.textAt(content, 125.0f, 764.0f, String.valueOf(((Year)erweitertesJahr).anfangsmonat().year()), font, 10.0f);
        Rendering.textAt(content, 330.0f, 764.0f, String.valueOf(((Year)erweitertesJahr).endmonat().year()), font, 10.0f);
        Rendering.textAt(content, x2 - 13.0f, 752.0f, "Tag", font, 8.0f);
        Column days = new Column(-1.3f, font, 6.0f);
        for (int day = 1; day <= 31; ++day) {
            days.add(day + ".");
            if (!JahrbuchseitePDF.verticalSpaceAfterDay(day)) continue;
            days.add("");
        }
        days.drawRightAligned(content, x2, 738.0f);
        for (YearMonth month : erweitertesJahr) {
            Rendering.textAt(content, (x2 += 31.8f) - 13.0f, 752.0f, month.shortName(), font, 8.0f);
            Column monthValues = new Column(-1.3f, font, 6.0f);
            for (int day = 1; day <= 31; ++day) {
                String wert = model.wert(month, day);
                if (model.istErg\u00e4nzt(month, day).booleanValue()) {
                    monthValues.addWithAddOn(wert, "e");
                } else {
                    monthValues.add(wert);
                }
                if (!JahrbuchseitePDF.verticalSpaceAfterDay(day)) continue;
                monthValues.add("");
            }
            monthValues.drawRightAligned(content, x2, 738.0f);
        }
    }

    private void hauptwerte(PDPageContentStream content) throws IOException {
        this.monatsHauptwerteNachRichtlinie(content);
        this.monatshauptwerteDerZeitreiheNachRichtlinie(content);
        this.jahresHauptwerteNachRichtlinie(content);
        this.hauptwerteDerZeitreiheNachRichtlinie(content);
    }

    private void monatsHauptwerteNachRichtlinie(PDPageContentStream content) throws IOException {
        float fontSize = 6.0f;
        Column titles = new Column(-1.3f, font, 6.0f);
        titles.add("  Tag");
        titles.add("  N" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  M" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  H" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  Tag");
        float columnsY = 542.0f;
        titles.draw(content, 81.0f, 542.0f);
        float x2 = 102.5f;
        Map<YearMonth, ? extends Map<MonatsHauptwerteRenderModel.ZeilenMonatswerte, String>> model = this.model.hauptwerte().monatswerte();
        ErweitertesJahr extendedYear = this.model.configuration().erweitertesJahr();
        for (YearMonth month : extendedYear) {
            Map<MonatsHauptwerteRenderModel.ZeilenMonatswerte, String> modelForMonth = model.get(month);
            Column monthColumn = new Column(-1.3f, font, 6.0f);
            x2 += 31.8f;
            monthColumn.add(modelForMonth.get((Object)MonatsHauptwerteRenderModel.ZeilenMonatswerte.Tag_N));
            monthColumn.add(modelForMonth.get((Object)MonatsHauptwerteRenderModel.ZeilenMonatswerte.N));
            monthColumn.add(modelForMonth.get((Object)MonatsHauptwerteRenderModel.ZeilenMonatswerte.M));
            monthColumn.add(modelForMonth.get((Object)MonatsHauptwerteRenderModel.ZeilenMonatswerte.H));
            monthColumn.add(modelForMonth.get((Object)MonatsHauptwerteRenderModel.ZeilenMonatswerte.Tag_H));
            monthColumn.drawRightAligned(content, x2, 542.0f);
        }
    }

    private void monatshauptwerteDerZeitreiheNachRichtlinie(PDPageContentStream content) throws IOException {
        Map<YearMonth, ? extends Map<HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte, String>> model = this.model.hauptwerte().mehrj\u00e4hrigeMonatswerte();
        float fontSize = 6.0f;
        int yearsRangesLabelY = 490;
        CalendarYearsRange calendarYearsRange = this.model.configuration().calendarYearsRange();
        Rendering.textAt(content, 120.0f, 490.0f, ((Kalenderjahr)calendarYearsRange.startYear()).year() - 1 + " / " + (((Kalenderjahr)calendarYearsRange.endYear()).year() - 1), font, 7.0f);
        Rendering.textAt(content, 320.0f, 490.0f, this.model.configuration().calendarYearsRange().representation(), font, 7.0f);
        Rendering.textAt(content, 390.0f, 490.0f, this.model.anzahlJahreZeitreihe() + " Jahre", font, 7.0f);
        float columnsY = 479.0f;
        this.zeilenbeschriftungenMonatshauptwerteZeitreihe(content, 6.0f, 479.0f);
        float x2 = 102.5f;
        ErweitertesJahr extendedYear = this.model.configuration().erweitertesJahr();
        for (YearMonth month : extendedYear) {
            Map<HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte, String> modelForMonth = model.get(month);
            Column monthColumn = new Column(-1.3f, font, 6.0f);
            x2 += 31.8f;
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.Jahr_N));
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.N));
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.MN));
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.M));
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.MH));
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.H));
            monthColumn.add(modelForMonth.get((Object)HauptwerteRenderModel.ZeilenMehrj\u00e4hrigeMonatswerte.Jahr_H));
            monthColumn.drawRightAligned(content, x2, 479.0f);
        }
    }

    private void jahresHauptwerteNachRichtlinie(PDPageContentStream content) throws IOException {
        Map<HauptwerteRenderModel.ZeilenJahreshauptwerte, ? extends Map<HauptwerteRenderModel.SpaltenJahreshauptwerte, String>> model = this.model.hauptwerte().jahreswerte();
        float fontSize = 6.0f;
        int yearValuesY = 385;
        this.spaltenBeschriftungenHauptwerteJahr(content);
        this.zeilenBeschriftungenHauptwerteJahr(content, 6.0f, 385);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.Winter, 6.0f, 237, 385);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.Sommer, 6.0f, 271, 385);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.WertAbflussjahr, 6.0f, 135, 385);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.Wasserstand, 6.0f, 162, 385);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.DatumAbflussjahr, 6.0f, 172, 385, false);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.WertKalenderjahr, 6.0f, 302, 385);
        this.zeichneJahreshaupwerteInSpalte(content, model, HauptwerteRenderModel.SpaltenJahreshauptwerte.DatumKalenderjahr, 6.0f, 312, 385, false);
    }

    private void zeilenBeschriftungenHauptwerteJahr(PDPageContentStream content, float fontSize, int yearValuesY) throws IOException {
        Column titles = new Column(-1.3f, font, fontSize);
        titles.add("N" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 93.0f, yearValuesY, this.model.configuration().einheit(), font, fontSize - 1.0f);
        titles.add("M" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 93.0f, yearValuesY - 6, this.model.configuration().einheit(), font, fontSize - 1.0f);
        titles.add("H" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 93.0f, yearValuesY - 11, this.model.configuration().einheit(), font, fontSize - 1.0f);
        if (this.isQ() && this.model.abflussspendeAngeben()) {
            titles.add("");
            titles.add("Nq");
            Rendering.textAt(content, 93.0f, yearValuesY - 22, einheitAbflussspende, font, fontSize - 1.0f);
            titles.add("Mq");
            Rendering.textAt(content, 93.0f, yearValuesY - 28, einheitAbflussspende, font, fontSize - 1.0f);
            titles.add("Hq");
            Rendering.textAt(content, 93.0f, yearValuesY - 34, einheitAbflussspende, font, fontSize - 1.0f);
        }
        titles.draw(content, 81.0f, yearValuesY);
    }

    private void hauptwerteDerZeitreiheNachRichtlinie(PDPageContentStream content) throws IOException {
        Map<ZeilenHauptwerteDerZeitreihe, ? extends Map<SpaltenHauptwerteDerZeitreihe, String>> model = this.model.hauptwerte().hauptwerteDerZeitreihe();
        float fontSize = 6.0f;
        int valuesY = 303;
        this.l\u00e4ngeDerZeitreihe(content);
        this.zeilenBeschriftungenHauptwerteDerZeitreihe(content, 6.0f, 303);
        this.printAbflusshalbjahr(model, content, 6.0f, 303, Abflusshalbjahr.winter, 237);
        this.printAbflusshalbjahr(model, content, 6.0f, 303, Abflusshalbjahr.sommer, 271);
        Column WerteDesAbflussjahres = new Column(-1.3f, font, 6.0f);
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.N).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MN).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.M).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MH).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.H).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add("");
        WerteDesAbflussjahres.add("");
        WerteDesAbflussjahres.add("");
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MNq).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.Mq).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MHq).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr));
        WerteDesAbflussjahres.drawRightAligned(content, 135.0f, 303.0f);
        Column ExtremeWasserst\u00e4nde = new Column(-1.3f, font, 6.0f);
        ExtremeWasserst\u00e4nde.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.N).get((Object)SpaltenHauptwerteDerZeitreihe.W));
        ExtremeWasserst\u00e4nde.add("");
        ExtremeWasserst\u00e4nde.add("");
        ExtremeWasserst\u00e4nde.add("");
        ExtremeWasserst\u00e4nde.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.H).get((Object)SpaltenHauptwerteDerZeitreihe.W));
        ExtremeWasserst\u00e4nde.drawRightAligned(content, 160.0f, 303.0f);
        Column DatumVonExtremwertenDerAbflussjahre = new Column(-1.3f, font, 6.0f);
        DatumVonExtremwertenDerAbflussjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.N).get((Object)SpaltenHauptwerteDerZeitreihe.Datum));
        DatumVonExtremwertenDerAbflussjahre.add("");
        DatumVonExtremwertenDerAbflussjahre.add("");
        DatumVonExtremwertenDerAbflussjahre.add("");
        DatumVonExtremwertenDerAbflussjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.H).get((Object)SpaltenHauptwerteDerZeitreihe.Datum));
        DatumVonExtremwertenDerAbflussjahre.draw(content, 172.0f, 303.0f);
        Column WerteDerKalenderjahre = new Column(-1.3f, font, 6.0f);
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.N).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MN).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.M).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MH).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.H).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add("");
        WerteDerKalenderjahre.add("");
        WerteDerKalenderjahre.add("");
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MNq).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.Mq).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MHq).get((Object)SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr));
        WerteDerKalenderjahre.drawRightAligned(content, 302.0f, 303.0f);
        Column DatumVonExtremwertenDerKalenderjahre = new Column(-1.3f, font, 6.0f);
        DatumVonExtremwertenDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.N).get((Object)SpaltenHauptwerteDerZeitreihe.Datum_Kalenderjahr));
        DatumVonExtremwertenDerKalenderjahre.add("");
        DatumVonExtremwertenDerKalenderjahre.add("");
        DatumVonExtremwertenDerKalenderjahre.add("");
        DatumVonExtremwertenDerKalenderjahre.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.H).get((Object)SpaltenHauptwerteDerZeitreihe.Datum_Kalenderjahr));
        DatumVonExtremwertenDerKalenderjahre.draw(content, 312.0f, 303.0f);
    }

    private void l\u00e4ngeDerZeitreihe(PDPageContentStream content) throws IOException {
        Rendering.textAt(content, 153.0f, 317.0f, this.model.configuration().calendarYearsRange().representation(), font, 7.0f);
        Rendering.textAt(content, 210.0f, 317.0f, this.model.anzahlJahreZeitreihe() + " Jahre", font, 7.0f);
        Rendering.textAt(content, 292.0f, 317.0f, this.model.configuration().calendarYearsRange().representation(), font, 7.0f);
    }

    private void zeilenBeschriftungenHauptwerteDerZeitreihe(PDPageContentStream content, float fontSize, int valuesY) throws IOException {
        Column titles = new Column(-1.3f, font, fontSize);
        titles.add("N" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 96.0f, valuesY, this.model.configuration().einheit(), font, fontSize - 1.0f);
        titles.add("MN" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 96.0f, valuesY - 6, this.model.configuration().einheit(), font, fontSize - 1.0f);
        titles.add("M" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 96.0f, valuesY - 11, this.model.configuration().einheit(), font, fontSize - 1.0f);
        titles.add("MH" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 96.0f, valuesY - 17, this.model.configuration().einheit(), font, fontSize - 1.0f);
        titles.add("H" + this.model.configuration().abflussOderWasserstand().symbol());
        Rendering.textAt(content, 96.0f, valuesY - 22, this.model.configuration().einheit(), font, fontSize - 1.0f);
        if (this.isQ() && this.model.abflussspendeAngeben()) {
            titles.add("");
            titles.add("");
            titles.add("");
            titles.add("MNq");
            Rendering.textAt(content, 94.0f, valuesY - 45, einheitAbflussspende, font, fontSize - 1.0f);
            titles.add("Mq");
            Rendering.textAt(content, 94.0f, valuesY - 51, einheitAbflussspende, font, fontSize - 1.0f);
            titles.add("MHq");
            Rendering.textAt(content, 94.0f, valuesY - 56, einheitAbflussspende, font, fontSize - 1.0f);
        }
        titles.draw(content, 81.0f, valuesY);
    }

    private void printAbflusshalbjahr(Map<ZeilenHauptwerteDerZeitreihe, ? extends Map<SpaltenHauptwerteDerZeitreihe, String>> model, PDPageContentStream content, float fontSize, int valuesY, Abflusshalbjahr abflussHalbJahr, int i2) throws IOException {
        Column column = new Column(-1.3f, font, fontSize);
        SpaltenHauptwerteDerZeitreihe spalte = abflussHalbJahr == Abflusshalbjahr.winter ? SpaltenHauptwerteDerZeitreihe.Winter : SpaltenHauptwerteDerZeitreihe.Sommer;
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.N).get((Object)spalte));
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MN).get((Object)spalte));
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.M).get((Object)spalte));
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MH).get((Object)spalte));
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.H).get((Object)spalte));
        column.add("");
        column.add("");
        column.add("");
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MNq).get((Object)spalte));
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.Mq).get((Object)spalte));
        column.add(model.get((Object)ZeilenHauptwerteDerZeitreihe.MHq).get((Object)spalte));
        column.drawRightAligned(content, i2, valuesY);
    }

    private void extremwerte(PDPageContentStream content) throws IOException {
        float fontSize = 6.0f;
        ExtremwerteRenderModel renderModel = this.model.extremwerte();
        this.printExtremwerteHeaderNachRichtlinie(content);
        this.printExtremwerteRangzahlenspalte(content, 6.0f);
        List.of(ExtremwerteRenderModel.HochOderNiedrigwasser.values()).forEach(seite -> renderModel.spalten().forEach(spalte -> {
            Map<Integer, String> columnEntry = renderModel.model((ExtremwerteRenderModel.HochOderNiedrigwasser)((Object)seite), (ExtremwerteRenderModel.Spalte)((Object)((Object)spalte)));
            Column column = new Column(-1.3f, font, 6.0f);
            IntStream.rangeClosed(1, 10).forEach(k2 -> column.add((String)columnEntry.get(k2)));
            try {
                column.drawRightAligned(content, xPositionsForHochwasserNiedrigwasserPages.get(seite) + translateXforExtremwertSpalte.get(seite).get(spalte), 190.0f);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }));
    }

    private void printExtremwerteHeaderNachRichtlinie(PDPageContentStream content) throws IOException {
        Rendering.textAt(content, 160.0f, 226.0f, this.model.extremwerte().jahreszahlen(), font, 7.0f);
        Rendering.textAt(content, 220.0f, 226.0f, this.model.extremwerte().anzahlJahre(), font, 7.0f);
        ExtremwerteRenderModel renderModel = this.model.extremwerte();
        renderModel.seiten().forEach(seite -> renderModel.spalten().forEach(spalte -> {
            try {
                Rendering.textAt(content, extremwerteHeaderXPostions.get(seite).get(spalte).intValue(), 200.0f, renderModel.header((ExtremwerteRenderModel.Spalte)((Object)((Object)spalte))), font, 6.0f);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }));
    }

    private void printExtremwerteRangzahlenspalte(PDPageContentStream content, float fontSize) throws IOException {
        Column titles = new Column(-1.3f, font, fontSize);
        for (int n2 = 1; n2 <= 10; ++n2) {
            titles.add(String.valueOf(n2));
        }
        titles.drawRightAligned(content, 98.0f, 190.0f);
    }

    private void dauertabelle(PDPageContentStream content) throws IOException {
        int spaltenYkoordinate = 388;
        this.zeichneSpaltenbeschriftungen(content);
        this.tagespalteF\u00fcrDauertabelle().drawRightAligned(content, 390.0f, 388.0f);
        this.spalteF\u00fcrDauertabelle(DauertabelleRenderModel.Spalte.abflussjahr).drawRightAligned(content, 426.0f, 388.0f);
        this.spalteF\u00fcrDauertabelle(DauertabelleRenderModel.Spalte.kalenderjahr).drawRightAligned(content, 457.0f, 388.0f);
        this.spalteF\u00fcrDauertabelle(DauertabelleRenderModel.Spalte.obereH\u00fcllwerte).drawRightAligned(content, 488.0f, 388.0f);
        this.spalteF\u00fcrDauertabelle(DauertabelleRenderModel.Spalte.mittlereWerte).drawRightAligned(content, 519.0f, 388.0f);
        this.spalteF\u00fcrDauertabelle(DauertabelleRenderModel.Spalte.untereH\u00fcllwerte).drawRightAligned(content, 550.0f, 388.0f);
    }

    private Column tagespalteF\u00fcrDauertabelle() {
        Column daysColumn = new Column(-1.3f, font, 6.0f);
        for (String tag : this.tageFuerDauertabelle) {
            if (tag.equals("(365)")) {
                daysColumn.add(tag);
                continue;
            }
            daysColumn.add(tag + " ");
        }
        return daysColumn;
    }

    private void zeichneSpaltenbeschriftungen(PDPageContentStream content) throws IOException {
        Rendering.textAt(content, 420.0f, 419.0f, "Unterschrittene " + this.model.configuration().abflussOderWasserstand().namePlural() + " in " + this.model.configuration().einheit(), font, 7.0f);
        Rendering.textAt(content, 373.0f, 417.0f, "Unter", font, 6.0f);
        Rendering.textAt(content, 366.0f, 409.0f, "schreitungs", font, 6.0f);
        Rendering.textAt(content, 375.0f, 401.0f, "Tage", font, 6.0f);
        Rendering.textAt(content, 406.0f, 412.0f, "Abfluss-", font, 6.0f);
        Rendering.textAt(content, 410.0f, 406.0f, "jahr", font, 6.0f);
        Rendering.textAt(content, 407.0f, 398.0f, String.valueOf(this.model.configuration().abflussjahr().year()), font, 7.0f);
        Rendering.textAt(content, 434.0f, 412.0f, "Kalender", font, 6.0f);
        Rendering.textAt(content, 438.0f, 406.0f, "jahr", font, 6.0f);
        Rendering.textAt(content, 437.0f, 398.0f, String.valueOf(this.model.configuration().kalenderjahr().year()), font, 7.0f);
        Rendering.textAt(content, 467.0f, 412.0f, this.model.configuration().hydrologicalYearsRange().representation() + "   " + this.model.anzahlJahreZeitreihe() + " Abflussjahre", font, 6.0f);
        Rendering.textAt(content, 467.0f, 404.0f, "Obere", font, 6.0f);
        Rendering.textAt(content, 464.0f, 398.0f, "H\u00fcllwerte", font, 6.0f);
        Rendering.textAt(content, 498.0f, 404.0f, "Mittlere", font, 6.0f);
        Rendering.textAt(content, 500.0f, 398.0f, "Werte", font, 6.0f);
        Rendering.textAt(content, 529.0f, 404.0f, "Untere", font, 6.0f);
        Rendering.textAt(content, 526.0f, 398.0f, "H\u00fcllwerte", font, 6.0f);
    }

    private Column spalteF\u00fcrDauertabelle(DauertabelleRenderModel.Spalte typ) {
        Column spalte = new Column(-1.3f, font, 6.0f);
        Map<String, String> werte = this.model.dauertabelle().model(typ);
        for (String tag : this.tageFuerDauertabelle) {
            spalte.add(werte.get(tag));
        }
        return spalte;
    }

    private void footerAnalog(PDPageContentStream content) throws IOException {
        float fontSize = 6.0f;
        Rendering.multilineTextAt(content, 68.0f, 128.0f, this.model.bemerkungen(), font, 6.0f);
        Rendering.textAt(content, 62.0f, 68.0f, "Pegelbetreiber: " + this.model.headerUndFooterModel().wertF\u00fcr(TabellenHeaderRenderModel.felder.pegelbetreiber), font, 8.0f);
        Rendering.textRightAlignedAt(content, 554, 68, "Herausgeber: " + this.model.headerUndFooterModel().wertF\u00fcr(TabellenHeaderRenderModel.felder.herausgeber), font, 8.0f);
    }

    private void footerNachRichtlinie(PDPageContentStream content) throws IOException {
        float fontSize = 6.0f;
        Rendering.multilineTextAt(content, 68.0f, 128.0f, this.model.bemerkungen(), font, 6.0f);
        Rendering.textAt(content, 62.0f, 68.0f, "Pegelbetreiber: " + this.model.headerUndFooterModel().wertF\u00fcr(TabellenHeaderRenderModel.felder.pegelbetreiber), font, 8.0f);
        Rendering.textRightAlignedAt(content, 554, 68, Organisation.langname(), font, 8.0f);
    }

    private void linesAndBoxes(PDPageContentStream content) throws IOException {
        int commentBoxHeight = 60;
        int sideLabelBoxWidth = 16;
        int rotatedLabelXOffset = 11;
        Rendering.drawRectangle(content, 62.0f, 775.0f, 554.0f, 77.0f);
        int dayValuesBoxHeight = 224;
        Rendering.drawRectangle(content, 62.0f, 775.0f, 554.0f, 551.0f);
        Rendering.drawRectangle(content, 62.0f, 775.0f, 78.0f, 551.0f);
        this.rotatedSideBoxLabel(content, "Tageswerte", 73.0f, 610.0f);
        int hydrologicalYearSeparatorOffset = 94;
        int hydrologicalYearSeparatorX = 172;
        int yearsRangesBoxHeight = 125;
        Rendering.drawLine(content, 172.0f, 775.0f, 172.0f, 426.0f);
        content.setLineWidth(0.5f);
        int daysSeparatorOffset = 31;
        int daysSeparatorX = 109;
        Rendering.drawLine(content, 109.0f, 775.0f, 109.0f, 137.0f);
        int monthsSeparatorOffset = 26;
        int monthsSeparatorY = 749;
        Rendering.drawLine(content, 78.0f, 749.0f, 554.0f, 749.0f);
        content.setLineWidth(1.0f);
        for (int i2 = 1; i2 < 14; ++i2) {
            int x2 = 108 + i2 * 32;
            Rendering.drawLine(content, x2, 757.0f, x2, 749.0f);
        }
        int mainValuesBoxHeight = 316;
        int mainValuesBoxTopY = 551;
        Rendering.drawRectangle(content, 62.0f, 551.0f, 78.0f, 235.0f);
        this.rotatedSideBoxLabel(content, "Hauptwerte", 73.0f, 336.0f);
        int yearsRangesBoxBottomY = 426;
        Rendering.drawRectangle(content, 78.0f, 551.0f, 554.0f, 426.0f);
        content.setLineWidth(0.5f);
        int yearsRangeSeparatorOffset = 53;
        int yearsRangeUpperSeparatorY = 498;
        int yearsRangeLowerSeparatorY = 487;
        Rendering.drawLine(content, 78.0f, 498.0f, 554.0f, 498.0f);
        Rendering.drawLine(content, 78.0f, 487.0f, 554.0f, 487.0f);
        int yearSeparatorOffset = 31;
        int yearSeparatorY = 395;
        int tableWidth = 206;
        Rendering.drawLine(content, 78.0f, 395.0f, 348.0f, 395.0f);
        int yearsRange2SeparatorOffset = 101;
        int yearsRange2UpperSeparatorY = 325;
        int yearsRange2LowerSeparatorY = 314;
        Rendering.drawLine(content, 78.0f, 325.0f, 348.0f, 325.0f);
        Rendering.drawLine(content, 78.0f, 314.0f, 348.0f, 314.0f);
        content.setLineWidth(1.0f);
        int extremeValuesBoxHeight = 98;
        int extremeValuesBoxTopY = 235;
        int hydrologicalCalendarYearSeparatorX = 275;
        Rendering.drawLine(content, 275.0f, 426.0f, 275.0f, 235.0f);
        int shortLineStartY = 406;
        int yearSeparatorX = 144;
        Rendering.drawLine(content, 144.0f, 406.0f, 144.0f, 395.0f);
        int dateSeparatorX = 166;
        Rendering.drawLine(content, 166.0f, 406.0f, 166.0f, 395.0f);
        int winterSummerSeparatorX = 240;
        Rendering.drawLine(content, 240.0f, 406.0f, 240.0f, 395.0f);
        int offsetYearDateSeparator = 31;
        Rendering.drawLine(content, 306.0f, 406.0f, 306.0f, 395.0f);
        int yearSummerWinterSeparatorX = 210;
        Rendering.drawLine(content, 210.0f, 406.0f, 210.0f, 325.0f);
        Rendering.drawLine(content, 210.0f, 314.0f, 210.0f, 235.0f);
        Rendering.drawRectangle(content, 62.0f, 235.0f, 78.0f, 137.0f);
        this.rotatedSideBoxLabel(content, "Extremwerte", 73.0f, 155.0f);
        content.setLineWidth(0.5f);
        Rendering.drawLine(content, 78.0f, 224.0f, 348.0f, 224.0f);
        int nwhwSeparatorOffset = 39;
        int nwhwSeparatorY = 196;
        Rendering.drawLine(content, 78.0f, 196.0f, 348.0f, 196.0f);
        content.setLineWidth(1.0f);
        int commentBoxY = 137;
        Rendering.drawRectangle(content, 62.0f, 137.0f, 554.0f, 77.0f);
        int tableLeftX = 348;
        Rendering.drawRectangle(content, 348.0f, 137.0f, 554.0f, 426.0f);
        this.rotatedSideBoxLabel(content, "Dauertabelle", 359.0f, 246.0f);
        content.setLineWidth(0.5f);
        int tableLabelSeparatorX = 364;
        Rendering.drawLine(content, 364.0f, 426.0f, 364.0f, 137.0f);
        int tableDaysSeparatorX = 399;
        Rendering.drawLine(content, 399.0f, 426.0f, 399.0f, 137.0f);
        int tableHeadingSeparatorOffset = 31;
        int tableHeadingSeparatorY = 395;
        Rendering.drawLine(content, 364.0f, 395.0f, 554.0f, 395.0f);
        int tableHeadingVerticalSeparator1X = 430;
        int tableHeadingVerticalSeparatorHeight = 18;
        Rendering.drawLine(content, 430.0f, 413.0f, 430.0f, 395.0f);
        int tableHeadingVerticalSeparator2X = 461;
        Rendering.drawLine(content, 461.0f, 413.0f, 461.0f, 395.0f);
        int tableHeadingVerticalSeparator3X = 492;
        Rendering.drawLine(content, 492.0f, 408.0f, 492.0f, 395.0f);
        int tableHeadingVerticalSeparator4X = 523;
        Rendering.drawLine(content, 523.0f, 408.0f, 523.0f, 395.0f);
        content.setLineWidth(1.0f);
        int nwBoxWidth = 150;
        int nwBoxLeftX = 78;
        int nwBoxRightX = 228;
        Rendering.textAt(content, 136.0f, 209.0f, "Niedrigwasser", font, 10.0f);
        Rendering.drawLine(content, 228.0f, 137.0f, 228.0f, 224.0f);
        Rendering.drawLine(content, 78.0f, 235.0f, 348.0f, 235.0f);
        int extremesShortLineStartY = 204;
        int offsetExtremeSeparator1 = 42;
        Rendering.drawLine(content, 186.0f, 204.0f, 186.0f, 196.0f);
        int offsetExtremeSeparator2 = 62;
        Rendering.drawLine(content, 166.0f, 204.0f, 166.0f, 196.0f);
        int offsetExtremeSeparator3 = 94;
        Rendering.drawLine(content, 134.0f, 204.0f, 134.0f, 196.0f);
        Rendering.drawLine(content, 306.0f, 204.0f, 306.0f, 196.0f);
        Rendering.drawLine(content, 286.0f, 204.0f, 286.0f, 196.0f);
        Rendering.drawLine(content, 254.0f, 204.0f, 254.0f, 196.0f);
        Rendering.textAt(content, 260.0f, 209.0f, "Hochwasser", font, 10.0f);
    }

    private void rotatedSideBoxLabel(PDPageContentStream content, String text, float x2, float y2) throws IOException {
        content.setFont(font, 10.0f);
        content.beginText();
        content.setTextMatrix(Matrix.getRotateInstance(1.5707963267948966, x2, y2));
        content.showText(text);
        content.endText();
    }

    private static boolean verticalSpaceAfterDay(int day) {
        return day == 10 || day == 20;
    }

    private void header(PDPageContentStream content) throws IOException {
        if (this.model.configuration().modus() == JahrbuchModus.nachRichtlinie) {
            this.bigParameterLetterAndUnitNachRichtlinie(content);
        }
        if (this.model.configuration().modus() == JahrbuchModus.analog) {
            this.bigParameterLetterAndUnitAnalog(content);
        }
        TabellenHeaderRenderModel header = this.model.headerUndFooterModel();
        float fontSize = 8.0f;
        content.setFont(font, 8.0f);
        int labelRow1Y = 813;
        int labelRow2Y = 799;
        int labelRow3Y = 785;
        int labelColumn1X = 62;
        int colonColumn1X = 82;
        Rendering.textAt(content, 62.0f, 813.0f, "A");
        content.setFont(font, 6.0f);
        Rendering.textAt(content, 68.0f, 811.0f, "Eo");
        content.setFont(font, 8.0f);
        Rendering.textAt(content, 82.0f, 813.0f, ":");
        int xOffsetValue = 29;
        int xOffsetUnit = 65;
        float valueFontSize = 7.0f;
        Rendering.textAt(content, 82 + (header.istSeepegel() ? 6 : 29), 813.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.einzugsgebiet), font, 7.0f);
        Rendering.textAt(content, 147.0f, 813.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.einzugsgebiet_einheit), font, 8.0f);
        Rendering.textAt(content, 62.0f, 799.0f, "PNP");
        Rendering.textAt(content, 82.0f, 799.0f, ":  NN +");
        Rendering.textAt(content, 111.0f, 799.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nullpunkt), font, 7.0f);
        Rendering.textAt(content, 147.0f, 799.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nullpunkt_einheit), font, 8.0f);
        Rendering.textAt(content, 62.0f, 785.0f, "Lage");
        Rendering.textAt(content, 82.0f, 785.0f, ":");
        if (header.istSeepegel()) {
            Rendering.textAt(content, 88.0f, 785.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage), font, 7.0f);
        } else {
            Rendering.textAt(content, 111.0f, 785.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage), font, 7.0f);
            Rendering.textAt(content, 147.0f, 785.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage_einheit), font, 8.0f);
            content.setFont(font, 6.0f);
            Rendering.textAt(content, 162.0f, 785.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage_bezugspunkt));
        }
        content.setFont(font, 8.0f);
        int labelColumn2X = 355;
        int colonColumn2X = 392;
        int xOffset = 5;
        Rendering.textAt(content, 355.0f, 813.0f, "Pegel");
        Rendering.textAt(content, 392.0f, 813.0f, ":");
        Rendering.textAt(content, 397.0f, 813.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegel), font, 7.0f);
        Rendering.textAt(content, 355.0f, 799.0f, "Gew\u00e4sser", font, 8.0f);
        Rendering.textAt(content, 392.0f, 799.0f, ":");
        Rendering.textAt(content, 397.0f, 799.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.gew\u00e4sser), font, 7.0f);
        Rendering.textAt(content, 355.0f, 785.0f, "Teilgebiet", font, 8.0f);
        Rendering.textAt(content, 392.0f, 785.0f, ":");
        Rendering.textAt(content, 397.0f, 785.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.teilgebiet), font, 7.0f);
        int labelColumn3X = 470;
        int colonColumn3X = 512;
        Rendering.textAt(content, 470.0f, 813.0f, "Nr.", font, 8.0f);
        Rendering.textAt(content, 512.0f, 813.0f, ":");
        Rendering.textRightAlignedAt(content, 553, 813, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nr), font, 8.0f);
        Rendering.textAt(content, 470.0f, 799.0f, "Zeitbezug", font, 8.0f);
        Rendering.textAt(content, 512.0f, 799.0f, ":");
        Rendering.textRightAlignedAt(content, 553, 799, "MEZ", font, 8.0f);
        Rendering.textAt(content, 470.0f, 785.0f, "Datenstand", font, 8.0f);
        Rendering.textAt(content, 512.0f, 785.0f, ":");
        Rendering.textRightAlignedAt(content, 553, 785, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.datenstand), font, 7.0f);
    }

    private void topLineAnalog(PDPageContentStream content) throws IOException {
        int topTextY = 834;
        int topLineY = 831;
        content.setFont(font, 9.0f);
        Rendering.textAt(content, 62.0f, 834.0f, "Darstellung analog Jahrbuch");
        Abflussjahresreihe range = this.model.configuration().hydrologicalYearsRange();
        String yearRange = ((Abflussjahr)range.startYear()).year() + "-" + ((Abflussjahr)range.endYear()).year();
        Rendering.textAt(content, 510.0f, 834.0f, yearRange);
        String topText = "Flussgebietseinheit " + this.model.headerUndFooterModel().wertF\u00fcr(TabellenHeaderRenderModel.felder.flussgebietseinheit);
        Rendering.textCenteredAt(content, 315, 834, topText, font, 11.0f);
        Rendering.drawLine(content, 62.0f, 831.0f, 554.0f, 831.0f);
    }

    private void topLineNachRichtlinie(PDPageContentStream content) throws IOException {
        int topTextY = 834;
        int topLineY = 831;
        content.setFont(font, 9.0f);
        Rendering.textAt(content, 62.0f, 834.0f, this.model.\u00fcberschriftLinksObenDGJ());
        Abflussjahresreihe range = this.model.configuration().hydrologicalYearsRange();
        String yearRange = ((Abflussjahr)range.startYear()).year() + "-" + ((Abflussjahr)range.endYear()).year();
        Rendering.textAt(content, 510.0f, 834.0f, yearRange);
        String topText = "Flussgebietseinheit " + this.model.headerUndFooterModel().wertF\u00fcr(TabellenHeaderRenderModel.felder.flussgebietseinheit);
        Rendering.textCenteredAt(content, 315, 834, topText, font, 11.0f);
        Rendering.drawLine(content, 62.0f, 831.0f, 554.0f, 831.0f);
    }

    private void bigParameterLetterAndUnitAnalog(PDPageContentStream content) throws IOException {
        int letterX = 309;
        Rendering.textCenteredAt(content, 309, 810, this.model.configuration().abflussOderWasserstand().datenname(), font, 8.0f);
        Rendering.textCenteredAt(content, 309, 800, this.model.einheit(), font, 8.0f);
        Rendering.textCenteredAt(content, 309, 790, Gepr\u00fcftstatus.ungepr\u00fcft.beschreibung(), font, 8.0f);
    }

    private void bigParameterLetterAndUnitNachRichtlinie(PDPageContentStream content) throws IOException {
        PDType1Font letterFont = PDType1Font.HELVETICA_BOLD;
        float letterFontSize = 30.0f;
        int letterX = 309;
        content.setNonStrokingColor(Color.GRAY);
        Rendering.textCenteredAt(content, 309, 800, this.model.buchstabe(), letterFont, 30.0f);
        content.setNonStrokingColor(Color.BLACK);
        Rendering.textCenteredAt(content, 309, 785, this.model.einheit(), font, 8.0f);
    }

    private boolean isQ() {
        return this.model.configuration().abflussOderWasserstand() == AbflussOderWasserstand.Q;
    }

    private void spaltenBeschriftungenHauptwerteJahr(PDPageContentStream content) throws IOException {
        Rendering.textAt(content, 166.0f, 417.0f, "Abflussjahr", font, 7.0f);
        Rendering.textAt(content, 178.0f, 409.0f, String.valueOf(this.model.configuration().abflussjahr().year()), font, 7.0f);
        Rendering.textAt(content, 292.0f, 417.0f, "Kalenderjahr", font, 7.0f);
        Rendering.textAt(content, 300.0f, 409.0f, String.valueOf(this.model.configuration().kalenderjahr().year()), font, 7.0f);
        int yearHeadingsY = 398;
        Rendering.textAt(content, 116.0f, 398.0f, "Jahr", font, 7.0f);
        if (this.isQ()) {
            Rendering.textCenteredAt(content, 155, 405, "W in", font, 7.0f);
            Rendering.textCenteredAt(content, 155, 398, "cm", font, 7.0f);
        }
        Rendering.textAt(content, 175.0f, 398.0f, "Datum", font, 7.0f);
        Rendering.textAt(content, 215.0f, 398.0f, "Winter", font, 7.0f);
        Rendering.textAt(content, 245.0f, 398.0f, "Sommer", font, 7.0f);
        Rendering.textAt(content, 283.0f, 398.0f, "Jahr", font, 7.0f);
        Rendering.textAt(content, 316.0f, 398.0f, "Datum", font, 7.0f);
    }

    private void zeilenbeschriftungenMonatshauptwerteZeitreihe(PDPageContentStream content, float fontSize, float columnsY) throws IOException {
        Column titles = new Column(-1.3f, font, fontSize);
        titles.add("  Jahr");
        titles.add("  N" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  MN" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  M" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  MH" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  H" + this.model.configuration().abflussOderWasserstand().symbol());
        titles.add("  Jahr");
        titles.draw(content, 81.0f, columnsY);
    }

    private void zeichneJahreshaupwerteInSpalte(PDPageContentStream content, Map<HauptwerteRenderModel.ZeilenJahreshauptwerte, ? extends Map<HauptwerteRenderModel.SpaltenJahreshauptwerte, String>> model, HauptwerteRenderModel.SpaltenJahreshauptwerte spalte, float fontSize, int x2, int y2) throws IOException {
        this.zeichneJahreshaupwerteInSpalte(content, model, spalte, fontSize, x2, y2, true);
    }

    private void zeichneJahreshaupwerteInSpalte(PDPageContentStream content, Map<HauptwerteRenderModel.ZeilenJahreshauptwerte, ? extends Map<HauptwerteRenderModel.SpaltenJahreshauptwerte, String>> model, HauptwerteRenderModel.SpaltenJahreshauptwerte spalte, float fontSize, int x2, int y2, boolean rightAligned) throws IOException {
        Column column = new Column(-1.3f, font, fontSize);
        column.add(model.get((Object)HauptwerteRenderModel.ZeilenJahreshauptwerte.N).get((Object)spalte));
        column.add(model.get((Object)HauptwerteRenderModel.ZeilenJahreshauptwerte.M).get((Object)spalte));
        column.add(model.get((Object)HauptwerteRenderModel.ZeilenJahreshauptwerte.H).get((Object)spalte));
        column.add("");
        column.add(model.get((Object)HauptwerteRenderModel.ZeilenJahreshauptwerte.N_spende).get((Object)spalte));
        column.add(model.get((Object)HauptwerteRenderModel.ZeilenJahreshauptwerte.M_spende).get((Object)spalte));
        column.add(model.get((Object)HauptwerteRenderModel.ZeilenJahreshauptwerte.H_spende).get((Object)spalte));
        if (rightAligned) {
            column.drawRightAligned(content, x2, y2);
        } else {
            column.draw(content, x2, y2);
        }
    }
}

