/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.awt.Color;
import java.awt.Font;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Dauertabelle;
import luwa.marlin.ship_library.model.Dauerzahlen;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.Wertebereich;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.pdf.helpers.Chart;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;
import luwa.marlin.ship_library.view.pdf.helpers.XYStepPathRenderer;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class Dauerlinie
implements OutputView {
    private final long messstellenNummer;
    private final Parameter parameter;
    private final Abflussjahresreihe range;
    private final DatenRepository datenRepository;
    private final Color color;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final Font arial;

    public Dauerlinie(long messstellenNummer, Parameter parameter, Abflussjahresreihe range, DatenRepository datenRepository, Color color, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.messstellenNummer = messstellenNummer;
        this.parameter = parameter;
        this.range = range;
        this.datenRepository = datenRepository;
        this.color = color;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
        this.arial = new Font("Arial", 0, 14);
    }

    @Override
    public String name() {
        return "Dauerlinie";
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        Chart.writeAsPDF(out, this.chart());
    }

    private JFreeChart chart() throws Exception {
        Messstelle messstelle = this.datenRepository.messstelle(this.messstellenNummer);
        NHNTransformationOfTimestampedValues transformation = NHNTransformationOfTimestampedValues.buildNHNTransform(this.messstellenNummer, this.datenRepository, this.wasserstandBezugsh\u00f6he);
        Interval interval = this.range.interval();
        Ausfalljahre ausfalljahre = this.datenRepository.ausfalljahre(this.messstellenNummer, this.parameter, interval);
        Tagesmittelwerte tagesmittelwerte = this.datenRepository.tagesmittelwerte(this.messstellenNummer, this.parameter, interval, ausfalljahre, 1.0, transformation, TimestampedValue::compareTo);
        XYSeriesCollection dataSet = this.CalculatePlotData(ausfalljahre, tagesmittelwerte);
        JFreeChart chart = ChartFactory.createXYLineChart(this.messstellenNummer + " - " + messstelle.standort() + " - " + messstelle.gew\u00e4sser(), "Tage", this.parameter.symbol() + " in " + AbflussOderWasserstand.fromParameter(this.parameter).einheitLang(this.wasserstandBezugsh\u00f6he), dataSet, PlotOrientation.VERTICAL, false, false, false);
        chart.setBackgroundPaint(Color.white);
        chart.setBackgroundImageAlpha(0.0f);
        chart.getTitle().setFont(this.arial);
        chart.getTitle().setPadding(10.0, 1.0, 1.0, 1.0);
        chart.addSubtitle(this.createStandDatum());
        chart.addSubtitle(this.textElement("Dauerlinie " + this.parameter.nameSingular(), HorizontalAlignment.LEFT, 1.0, -16.0, 50.0));
        chart.addSubtitle(this.textBeschreibungDerAbflussjahresreihe());
        chart.addSubtitle(this.textElement(ausfalljahre.comment(), HorizontalAlignment.RIGHT, 12.0, 1.0, 0.0));
        if (this.wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
            Wertebereich bereich = tagesmittelwerte.werte().Wertebereich();
            if (bereich.istG\u00fcltig()) {
                chart.getXYPlot().getRangeAxis().setRange(bereich.GerundeteUntergrenze(), bereich.GerundeteObergrenze());
            } else {
                chart.addSubtitle(this.fehlermeldung("FEHLER: Keine passenden Wasserstandsdaten oder fehlende NHN Daten zu Pegelnullpunkten im gew\u00e4hlten Zeitraum!"));
                return chart;
            }
        }
        XYPlot plot = chart.getXYPlot();
        LegendTitle legend = new LegendTitle(plot);
        legend.setItemFont(this.arial);
        legend.setBackgroundPaint(Color.white);
        XYTitleAnnotation legendAnnotation = new XYTitleAnnotation(0.02, 0.98, legend, RectangleAnchor.TOP_LEFT);
        legendAnnotation.setMaxWidth(0.3);
        plot.addAnnotation(legendAnnotation);
        if (!tagesmittelwerte.mw(this.range).istL\u00fccke()) {
            WertFormatierer wertFormatierer = new WertFormatierer("-");
            ValueMarker mw = new ValueMarker(wertFormatierer.gerundeterWert(tagesmittelwerte.mw(this.range).wert(), AbflussOderWasserstand.fromParameter(this.parameter), this.wasserstandBezugsh\u00f6he));
            mw.setLabel("M" + this.parameter.symbol());
            mw.setLabelPaint(this.color);
            mw.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            mw.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
            mw.setPaint(this.color);
            plot.addRangeMarker(mw);
        }
        ValueAxis x2 = chart.getXYPlot().getDomainAxis();
        x2.setLabelFont(this.arial);
        x2.setTickLabelFont(this.arial.deriveFont(12.0f));
        x2.setRange(0.0, 365.0);
        plot.getRangeAxis().setLabelFont(this.arial);
        plot.getRangeAxis().setTickLabelFont(this.arial.deriveFont(12.0f));
        plot.setBackgroundPaint(Color.white);
        plot.setBackgroundImageAlpha(0.0f);
        plot.setDomainGridlinePaint(Color.gray);
        plot.setRangeGridlinePaint(Color.gray);
        XYStepPathRenderer step = new XYStepPathRenderer();
        step.setDrawSeriesLineAsPath(true);
        step.setBaseShapesFilled(false);
        step.setSeriesPaint(0, this.color);
        step.setSeriesPaint(1, Color.red);
        step.setSeriesPaint(2, Color.black);
        plot.setRenderer(step);
        return chart;
    }

    private XYSeriesCollection CalculatePlotData(Ausfalljahre ausfalljahre, Tagesmittelwerte tagesmittelwerte) {
        Dauertabelle dauertabelle = new Dauertabelle(tagesmittelwerte, ausfalljahre, this.wasserstandBezugsh\u00f6he);
        Map<Integer, Double> obereH\u00fcllwerte = this.obereH\u00fcllwerte(dauertabelle);
        Map<Integer, Double> mittlereWerte = this.mittlereWerte(dauertabelle);
        Map<Integer, Double> untereH\u00fcllwerte = this.untereH\u00fcllwerte(dauertabelle);
        XYSeries durationCurve = new XYSeries((Comparable)((Object)"Dauerlinie"));
        XYSeries upperEnvelope = new XYSeries((Comparable)((Object)"obere H\u00fcllkurve"));
        XYSeries lowerEnvelope = new XYSeries((Comparable)((Object)"untere H\u00fcllkurve"));
        for (int i2 = 0; i2 < 365; ++i2) {
            durationCurve.add((double)i2, (Number)mittlereWerte.get(i2));
            upperEnvelope.add((double)i2, (Number)obereH\u00fcllwerte.get(i2));
            lowerEnvelope.add((double)i2, (Number)untereH\u00fcllwerte.get(i2));
        }
        XYSeriesCollection dataSet = new XYSeriesCollection();
        dataSet.addSeries(durationCurve);
        dataSet.addSeries(upperEnvelope);
        dataSet.addSeries(lowerEnvelope);
        return dataSet;
    }

    private TextTitle textBeschreibungDerAbflussjahresreihe() {
        TextTitle years = new TextTitle("Abflussjahre " + ((Abflussjahr)this.range.startYear()).year() + " - " + ((Abflussjahr)this.range.endYear()).year());
        years.setFont(this.arial.deriveFont(12.0f));
        years.setPosition(RectangleEdge.TOP);
        years.setTextAlignment(HorizontalAlignment.LEFT);
        years.setHorizontalAlignment(HorizontalAlignment.LEFT);
        years.setPadding(1.0, 1.0, 1.0, 1.0);
        years.setMargin(1.0, 50.0, 0.0, 0.0);
        return years;
    }

    private TextTitle fehlermeldung(String text) {
        TextTitle years = new TextTitle(text);
        years.setFont(this.arial.deriveFont(12.0f));
        years.setPosition(RectangleEdge.TOP);
        years.setTextAlignment(HorizontalAlignment.LEFT);
        years.setHorizontalAlignment(HorizontalAlignment.LEFT);
        years.setPadding(1.0, 1.0, 1.0, 1.0);
        years.setMargin(1.0, 50.0, 0.0, 0.0);
        return years;
    }

    private TextTitle textElement(String s2, HorizontalAlignment left, double v2, double v22, double v3) {
        TextTitle type = new TextTitle(s2);
        type.setFont(this.arial.deriveFont(12.0f));
        type.setPosition(RectangleEdge.TOP);
        type.setTextAlignment(left);
        type.setHorizontalAlignment(left);
        type.setPadding(1.0, 1.0, 1.0, v2);
        type.setMargin(v22, v3, 0.0, 0.0);
        return type;
    }

    private TextTitle createStandDatum() {
        TextTitle dataStatus = new TextTitle("Stand: " + Format.formatDay(new DateTime()));
        dataStatus.setFont(this.arial.deriveFont(12.0f));
        dataStatus.setPosition(RectangleEdge.TOP);
        dataStatus.setTextAlignment(HorizontalAlignment.RIGHT);
        dataStatus.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        dataStatus.setPadding(1.0, 1.0, 1.0, 12.0);
        dataStatus.setMargin(-16.0, 0.0, 0.0, 0.0);
        return dataStatus;
    }

    private Map<Integer, Double> untereH\u00fcllwerte(Dauertabelle dauertabelle) {
        return Dauerlinie.missingValuesToNAN(dauertabelle.untereH\u00fcllwerteNachRichtlinie(this.range, AbflussOderWasserstand.fromParameter(this.parameter), Dauerzahlen.AlleTage));
    }

    private Map<Integer, Double> mittlereWerte(Dauertabelle dauertabelle) {
        return Dauerlinie.missingValuesToNAN(dauertabelle.mittlereWerteNachRichtlinie(this.range, AbflussOderWasserstand.fromParameter(this.parameter), Dauerzahlen.AlleTage));
    }

    private Map<Integer, Double> obereH\u00fcllwerte(Dauertabelle dauertabelle) {
        return Dauerlinie.missingValuesToNAN(dauertabelle.obereH\u00fcllwerteNachRichtlinie(this.range, AbflussOderWasserstand.fromParameter(this.parameter), Dauerzahlen.AlleTage));
    }

    private static Map<Integer, Double> missingValuesToNAN(Map<Integer, Optional<Double>> givenMap) {
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        givenMap.keySet().forEach(i2 -> {
            Optional maybeValue = (Optional)givenMap.get(i2);
            if (maybeValue.isPresent()) {
                result.put((Integer)i2, (Double)maybeValue.get());
            } else {
                result.put((Integer)i2, Double.NaN);
            }
        });
        return result;
    }
}

