/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html.uebersicht;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import luwa.marlin.ship_library.model.uebersicht.ProjektHWGKAbgleichModel;
import luwa.marlin.ship_library.view.html.HTMLHelper;
import luwa.marlin.ship_library.view.html.uebersicht.\u00dcbersichtHTML;
import luwa.marlin.web.OutputView;

public class ProjektHWGKAbgleich
implements OutputView {
    private final ProjektHWGKAbgleichModel model;

    public ProjektHWGKAbgleich(ProjektHWGKAbgleichModel model) {
        this.model = model;
    }

    @Override
    public String name() {
        return this.model.\u00fcberschrift();
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream stream) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, StandardCharsets.UTF_8);
        this.writeHTML(printStream);
        printStream.flush();
    }

    private void writeHTML(PrintStream out) {
        out.println("<!DOCTYPE html>");
        out.println("<html lang=\"de\">");
        out.println("<head>");
        out.println("<meta charset=\"" + this.charset().toLowerCase() + "\">");
        out.println("<title>" + HTMLHelper.html(this.model.\u00fcberschrift()) + "</title>");
        out.println("<style>");
        \u00dcbersichtHTML.writeStylesheet(out);
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        this.writeBody(out);
        out.println("</body>");
        out.println("</html>");
    }

    private void writeBody(PrintStream out) {
        out.println("<div class=\"container main-no-station\">");
        out.println("<h2><span>" + HTMLHelper.html(this.model.\u00fcberschrift()) + "</span></h2>");
        out.println("<div class=\"row\">");
        for (ProjektHWGKAbgleichModel.Eigent\u00fcmerAbschnitt eigent\u00fcmerAbschnitt : this.model.eigent\u00fcmerAbschnitte()) {
            out.println("<h3>" + HTMLHelper.html(eigent\u00fcmerAbschnitt.eigent\u00fcmer()) + "</h3>");
            for (ProjektHWGKAbgleichModel.BetreiberAbschnitt betreiberAbschnitt : eigent\u00fcmerAbschnitt.betreiberAbschnitte()) {
                this.writeBetreiberAbschnitt(out, betreiberAbschnitt);
            }
        }
        out.println("</div>");
        out.println("</div>");
    }

    private void writeBetreiberAbschnitt(PrintStream out, ProjektHWGKAbgleichModel.BetreiberAbschnitt betreiberAbschnitt) {
        out.println("<table class=\"table\">");
        out.println("<thead>");
        out.println("<tr>");
        out.println("<th class=\"col-xs-4 success\" style=\"border: none;\"></th>");
        out.println("<th class=\"col-xs-6 success\" style=\"border: none; letter-spacing: 3px;\" colspan=\"3\">HWGK-AK-Abgleich</th>");
        out.println("<th class=\"col-xs-1 success\" style=\"border: none;\">G\u00fcltige</th>");
        out.println("<th class=\"col-xs-1 success\" style=\"border: none;\">HVZ</th>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<th class=\"col-xs-4 success\" style=\"border: none;\">" + HTMLHelper.html(betreiberAbschnitt.betreiber()) + "</th>");
        out.println("<th class=\"col-xs-1 success\" style=\"border: none;\">Datum</th>");
        out.println("<th class=\"col-xs-1 success\" style=\"border: none;\">Abflusskurve</th>");
        out.println("<th class=\"col-xs-4 success\" style=\"border: none;\">Bemerkung</th>");
        out.println("<th class=\"col-xs-1 success\" style=\"border: none;\">Abflusskurve</th>");
        out.println("<th class=\"col-xs-1 success\" style=\"border: none;\">\u00dcbergabekurve</th>");
        out.println("</tr>");
        out.println("</thead>");
        out.println("<tbody>");
        for (ProjektHWGKAbgleichModel.Zeile zeile : betreiberAbschnitt.zeilen()) {
            this.writeZeile(out, zeile);
        }
        out.println("</tbody>");
        out.println("</table>");
    }

    private void writeZeile(PrintStream out, ProjektHWGKAbgleichModel.Zeile zeile) {
        out.println("<tr>");
        out.println("<td>");
        out.println("<a href=\"" + \u00dcbersichtHTML.messstellenStammdatenURL(zeile.messstelle().nummer()) + "\">" + HTMLHelper.html(zeile.messstelle().darstellung()) + "</a>");
        out.println("</td>");
        out.println("<td>" + HTMLHelper.html(zeile.darstellungDatum()) + "</td>");
        out.println("<td>" + HTMLHelper.html(zeile.darstellungAbflusskurve()) + "</td>");
        out.println("<td>");
        this.writeBemerkungen(out, zeile.bemerkungen());
        out.println("</td>");
        out.println("<td>" + HTMLHelper.html(zeile.darstellungG\u00fcltigeAbflusskurve()) + "</td>");
        out.println("<td>" + HTMLHelper.html(zeile.darstellungHVZ\u00dcbergabekurve()) + "</td>");
        out.println("</tr>");
    }

    private void writeBemerkungen(PrintStream out, List<ProjektHWGKAbgleichModel.Bemerkung> bemerkungen) {
        for (ProjektHWGKAbgleichModel.Bemerkung bemerkung : bemerkungen) {
            this.writeBemerkung(out, bemerkung);
        }
    }

    private void writeBemerkung(PrintStream out, ProjektHWGKAbgleichModel.Bemerkung bemerkung) {
        out.println("<div class=\"" + bemerkung.farbe().map(ProjektHWGKAbgleichModel.BemerkungFarbe::cssClass).orElse("") + "\">");
        out.println(HTMLHelper.html(bemerkung.text()));
        out.println("</div>");
    }
}

