/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html.uebersicht;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import luwa.marlin.ship_library.model.uebersicht.PegelMitN\u00e4chsterPegelschauModel;
import luwa.marlin.ship_library.view.html.HTMLHelper;
import luwa.marlin.ship_library.view.html.uebersicht.\u00dcbersichtHTML;
import luwa.marlin.web.OutputView;

public class PegelMitN\u00e4chsterPegelschau
implements OutputView {
    private final PegelMitN\u00e4chsterPegelschauModel model;

    public PegelMitN\u00e4chsterPegelschau(PegelMitN\u00e4chsterPegelschauModel model) {
        this.model = model;
    }

    @Override
    public String name() {
        return this.model.\u00fcberschrift();
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream stream) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, StandardCharsets.UTF_8);
        this.writeHTML(printStream);
        printStream.flush();
    }

    private void writeHTML(PrintStream out) {
        out.println("<!DOCTYPE html>");
        out.println("<html lang=\"de\">");
        out.println("<head>");
        out.println("<meta charset=\"" + this.charset().toLowerCase() + "\">");
        out.println("<title>" + HTMLHelper.html(this.model.\u00fcberschrift()) + "</title>");
        out.println("<style>");
        \u00dcbersichtHTML.writeStylesheet(out);
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        this.writeBody(out);
        out.println("</body>");
        out.println("</html>");
    }

    private void writeBody(PrintStream out) {
        out.println("<div class=\"container main-no-station\">");
        out.println("<h2><span>" + HTMLHelper.html(this.model.\u00fcberschrift()) + "</span></h2>");
        out.println("<div class=\"row\">");
        for (PegelMitN\u00e4chsterPegelschauModel.Eigent\u00fcmerAbschnitt eigent\u00fcmerAbschnitt : this.model.eigent\u00fcmerAbschnitte()) {
            out.println("<h3>" + HTMLHelper.html(eigent\u00fcmerAbschnitt.eigent\u00fcmer()) + "</h3>");
            for (PegelMitN\u00e4chsterPegelschauModel.BetreiberAbschnitt betreiberAbschnitt : eigent\u00fcmerAbschnitt.betreiberAbschnitte()) {
                this.writeBetreiberAbschnitt(out, betreiberAbschnitt);
            }
        }
        out.println("</div>");
        this.writeKn\u00f6pfe(out);
        out.println("</div>");
    }

    private void writeBetreiberAbschnitt(PrintStream out, PegelMitN\u00e4chsterPegelschauModel.BetreiberAbschnitt betreiberAbschnitt) {
        out.println("<table class=\"table\">");
        out.println("<thead>");
        out.println("<tr>");
        out.println("<th class=\"success\" style=\"width: 40%\">" + HTMLHelper.html(betreiberAbschnitt.betreiber()) + "</th>");
        out.println("<th class=\"success\" style=\"width: 30%\">Pegelschau f\u00e4llig (Monat)</th>");
        out.println("<th class=\"success\" style=\"width: 30%\">Vordruck (Pegelschau und Standortqualit\u00e4t)</th>");
        out.println("</tr>");
        out.println("</thead>");
        out.println("<tbody>");
        for (PegelMitN\u00e4chsterPegelschauModel.Zeile zeile : betreiberAbschnitt.zeilen()) {
            this.writeZeile(out, zeile);
        }
        out.println("</tbody>");
        out.println("</table>");
    }

    private void writeZeile(PrintStream out, PegelMitN\u00e4chsterPegelschauModel.Zeile zeile) {
        out.println("<tr>");
        out.println("<td>");
        out.println("<a href=\"" + \u00dcbersichtHTML.messstellenStammdatenURL(zeile.messstelle().nummer()) + "\">" + HTMLHelper.html(zeile.messstelle().darstellung()) + "</a>");
        out.println("</td>");
        out.println("<td>" + HTMLHelper.html(zeile.darstellungPegelschauF\u00e4llig()) + "</td>");
        out.println("<td>");
        out.println("<input type=\"checkbox\" name=\"first_stations[]\" value=\"" + zeile.messstelle().nummer() + "\"> Vordruck");
        out.println("<input type=\"checkbox\" name=\"second_stations[]\" value=\"" + zeile.messstelle().nummer() + "\"> Extrablatt");
        out.println("</td>");
        out.println("</tr>");
    }

    private void writeKn\u00f6pfe(PrintStream out) {
        out.println("<div class=\"row\">");
        out.println("<div class=\"form-group col-xs-4\">");
        out.println("<button id=\"export_button\" class=\"btn btn-default\" name=\"button\" type=\"submit\">Exportieren</button>");
        out.println("</div>");
        out.println("<div class=\"form-group col-xs-4\">");
        out.println("<button id=\"print_button\" class=\"btn btn-default\" name=\"button\" type=\"submit\">Drucken</button>");
        out.println("</div>");
        out.println("</div>");
    }
}

