/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html;

import java.io.PrintStream;
import java.util.function.BiConsumer;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;

public class ListPageHelpers {
    private ListPageHelpers() {
    }

    public static void writeHead(PrintStream out, String title, String ... css) {
        out.println("<!DOCTYPE html>");
        out.println("<html lang='de'>");
        out.println("<head>");
        out.println("<meta charset='utf-8'>");
        out.println("<meta http-equiv='X-UA-Compatible' content='IE=Edge,chrome=1'>");
        out.println("<meta name='viewport' content='width=device-width, initial-scale=1.0'>");
        out.println("<title>" + title + "</title>");
        out.println("<style>");
        ListPageHelpers.writeCSS(out);
        for (String line : css) {
            out.println(line);
        }
        out.println("</style>");
        out.println("</head>");
    }

    private static void writeCSS(PrintStream out) {
        out.println("body {");
        out.println("font-family: Helvetica, Arial, sans-serif;");
        out.println("font-size: 0.8em;");
        out.println("}");
        out.println(".header {");
        out.println("font-size:120%;");
        out.println("width: 90%;");
        out.println("margin: 0 auto;");
        out.println("}");
        out.println(".centered {");
        out.println("text-align: center;");
        out.println("}");
        out.println(".right {");
        out.println("text-align: right;");
        out.println("}");
        out.println(".left {");
        out.println("text-align: left;");
        out.println("}");
        out.println(".row > div {");
        out.println("display: inline-block;");
        out.println("vertical-align: top;");
        out.println("padding: 4px 0;");
        out.println("}");
        out.println(".col-xs-1 {");
        out.println("width: 6.866%;float: left;");
        out.println("}");
        out.println(".col-xs-2 {");
        out.println("width: 15.33%;float: left;");
        out.println("}");
        out.println(".col-xs-3 {");
        out.println("width: 26.2%;float: left;");
        out.println("}");
        out.println(".col-xs-4 {");
        out.println("width: 32.26%;float: left;");
        out.println("}");
        out.println(".col-xs-5 {");
        out.println("width: 40.73%;float: left;");
        out.println("}");
        out.println(".col-xs-6 {");
        out.println("width: 49.2%;float: left;");
        out.println("}");
        out.println(".col-xs-8 {");
        out.println("width: 66.13%;float: left;");
        out.println("}");
        out.println(".col-xs-12 {");
        out.println("width: 100%;float: left;");
        out.println("}");
        out.println(".bold {");
        out.println("font-weight:bold;");
        out.println("}");
        out.println("h1 {");
        out.println("font-size:400%;");
        out.println("margin-bottom:0;");
        out.println("margin-top:0;");
        out.println("}");
        out.println("table {");
        out.println("width: 90%;");
        out.println("margin:0 auto;");
        out.println("border-collapse: collapse;");
        out.println("border-spacing: 0;");
        out.println("font-size: 1.1em;");
        out.println("}");
        out.println("tr:last-child th {");
        out.println("border-bottom: 2px solid #ddd;");
        out.println("}");
        out.println("th {");
        out.println("padding: 6px;");
        out.println("}");
        out.println("td {");
        out.println("text-align: right;");
        out.println("padding: 6px;");
        out.println("}");
        out.println("thead th {");
        out.println("text-align: right;");
        out.println("}");
        out.println("tbody th {");
        out.println("text-align: center;");
        out.println("border-top: 2px solid #ddd;");
        out.println("}");
        out.println("tbody tr td:first-child {");
        out.println("font-weight: bold;");
        out.println("font-family: Helvetica, Arial, sans-serif;");
        out.println("font-size: 1em;");
        out.println("white-space: nowrap;");
        out.println("}");
        out.println("tbody tr td {");
        out.println("font-family: monospace;");
        out.println("font-size: 1.2em;");
        out.println("}");
    }

    private static BiConsumer<String, String> keyValueRowWriteFor(PrintStream out, int keySpace, int valueSpace) {
        return ListPageHelpers.keyValueRowWriteFor(out, keySpace, valueSpace, false, true);
    }

    private static BiConsumer<String, String> keyValueRowWriteFor(PrintStream out, int keySpace, int valueSpace, boolean rightAlign, boolean fillSpace) {
        return (key, value) -> {
            int rest = 12 - (keySpace + valueSpace);
            if (fillSpace && rest > 0) {
                out.println("<div class='col-xs-" + rest + "'>&nbsp;</div>");
            }
            out.println("<div class='col-xs-" + keySpace + "' style='font-size:0.8em;'>" + key + "</div>");
            out.println("<div class='col-xs-" + valueSpace + (rightAlign ? " right" : "") + "'>" + value + "</div>");
        };
    }

    private static BiConsumer<String, String> withRowDiv(PrintStream out, BiConsumer<String, String> rowFunction) {
        return (key, value) -> {
            out.println("<div class='col-xs-12 row'>");
            rowFunction.accept((String)key, (String)value);
            out.println("</div>");
        };
    }

    public static void writeHeader(PrintStream out, String product, String parameter, String unit, TabellenHeaderRenderModel header) {
        BiConsumer<String, String> writeValueWithSmallKey = ListPageHelpers.withRowDiv(out, ListPageHelpers.keyValueRowWriteFor(out, 2, 10));
        BiConsumer<String, String> writeKeyValuePair = ListPageHelpers.withRowDiv(out, ListPageHelpers.keyValueRowWriteFor(out, 5, 7));
        BiConsumer<String, String> writeKeyWithRightAlignedValue = ListPageHelpers.withRowDiv(out, ListPageHelpers.keyValueRowWriteFor(out, 3, 4, true, true));
        BiConsumer<String, String> writeKeyValueAsPartOfRow = ListPageHelpers.keyValueRowWriteFor(out, 3, 9, false, false);
        out.println("<div class='row header'>");
        out.println("<div class='col-xs-12 row'>");
        out.println("<div class='col-xs-12' style='font-weight: bold;font-size: 1.2em;'>" + product + "</div>");
        out.println("</div>");
        out.println("<div class='col-xs-4 row'>");
        writeValueWithSmallKey.accept("AEo:", header.einzugsgebietF\u00fcrAusgabe());
        writeValueWithSmallKey.accept("PNP:", header.nullpunktF\u00fcrAusgabe());
        writeValueWithSmallKey.accept("Lage:", header.lageF\u00fcrAusgabe());
        out.println("</div>");
        out.println("<div class='col-xs-3 row'>");
        out.println("<div class='col-xs-12 centered'><h1>" + parameter + "</h1>" + unit + "</div>");
        out.println("</div>");
        out.println("<div class='col-xs-2 row'>");
        writeKeyValuePair.accept("Standort:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegel));
        writeKeyValuePair.accept("Gew\u00e4sser:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.gew\u00e4sser));
        writeKeyValuePair.accept("Teilgebiet:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.teilgebiet));
        out.println("</div>");
        out.println("<div class='col-xs-3 row'>");
        writeKeyWithRightAlignedValue.accept("Nr.:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nr));
        writeKeyWithRightAlignedValue.accept("Zeitbezug:", "MEZ");
        writeKeyWithRightAlignedValue.accept("Datenstand:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.datenstand));
        out.println("</div>");
        out.println("<div class='col-xs-12 row'>");
        out.println("<div class='col-xs-5'>");
        writeKeyValueAsPartOfRow.accept("Pegelbetreiber:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegelbetreiber));
        out.println("</div>");
        out.println("<div class='col-xs-5'>");
        writeKeyValueAsPartOfRow.accept("Herausgeber:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.herausgeber));
        out.println("</div>");
        out.println("<div class='col-xs-2'>");
        writeKeyValueAsPartOfRow.accept("Quelle:", header.wertF\u00fcr(TabellenHeaderRenderModel.felder.quelle));
        out.println("</div>");
        out.println("</div>");
        out.println("</div>");
    }
}

