/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.Tageswerte;
import luwa.marlin.ship_library.model.ZeitbereicheMitErg\u00e4nztenWerten;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.MonatsHauptwerteRenderModel;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.TageswerteRenderModel;
import luwa.marlin.ship_library.view.ViewHelper;
import luwa.marlin.ship_library.view.html.ListPageHelpers;
import luwa.marlin.ship_library.view.pdf.helpers.FehlenderWertFehler;
import luwa.marlin.ship_library.view.pdf.helpers.FestgelegterFormatierer;
import luwa.marlin.ship_library.view.pdf.helpers.FormatierungsErgebnis;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.joda.time.Interval;

public class Jahrestabelle
implements OutputView {
    private final long messstellenNummer;
    private final AbflussOderWasserstand abflussOderWasserstand;
    private final int year;
    private final DatenRepository datenRepository;
    private final long benutzerId;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final FestgelegterFormatierer wertFomratierer;
    private NHNTransformationOfTimestampedValues nhntransform;

    public Jahrestabelle(long messstellenNummer, AbflussOderWasserstand abflussOderWasserstand, int year, DatenRepository datenRepository, long benutzerId, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.messstellenNummer = messstellenNummer;
        this.abflussOderWasserstand = abflussOderWasserstand;
        this.year = year;
        this.datenRepository = datenRepository;
        this.benutzerId = benutzerId;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
        this.wertFomratierer = new FestgelegterFormatierer("-", wasserstandBezugsh\u00f6he, abflussOderWasserstand);
    }

    @Override
    public String name() {
        return "Jahrestabelle";
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, StandardCharsets.UTF_8);
        this.writeTo(printStream);
        printStream.flush();
    }

    private void writeTable(PrintStream out) throws Exception {
        this.nhntransform = NHNTransformationOfTimestampedValues.buildNHNTransform(this.messstellenNummer, this.datenRepository, this.wasserstandBezugsh\u00f6he);
        out.println("<table>");
        this.writeSpaltenbeschriftungen(out);
        this.writeTableBody(out);
        out.println("</table>");
    }

    private void writeTableBody(PrintStream out) throws Exception {
        out.println("<tbody>");
        Abflussjahr months = new Abflussjahr(this.year);
        Tagesmittelwerte dayMeans = this.datenRepository.tagesmittelwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.hydrologicalYear(this.year), new Ausfalljahre(), 1.0, this.nhntransform, TimestampedValue::compareTo);
        ZeitbereicheMitErg\u00e4nztenWerten editedRanges = this.datenRepository.bearbeiteteZeitbereiche(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.hydrologicalYear(this.year));
        TageswerteRenderModel tageswerteModel = new TageswerteRenderModel(new Tageswerte(dayMeans, editedRanges), new Abflussjahr(this.year).monate(), this.abflussOderWasserstand, this.wasserstandBezugsh\u00f6he);
        this.writeTagesmittelwerte(tageswerteModel, out, months);
        this.writeHauptwerte(out, months, dayMeans);
        this.writeScheitelwerte(out, months);
        out.println("</tbody>");
    }

    private void writeTagesmittelwerte(TageswerteRenderModel tageswerteModel, PrintStream out, Iterable<YearMonth> months) {
        for (int day = 1; day <= 31; ++day) {
            out.println("<tr>");
            out.println("<td>" + day + ".</td>");
            for (YearMonth month : months) {
                out.println("<td>" + tageswerteModel.wert(month, day) + "</td>");
            }
            out.println("</tr>");
        }
    }

    private void writeHauptwerte(PrintStream out, Iterable<YearMonth> monate, Tagesmittelwerte tagesmittelwerte) throws Exception {
        Hauptwerte hauptwerte = new Hauptwerte(tagesmittelwerte, this.datenRepository.tagesh\u00f6chstwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.hydrologicalYear(this.year), new Ausfalljahre(), 1.0, this.nhntransform), this.datenRepository.scheitelwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), new Ausfalljahre()), null, new Ausfalljahre());
        MonatsHauptwerteRenderModel model = new MonatsHauptwerteRenderModel(hauptwerte, monate, this.abflussOderWasserstand, false, this.wertFomratierer);
        out.println("<tr>");
        out.println("<th colspan='13'>Hauptwerte</th>");
        out.println("</tr>");
        List.of(MonatsHauptwerteRenderModel.ZeilenMonatswerte.Tag_N, MonatsHauptwerteRenderModel.ZeilenMonatswerte.N, MonatsHauptwerteRenderModel.ZeilenMonatswerte.M, MonatsHauptwerteRenderModel.ZeilenMonatswerte.H, MonatsHauptwerteRenderModel.ZeilenMonatswerte.Tag_H, MonatsHauptwerteRenderModel.ZeilenMonatswerte.Uhrzeit_H).forEach(zeile -> {
            out.println("<tr>");
            out.println("<td>" + model.Zeilenname((MonatsHauptwerteRenderModel.ZeilenMonatswerte)((Object)zeile)) + "</td>");
            for (YearMonth monat : monate) {
                out.println("<td>" + model.wert(monat, (MonatsHauptwerteRenderModel.ZeilenMonatswerte)((Object)zeile)) + "</td>");
            }
            out.println("</tr>");
        });
    }

    private void writeScheitelwerte(PrintStream out, Iterable<YearMonth> months) throws Exception {
        out.println("<tr>");
        out.println("<th colspan='13'>Hochwasser</th>");
        out.println("</tr>");
        ArrayList alleFehler = new ArrayList();
        Scheitelwerte peaks = this.datenRepository.scheitelwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.hydrologicalYear(this.year), new Ausfalljahre(), 1.0, this.nhntransform);
        for (int peakNo = 0; peakNo < 3; ++peakNo) {
            Scheitelwert peak;
            out.println("<tr>");
            out.println("<td>" + (peakNo + 1) + ". Scheitel</td>");
            for (YearMonth month : months) {
                peak = peaks.nthInMonth(peakNo, month);
                String formatierterScheitelwert = "";
                if (peak != null) {
                    FormatierungsErgebnis formatierungsErgebnis = this.wertFomratierer.nurSignifikanteStellenVonTimeStampedValue(peak.asOptional(), this.abflussOderWasserstand, zeitpunkt -> "Es fehlt ein Scheitelwert in einem hydrologischen Halbjahr.");
                    formatierungsErgebnis.fehler().map(alleFehler::add);
                    formatierterScheitelwert = formatierungsErgebnis.formatierterWert();
                }
                out.println("<td>" + formatierterScheitelwert + "</td>");
            }
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td>Datum</td>");
            for (YearMonth month : months) {
                peak = peaks.nthInMonth(peakNo, month);
                out.println("<td>" + (String)(peak == null ? "" : this.wertFomratierer.tagDesMonats(peak) + "<br>" + this.wertFomratierer.uhrzeit(peak)) + "</td>");
            }
            out.println("</tr>");
        }
        for (FehlenderWertFehler fehler : alleFehler) {
            out.println("<h2>" + fehler.toString() + "</h2>");
        }
    }

    private void writeSpaltenbeschriftungen(PrintStream out) {
        out.println("<thead>");
        out.println("<tr>");
        out.println("<th>Tag</th>");
        out.println("<th>Nov</th>");
        out.println("<th>Dez</th>");
        out.println("<th>Jan</th>");
        out.println("<th>Feb</th>");
        out.println("<th>Mar</th>");
        out.println("<th>Apr</th>");
        out.println("<th>Mai</th>");
        out.println("<th>Jun</th>");
        out.println("<th>Jul</th>");
        out.println("<th>Aug</th>");
        out.println("<th>Sep</th>");
        out.println("<th>Okt</th>");
        out.println("</tr>");
        out.println("</thead>");
    }

    private void writeTo(PrintStream out) throws Exception {
        Messstelle messstelle = this.datenRepository.messstelle(this.messstellenNummer);
        Benutzer benutzer = this.datenRepository.benutzer(this.benutzerId);
        Optional<Pegelnullpunkt> pegelnullpunkt = ViewHelper.pegelnullpunkt(this.datenRepository, this.messstellenNummer);
        TabellenHeaderRenderModel header = new TabellenHeaderRenderModel(messstelle, pegelnullpunkt, benutzer, this.wasserstandBezugsh\u00f6he);
        ListPageHelpers.writeHead(out, "Jahrestabelle " + this.year + " von " + this.messstellenNummer, "thead tr th {", "width: 7%;", "}", "thead tr th:nth-child(2) {", "width: 9%;", "}", "thead tr th:nth-child(8) {", "width: 9%;", "}", "tbody tr:nth-child(10) td {", "padding-bottom: 20px;", "}", "tbody tr:nth-child(20) td {", "padding-bottom: 20px;", "}", "tbody tr:nth-child(30) td {", "padding-bottom: 20px;", "}");
        out.println("<body>");
        ListPageHelpers.writeHeader(out, "Jahrestabelle Abflussjahr " + this.year, this.abflussOderWasserstand.symbol(), this.abflussOderWasserstand.einheitLang(this.wasserstandBezugsh\u00f6he) + "<br>Tagesmittel", header);
        this.writeTable(out);
        out.println("</body>");
        out.println("</html>");
        out.println();
    }

    private Interval hydrologicalYear(int year) {
        return new Abflussjahr(year).interval();
    }
}

