/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import luwa.marlin.ship_library.model.Aufl\u00f6sungsZeitbereich;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.web.OutputView;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class Datenbestandsstatistik
implements OutputView {
    private final long messstellenNummer;
    private final Parameter parameter;
    private final DatenRepository datenRepository;

    public Datenbestandsstatistik(long messstellenNummer, Parameter parameter, DatenRepository datenRepository) {
        this.messstellenNummer = messstellenNummer;
        this.parameter = parameter;
        this.datenRepository = datenRepository;
    }

    @Override
    public String name() {
        return "Datenbestandsstatistik";
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream stream) throws Exception {
        Messstelle messstelle = this.datenRepository.messstelle(this.messstellenNummer);
        Interval range = this.datenRepository.datenbestand(this.messstellenNummer, this.parameter);
        List<Interval> gapIntervals = this.intervalsIn(this.datenRepository.l\u00fccken(this.messstellenNummer, this.parameter), this.datenRepository.aufl\u00f6sungen(this.messstellenNummer));
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, StandardCharsets.UTF_8);
        out.println("<!DOCTYPE html>");
        out.println("<html>");
        out.println("<head>");
        out.println("<meta charset=\"utf-8\">");
        out.println("</head>");
        out.println("<body>");
        out.println("<div style='margin: 0 auto;display:table;line-height: 1.5;'>");
        out.println("<h2>Datenbestand " + this.parameter.symbol() + " von " + messstelle.bezeichnung() + "</h2>");
        out.println("<div style='float:left;'>Erbaut:</div>");
        out.println("<div style='float:right;'>" + Format.formatDay(messstelle.erbautAm()) + "</div>");
        out.println("<div style='clear:both;'></div>");
        out.println("<div style='float:left;'>Aufgehoben:</div>");
        if (messstelle.aufgehobenAm() != null) {
            out.println("<div style='float:right;'>" + Format.formatDay(messstelle.aufgehobenAm()) + "</div>");
        }
        out.println("<div style='clear:both;'></div>");
        out.println("<div style='float:left;'>Daten ab:</div>");
        out.println("<div style='float:right;'>" + Format.formatDay(range.getStart()) + "</div>");
        out.println("<div style='clear:both;'></div>");
        out.println("<div style='float:left;'>Daten bis:</div>");
        out.println("<div style='float:right;'>" + Format.formatDay(range.getEnd()) + "</div>");
        out.println("<div style='clear:both;'></div>");
        out.println("<div style='float:left;'>L\u00fccken:</div>");
        out.println("<div style='float:right;'>");
        for (Interval interval : gapIntervals) {
            if (interval.getStart().equals(interval.getEnd())) {
                out.println(Format.formatFullDayAndTime(interval.getStart()) + "<br>");
                continue;
            }
            out.println(Format.formatFullDayAndTime(interval.getStart()) + " - " + Format.formatFullDayAndTime(interval.getEnd()) + "<br>");
        }
        out.println("</div>");
        out.println("<div style='clear:both;'></div>");
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }

    private List<Interval> intervalsIn(List<TimestampedValue> gaps, List<Aufl\u00f6sungsZeitbereich> resolutions) {
        if (gaps.isEmpty()) {
            return new ArrayList<Interval>();
        }
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (TimestampedValue gap : gaps) {
            if (result.isEmpty()) {
                result.add(new Interval((ReadableInstant)gap.timestamp(), (ReadableInstant)gap.timestamp()));
                continue;
            }
            int rasterMinutes = this.minutesAt(resolutions, gap.timestamp());
            Interval lastGapInterval = (Interval)result.get(result.size() - 1);
            if (lastGapInterval.getEnd().plusMinutes(rasterMinutes).isBefore(gap.timestamp())) {
                result.add(new Interval((ReadableInstant)gap.timestamp(), (ReadableInstant)gap.timestamp()));
                continue;
            }
            result.set(result.size() - 1, lastGapInterval.withEnd(gap.timestamp()));
        }
        return result;
    }

    private int minutesAt(List<Aufl\u00f6sungsZeitbereich> resolutions, DateTime timestamp) {
        for (Aufl\u00f6sungsZeitbereich resolution : resolutions) {
            if (resolution.bis() != null && !resolution.bis().isAfter(timestamp)) continue;
            return resolution.rasterMinuten();
        }
        return resolutions.isEmpty() ? 0 : resolutions.get(resolutions.size() - 1).rasterMinuten();
    }
}

