/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.Tageswerte;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.view.pdf.helpers.FestgelegterFormatierer;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;

public class TageswerteRenderModel {
    private final Map<YearMonth, Map<Integer, String>> werte;
    private final Map<YearMonth, Map<Integer, Boolean>> erg\u00e4nzt;

    public TageswerteRenderModel(Tageswerte tageswerte, Supplier<Stream<YearMonth>> monate, AbflussOderWasserstand abflussOderWasserstand) {
        this(tageswerte, monate, abflussOderWasserstand, WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt);
    }

    public TageswerteRenderModel(Tageswerte tageswerte, Supplier<Stream<YearMonth>> monate, AbflussOderWasserstand abflussOderWasserstand, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this(tageswerte, monate, abflussOderWasserstand, new FestgelegterFormatierer("-", wasserstandBezugsh\u00f6he, abflussOderWasserstand, false));
    }

    public TageswerteRenderModel(Tageswerte tageswerte, Supplier<Stream<YearMonth>> monate, AbflussOderWasserstand abflussOderWasserstand, FestgelegterFormatierer wertFormatierer) {
        Function<Optional<? extends TimestampedValue>, String> formatiert = wertFormatierer::nurSignifikanteStellenVonTimeStampedValue;
        this.erg\u00e4nzt = new HashMap<YearMonth, Map<Integer, Boolean>>();
        this.werte = new HashMap<YearMonth, Map<Integer, String>>();
        this.berechneWerte(tageswerte, monate.get(), formatiert);
    }

    public TageswerteRenderModel(Jahrbuchseite data) {
        this(data.tageswerte(), data.configuration().erweitertesJahr().monate(), data.configuration().abflussOderWasserstand(), data.configuration().wasserstandBezugsh\u00f6he());
    }

    public String wert(YearMonth monat, int tag) {
        return this.werte.get(monat).get(tag);
    }

    public Map<YearMonth, Map<Integer, String>> werte() {
        return this.werte;
    }

    public Boolean istErg\u00e4nzt(YearMonth monat, int tag) {
        return this.erg\u00e4nzt.get(monat).get(tag);
    }

    private void berechneWerte(Tageswerte tageswerte, Stream<YearMonth> monate, Function<Optional<? extends TimestampedValue>, String> formatiert) {
        monate.forEach(monat -> {
            HashMap monatswerte = new HashMap();
            HashMap erg\u00e4nztF\u00fcrMonat = new HashMap();
            IntStream.rangeClosed(1, 31).forEach(tag -> {
                Tagesmittelwert wert = tageswerte.valueFor((YearMonth)monat, tag);
                monatswerte.put(tag, TageswerteRenderModel.wertAlsText(formatiert, monat, tag, wert));
                if (wert != null) {
                    erg\u00e4nztF\u00fcrMonat.put(tag, tageswerte.istErg\u00e4nzt(wert));
                } else {
                    erg\u00e4nztF\u00fcrMonat.put(tag, false);
                }
            });
            this.werte.put((YearMonth)monat, monatswerte);
            this.erg\u00e4nzt.put((YearMonth)monat, erg\u00e4nztF\u00fcrMonat);
        });
    }

    private static String wertAlsText(Function<Optional<? extends TimestampedValue>, String> formatiert, YearMonth monat, int tag, Tagesmittelwert wert) {
        if (null != wert) {
            return formatiert.apply(Optional.of(wert));
        }
        if (tag <= monat.lastDayOfMonth()) {
            return formatiert.apply(Optional.empty());
        }
        return "";
    }
}

