/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.util.Map;
import java.util.Optional;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Organisation;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.Padding;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import org.joda.time.DateTime;

public class TabellenHeaderRenderModel {
    private boolean istSeepegel;
    private Map<felder, String> model;

    public TabellenHeaderRenderModel(Jahrbuchseite jahrbuchseite) {
        this(jahrbuchseite.messstelle(), jahrbuchseite.pegelnullpunktwechsel().nullpunktAm(jahrbuchseite.configuration().erstellungsdatum()), jahrbuchseite.configuration().erstellungsdatum(), jahrbuchseite.benutzer().map(benutzer -> benutzer.organisationseinheiten()).orElse(""), jahrbuchseite.messstelle().istSeepegel(), jahrbuchseite.configuration().wasserstandBezugsh\u00f6he());
    }

    public TabellenHeaderRenderModel(Messstelle messstelle, Optional<Pegelnullpunkt> pegelnullpunkt, Benutzer benutzer) {
        this(messstelle, pegelnullpunkt, new DateTime(), benutzer.organisationseinheiten(), messstelle.istSeepegel(), WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt);
    }

    public TabellenHeaderRenderModel(Messstelle messstelle, Optional<Pegelnullpunkt> pegelnullpunkt, Benutzer benutzer, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this(messstelle, pegelnullpunkt, new DateTime(), benutzer.organisationseinheiten(), messstelle.istSeepegel(), wasserstandBezugsh\u00f6he);
    }

    public TabellenHeaderRenderModel(Messstelle messstelle, Optional<Pegelnullpunkt> pegelNullpunkt, DateTime datum, String organisationseinheiten, boolean istSeepegel, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.istSeepegel = istSeepegel;
        Double fl\u00e4che = messstelle.fl\u00e4cheEinzugsgebietInQuadratkilometer();
        this.model = Map.ofEntries(Map.entry(felder.einzugsgebiet, messstelle.istSeepegel() ? "Seepegel" : (null != fl\u00e4che ? Format.formatDrainageBasinSize(fl\u00e4che) : "")), Map.entry(felder.einzugsgebiet_einheit, messstelle.istSeepegel() ? "" : (null != fl\u00e4che ? "km\u00b2" : "")), Map.entry(felder.nullpunkt, wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt ? Format.formatZeroPoint(pegelNullpunkt.map(Pegelnullpunkt::\u00fcberNN).orElse(-999.0)) : Format.formatZeroPoint(pegelNullpunkt.flatMap(Pegelnullpunkt::m\u00dcberNHNInHS170).orElse(-999.0))), Map.entry(felder.nullpunkt_einheit, wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt ? "m  " + pegelNullpunkt.map(Pegelnullpunkt::h\u00f6hensystem).orElse("Kein System gefunden!") : "m  DHHN2016 (HS170)"), Map.entry(felder.lage, messstelle.istSeepegel() ? "See" : Padding.kmFormat.format(messstelle.entfernungZurM\u00fcndung())), Map.entry(felder.lage_einheit, messstelle.istSeepegel() ? "" : "km "), Map.entry(felder.lage_bezugspunkt, messstelle.istSeepegel() ? "" : TabellenHeaderRenderModel.positionDescription(messstelle.gew\u00e4sser()) + messstelle.lageAmGew\u00e4sser()), Map.entry(felder.nr, Long.toString(messstelle.nummer())), Map.entry(felder.datenstand, Format.formatDay(datum)), Map.entry(felder.pegel, messstelle.standort()), Map.entry(felder.gew\u00e4sser, messstelle.gew\u00e4sser()), Map.entry(felder.teilgebiet, this.fehlerzeichenFallsNull(messstelle.bearbeitungsgebiet())), Map.entry(felder.flussgebietseinheit, this.fehlerzeichenFallsNull(messstelle.flussgebiet())), Map.entry(felder.pegelbetreiber, this.fehlerzeichenFallsNull(messstelle.betreiber())), Map.entry(felder.herausgeber, organisationseinheiten.split(",")[0]), Map.entry(felder.quelle, Organisation.kurzname()));
    }

    private String fehlerzeichenFallsNull(Object s2) {
        return s2 == null ? "-" : s2.toString();
    }

    public boolean istSeepegel() {
        return this.istSeepegel;
    }

    public String einzugsgebietF\u00fcrAusgabe() {
        return this.einzugsgebietF\u00fcrAusgabe(12);
    }

    public String einzugsgebietF\u00fcrAusgabe(int align) {
        return Padding.leftPad(this.wertF\u00fcr(felder.einzugsgebiet), align) + " " + this.wertF\u00fcr(felder.einzugsgebiet_einheit);
    }

    public String nullpunktF\u00fcrAusgabe() {
        return this.nullpunktF\u00fcrAusgabe(12);
    }

    public String nullpunktF\u00fcrAusgabe(int align) {
        return "NN + " + Padding.leftPad(this.wertF\u00fcr(felder.nullpunkt), align - "NN + ".length()) + " " + this.wertF\u00fcr(felder.nullpunkt_einheit);
    }

    public String lageF\u00fcrAusgabe() {
        return this.lageF\u00fcrAusgabe(12);
    }

    public String lageF\u00fcrAusgabe(int align) {
        if (this.istSeepegel()) {
            return "Seepegel";
        }
        return Padding.leftPad(this.wertF\u00fcr(felder.lage), align) + " " + this.wertF\u00fcr(felder.lage_einheit) + " " + this.wertF\u00fcr(felder.lage_bezugspunkt);
    }

    public String wertF\u00fcr(felder feld) {
        return this.model.get((Object)feld);
    }

    private static String positionDescription(String bodyOfWater) {
        if ("Rhein".equalsIgnoreCase(bodyOfWater)) {
            return "unterhalb der Rheinbr\u00fccke Konstanz, ";
        }
        return "oberhalb der M\u00fcndung, ";
    }

    public static enum felder {
        einzugsgebiet,
        nullpunkt,
        einzugsgebiet_einheit,
        nullpunkt_einheit,
        lage,
        lage_einheit,
        lage_bezugspunkt,
        pegel,
        teilgebiet,
        gew\u00e4sser,
        flussgebietseinheit,
        nr,
        datenstand,
        pegelbetreiber,
        herausgeber,
        quelle;

    }
}

