/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.util.HashMap;
import java.util.Map;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.util.OptionalMitMarkierung;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;

public class MonatsHauptwerteRenderModel {
    private final Hauptwerte hauptwerte;
    private final Iterable<YearMonth> monate;
    private final AbflussOderWasserstand QoderW;
    private final WertFormatierer formatierteWerte;
    private final Map<YearMonth, ? extends Map<ZeilenMonatswerte, String>> werte;
    private final boolean mehrfachmarkierung;

    public MonatsHauptwerteRenderModel(Hauptwerte hauptwerte, Iterable<YearMonth> monate, AbflussOderWasserstand qoderW) {
        this(hauptwerte, monate, qoderW, true);
    }

    public MonatsHauptwerteRenderModel(Hauptwerte hauptwerte, Iterable<YearMonth> monate, AbflussOderWasserstand qoderW, WertFormatierer wertFormatierer) {
        this(hauptwerte, monate, qoderW, true, wertFormatierer);
    }

    public MonatsHauptwerteRenderModel(Hauptwerte hauptwerte, Iterable<YearMonth> monate, AbflussOderWasserstand qoderW, boolean mehrfachmarkierung) {
        this(hauptwerte, monate, qoderW, mehrfachmarkierung, new WertFormatierer("-"));
    }

    public MonatsHauptwerteRenderModel(Hauptwerte hauptwerte, Iterable<YearMonth> monate, AbflussOderWasserstand qoderW, boolean mehrfachmarkierung, WertFormatierer wertFormatierer) {
        this.mehrfachmarkierung = mehrfachmarkierung;
        this.hauptwerte = hauptwerte;
        this.monate = monate;
        this.QoderW = qoderW;
        this.formatierteWerte = wertFormatierer;
        this.werte = this.berechneWerte();
    }

    public static String Zeilenname(ZeilenMonatswerte zeile, AbflussOderWasserstand QoderW) {
        switch (zeile) {
            case Tag_N: 
            case Tag_H: {
                return "Tag";
            }
            case N: {
                return "N" + QoderW;
            }
            case M: {
                return "M" + QoderW;
            }
            case H: {
                return "H" + QoderW;
            }
            case Uhrzeit_H: {
                return "Uhr";
            }
        }
        throw new IllegalArgumentException("Monatshauptwert zeilentyp " + zeile);
    }

    public String Zeilenname(ZeilenMonatswerte zeile) {
        return MonatsHauptwerteRenderModel.Zeilenname(zeile, this.QoderW);
    }

    public Map<YearMonth, ? extends Map<ZeilenMonatswerte, String>> werte() {
        return this.werte;
    }

    public String wert(YearMonth monat, ZeilenMonatswerte zeile) {
        return this.werte.get(monat).get((Object)zeile);
    }

    private Map<YearMonth, ? extends Map<ZeilenMonatswerte, String>> berechneWerte() {
        HashMap<YearMonth, Map<ZeilenMonatswerte, String>> model = new HashMap<YearMonth, Map<ZeilenMonatswerte, String>>();
        for (YearMonth monat : this.monate) {
            Map<ZeilenMonatswerte, String> neueSpalte = this.spalteMonatshauptwerte(monat);
            model.put(monat, neueSpalte);
        }
        return model;
    }

    private Map<ZeilenMonatswerte, String> spalteMonatshauptwerte(YearMonth monat) {
        OptionalMitMarkierung<? extends TimestampedValue> N = new OptionalMitMarkierung<TimestampedValue>(this.hauptwerte.monatswert(monat, Hauptwerte.Art.N));
        OptionalMitMarkierung<? extends TimestampedValue> M = new OptionalMitMarkierung<TimestampedValue>(this.hauptwerte.monatswert(monat, Hauptwerte.Art.M));
        OptionalMitMarkierung<? extends TimestampedValue> H = new OptionalMitMarkierung<TimestampedValue>(this.hauptwerte.monatswert(monat, Hauptwerte.Art.H));
        return Map.ofEntries(Map.entry(ZeilenMonatswerte.Tag_N, this.mehrfachmarkierung ? this.formatierteWerte.tagDesMonatsMitMehrfachMarkierung(N) : this.formatierteWerte.tagDesMonats(N)), Map.entry(ZeilenMonatswerte.Datum_N, this.mehrfachmarkierung ? this.formatierteWerte.datumMitMehrfachMarkierung(N) : this.formatierteWerte.datum(N)), Map.entry(ZeilenMonatswerte.N, this.formatierteWerte.nurSignifikanteStellen(N.value(), this.QoderW)), Map.entry(ZeilenMonatswerte.M, this.formatierteWerte.nurSignifikanteStellen(M.value(), this.QoderW)), Map.entry(ZeilenMonatswerte.H, this.formatierteWerte.nurSignifikanteStellen(H.value(), this.QoderW)), Map.entry(ZeilenMonatswerte.Tag_H, this.mehrfachmarkierung ? this.formatierteWerte.tagDesMonatsMitMehrfachMarkierung(H) : this.formatierteWerte.tagDesMonats(H)), Map.entry(ZeilenMonatswerte.Datum_H, this.mehrfachmarkierung ? this.formatierteWerte.datumMitMehrfachMarkierung(H) : this.formatierteWerte.datum(H)), Map.entry(ZeilenMonatswerte.Uhrzeit_H, this.formatierteWerte.uhrzeit(H)));
    }

    public static enum ZeilenMonatswerte {
        Datum_N,
        Tag_N,
        N,
        M,
        H,
        Tag_H,
        Datum_H,
        Uhrzeit_H;

    }
}

