/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.util.ArrayList;
import java.util.List;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.DauertabelleRenderModel;
import luwa.marlin.ship_library.view.ExtremwerteRenderModel;
import luwa.marlin.ship_library.view.HauptwerteRenderModel;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.TageswerteRenderModel;
import luwa.marlin.ship_library.view.pdf.helpers.FestgelegterFormatierer;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;
import org.joda.time.DateTime;

public class JahrbuchseiteRenderModel {
    private final TageswerteRenderModel tageswerteRenderModel;
    private final HauptwerteRenderModel hauptwerteRenderModel;
    private final ExtremwerteRenderModel extremwerteRenderModel;
    private final DauertabelleRenderModel dauertabelleRenderModel;
    private final TabellenHeaderRenderModel headerUndFooterModel;
    private final String bemerkungen;
    private final boolean abflussspendeAngeben;
    private final JahrbuchseitenConfiguration configuration;

    public boolean abflussspendeAngeben() {
        return this.abflussspendeAngeben;
    }

    public JahrbuchseiteRenderModel(Jahrbuchseite data) {
        FestgelegterFormatierer wertFormatierer = new FestgelegterFormatierer("-", data.configuration().wasserstandBezugsh\u00f6he(), data.configuration().abflussOderWasserstand(), false);
        this.dauertabelleRenderModel = new DauertabelleRenderModel(data, wertFormatierer);
        this.extremwerteRenderModel = new ExtremwerteRenderModel(data, wertFormatierer);
        this.hauptwerteRenderModel = new HauptwerteRenderModel(data, wertFormatierer);
        this.headerUndFooterModel = new TabellenHeaderRenderModel(data);
        this.tageswerteRenderModel = new TageswerteRenderModel(data);
        this.abflussspendeAngeben = data.abflussspendeBerechnen();
        this.configuration = data.configuration();
        this.bemerkungen = this.compileBemerkungen(data, this.hauptwerteRenderModel);
    }

    public DauertabelleRenderModel dauertabelle() {
        return this.dauertabelleRenderModel;
    }

    public ExtremwerteRenderModel extremwerte() {
        return this.extremwerteRenderModel;
    }

    public HauptwerteRenderModel hauptwerte() {
        return this.hauptwerteRenderModel;
    }

    public JahrbuchseitenConfiguration configuration() {
        return this.configuration;
    }

    public TabellenHeaderRenderModel headerUndFooterModel() {
        return this.headerUndFooterModel;
    }

    public String anzahlJahreZeitreihe() {
        return Integer.toString(this.configuration.hydrologicalYearsRange().numberOfYears());
    }

    public String einheit() {
        switch (this.configuration.abflussOderWasserstand()) {
            case Q: {
                return "m\u00b3/s";
            }
            case W: {
                switch (this.configuration.wasserstandBezugsh\u00f6he()) {
                    case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                        return "cm";
                    }
                    case Meter\u00dcberNHNnachHS170: {
                        return "NHN+m (HS170)";
                    }
                }
                throw new IllegalArgumentException(this.configuration.wasserstandBezugsh\u00f6he().toString());
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.configuration.abflussOderWasserstand());
    }

    public String buchstabe() {
        switch (this.configuration.abflussOderWasserstand()) {
            case Q: {
                return "Q";
            }
            case W: {
                return "W";
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.configuration.abflussOderWasserstand());
    }

    public String \u00fcberschriftLinksObenDGJ() {
        switch (this.configuration.abflussOderWasserstand()) {
            case Q: {
                return "DGJ - Abfl\u00fcsse";
            }
            case W: {
                return "DGJ - Wasserst\u00e4nde";
            }
        }
        throw new IllegalStateException("Unexpected value: " + this.configuration.abflussOderWasserstand());
    }

    public String bemerkungen() {
        return this.bemerkungen;
    }

    private String compileBemerkungen(Jahrbuchseite data, HauptwerteRenderModel hauptwerte) {
        ArrayList<String> lines = new ArrayList<String>();
        String outageYearsComment = data.configuration().modus().equals((Object)JahrbuchModus.nachRichtlinie) ? data.outageYears().comment() : data.outageYears().commentAnalog();
        String zeroPointChangesComment = data.zeroPointChanges().comment();
        String HHundNN = hauptwerte.HH() + ";   " + hauptwerte.NN() + "  (Zeitreihe von " + this.formatiertesDatum(data.anfangDerAufzeichnungen()) + " bis " + this.formatiertesDatum(this.configuration.sp\u00e4testerBetrachteterZeitpunkt()) + ")";
        this.addIfNotEmpty(lines, data.allgemeineBemerkung());
        this.addIfNotEmpty(lines, outageYearsComment);
        this.addIfNotEmpty(lines, zeroPointChangesComment);
        this.addIfNotEmpty(lines, HHundNN);
        return Format.join(lines, "\n");
    }

    private String formatiertesDatum(DateTime anfangDerAufzeichnungen) {
        return new WertFormatierer("").datum(anfangDerAufzeichnungen);
    }

    private void addIfNotEmpty(List<String> lines, String outageYearsComment) {
        if (JahrbuchseiteRenderModel.isNotEmpty(outageYearsComment)) {
            lines.add(outageYearsComment);
        }
    }

    private static boolean isNotEmpty(String text) {
        return null != text && text.length() != 0;
    }

    public TageswerteRenderModel tageswerte() {
        return this.tageswerteRenderModel;
    }
}

