/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Dauertabelle;
import luwa.marlin.ship_library.model.Dauerzahlen;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;

public class DauertabelleRenderModel {
    private final Kalenderjahr kalenderjahr;
    private final Abflussjahr abflussjahr;
    private final Abflussjahresreihe abflussjahresreihe;
    private final Dauertabelle dauertabelle;
    private final AbflussOderWasserstand abflussOderWasserstand;
    private final Map<Spalte, Map<String, String>> modelDGJ;
    private final Map<Spalte, Map<String, String>> model;
    private final WertFormatierer formatierteWerte;

    public DauertabelleRenderModel(Kalenderjahr kalenderjahr, Abflussjahr abflussjahr, Abflussjahresreihe abflussjahresreihe, Dauertabelle dauertabelle, AbflussOderWasserstand abflussOderWasserstand) {
        this(kalenderjahr, abflussjahr, abflussjahresreihe, dauertabelle, abflussOderWasserstand, new WertFormatierer("-"));
    }

    public DauertabelleRenderModel(Kalenderjahr kalenderjahr, Abflussjahr abflussjahr, Abflussjahresreihe abflussjahresreihe, Dauertabelle dauertabelle, AbflussOderWasserstand abflussOderWasserstand, WertFormatierer wertFormatierer) {
        this.formatierteWerte = wertFormatierer;
        this.kalenderjahr = kalenderjahr;
        this.abflussjahr = abflussjahr;
        this.abflussjahresreihe = abflussjahresreihe;
        this.dauertabelle = dauertabelle;
        this.abflussOderWasserstand = abflussOderWasserstand;
        this.modelDGJ = this.createModel(Dauerzahlen.NachDGJ);
        this.model = this.createModel(Dauerzahlen.AlleTage);
    }

    public DauertabelleRenderModel(Jahrbuchseite data, WertFormatierer wertFormatierer) {
        this(data.configuration().kalenderjahr(), data.configuration().abflussjahr(), data.configuration().hydrologicalYearsRange(), data.dauertabelle(), data.configuration().abflussOderWasserstand(), wertFormatierer);
    }

    public Map<String, String> model(Spalte spalte) {
        return this.model(spalte, Dauerzahlen.NachDGJ);
    }

    public Map<String, String> model(Spalte spalte, Dauerzahlen dauerzahlen) {
        switch (dauerzahlen) {
            case AlleTage: {
                return this.model.get((Object)spalte);
            }
            case NachDGJ: {
                return this.modelDGJ.get((Object)spalte);
            }
        }
        throw new IllegalArgumentException(dauerzahlen.toString());
    }

    private Map<String, String> formatierteDauertabelle(Kalenderjahr jahr, Map<Integer, Optional<Double>> tabelle, Dauerzahlen dauerzahlen) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Integer> tage = dauerzahlen.dauerzahlenInTagen(jahr);
        if (!jahr.istSchaltjahr()) {
            result.put("(365)", "");
        }
        for (Integer tag : tage) {
            result.put(Dauertabelle.stringF\u00fcrTag(tag), this.formatierteWerte.nurSignifikanteStellen(tabelle.containsKey(tag) ? tabelle.get(tag) : Optional.empty(), this.QoderW()));
        }
        return result;
    }

    private Map<Spalte, Map<String, String>> createModel(Dauerzahlen dauerzahlen) {
        return Map.ofEntries(Map.entry(Spalte.abflussjahr, this.createModel(Spalte.abflussjahr, dauerzahlen)), Map.entry(Spalte.kalenderjahr, this.createModel(Spalte.kalenderjahr, dauerzahlen)), Map.entry(Spalte.obereH\u00fcllwerte, this.createModel(Spalte.obereH\u00fcllwerte, dauerzahlen)), Map.entry(Spalte.mittlereWerte, this.createModel(Spalte.mittlereWerte, dauerzahlen)), Map.entry(Spalte.untereH\u00fcllwerte, this.createModel(Spalte.untereH\u00fcllwerte, dauerzahlen)));
    }

    private Map<String, String> createModel(Spalte spalte, Dauerzahlen dauerzahlen) {
        return this.formatierteDauertabelle(this.kalenderjahr, spalte.values(this.dauertabelle, this.abflussjahr, this.kalenderjahr, this.abflussjahresreihe, this.QoderW(), dauerzahlen), dauerzahlen);
    }

    private AbflussOderWasserstand QoderW() {
        return this.abflussOderWasserstand;
    }

    public static Iterable<String> tage() {
        return DauertabelleRenderModel.tage(Dauerzahlen.NachDGJ);
    }

    public static Iterable<String> tage(Dauerzahlen dauerzahlen) {
        List<String> tage = dauerzahlen.dauerzahlenInTagenImGemeinjahr().stream().map(Object::toString).collect(Collectors.toList());
        tage.add(0, "(365)");
        return tage;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Spalte {
        abflussjahr{

            @Override
            Map<Integer, Optional<Double>> values(Dauertabelle dauertabelle, Abflussjahr abflussjahr, Kalenderjahr kalenderjahr, Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
                return dauertabelle.dauertabelleNachRichtlinie(abflussjahr, QoderW, dauerzahlen);
            }
        }
        ,
        kalenderjahr{

            @Override
            Map<Integer, Optional<Double>> values(Dauertabelle dauertabelle, Abflussjahr abflussjahr, Kalenderjahr kalenderjahr, Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
                return dauertabelle.dauertabelleNachRichtlinie(kalenderjahr, QoderW, dauerzahlen);
            }
        }
        ,
        obereH\u00fcllwerte{

            @Override
            Map<Integer, Optional<Double>> values(Dauertabelle dauertabelle, Abflussjahr abflussjahr, Kalenderjahr kalenderjahr, Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
                return dauertabelle.obereH\u00fcllwerteNachRichtlinie(abflussjahresreihe, QoderW, dauerzahlen);
            }
        }
        ,
        mittlereWerte{

            @Override
            Map<Integer, Optional<Double>> values(Dauertabelle dauertabelle, Abflussjahr abflussjahr, Kalenderjahr kalenderjahr, Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
                return dauertabelle.mittlereWerteNachRichtlinie(abflussjahresreihe, QoderW, dauerzahlen);
            }
        }
        ,
        untereH\u00fcllwerte{

            @Override
            Map<Integer, Optional<Double>> values(Dauertabelle dauertabelle, Abflussjahr abflussjahr, Kalenderjahr kalenderjahr, Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
                return dauertabelle.untereH\u00fcllwerteNachRichtlinie(abflussjahresreihe, QoderW, dauerzahlen);
            }
        };


        abstract Map<Integer, Optional<Double>> values(Dauertabelle var1, Abflussjahr var2, Kalenderjahr var3, Abflussjahresreihe var4, AbflussOderWasserstand var5, Dauerzahlen var6);
    }
}

