/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.util.math;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.value.TimestampedValue;

public class MaxFinder<V extends TimestampedValue> {
    private final List<V> maxima;
    private Optional<V> max;
    private final Comparator<V> comparator;

    public MaxFinder() {
        this(Comparator.naturalOrder());
    }

    public MaxFinder(Comparator<V> comparator) {
        this.comparator = comparator;
        this.maxima = new ArrayList<V>();
        this.max = Optional.empty();
    }

    public MaxFinder(Stream<V> values) {
        this();
        values.forEach(this::add);
    }

    public MaxFinder<V> add(V value) {
        if (null == value || ((TimestampedValue)value).istL\u00fccke()) {
            return this;
        }
        if (this.max.isEmpty()) {
            this.max = Optional.of(value);
            this.maxima.add(value);
            return this;
        }
        if (this.comparator.compare(value, (TimestampedValue)this.max.get()) > 0) {
            this.max = Optional.of(value);
            this.maxima.clear();
            this.maxima.add(value);
            return this;
        }
        if (this.comparator.compare(value, (TimestampedValue)this.max.get()) == 0) {
            this.maxima.add(value);
            return this;
        }
        return this;
    }

    public MaxFinder<V> add(MaxFinder<V> maxFinder) {
        return this.addAll(maxFinder.maxima());
    }

    public MaxFinder<V> addAll(Iterable<V> values) {
        for (TimestampedValue value : values) {
            this.add(value);
        }
        return this;
    }

    public List<V> maxima() {
        return this.maxima;
    }

    public Optional<V> max() {
        return this.max;
    }
}

