/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.util;

import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Day;

public class OptionalMitMarkierung<T extends TimestampedValue> {
    private final Optional<TimestampedValue> timestampedValue;
    private final boolean mehrfach;
    private final boolean erg\u00e4nzt;

    public OptionalMitMarkierung(T timestampedValue) {
        this(List.of(timestampedValue));
    }

    public OptionalMitMarkierung(List<T> timestampedValues) {
        this(timestampedValues, false);
    }

    public OptionalMitMarkierung(List<T> timestampedValues, boolean erg\u00e4nzt) {
        TimestampedValue timestampedValue;
        this.timestampedValue = timestampedValues.isEmpty() ? Optional.empty() : ((timestampedValue = (TimestampedValue)timestampedValues.get(0)).istL\u00fccke() ? Optional.empty() : Optional.of(timestampedValue));
        this.mehrfach = timestampedValues.size() > 1;
        this.erg\u00e4nzt = erg\u00e4nzt;
    }

    public boolean mehrfach() {
        return this.mehrfach;
    }

    public Optional<TimestampedValue> timestampedValue() {
        return this.timestampedValue;
    }

    public Optional<Integer> day() {
        return this.timestampedValue.map(value -> value.timestamp().getDayOfMonth());
    }

    public Optional<Integer> jahr() {
        if (this.timestampedValue.isPresent()) {
            if (this.timestampedValue.get().timestamp() == null) {
                return Optional.empty();
            }
            return Optional.of(this.timestampedValue.get().timestamp().getYear());
        }
        return Optional.empty();
    }

    public Optional<Day> tagDesAuftretens() {
        if (this.timestampedValue.isPresent() && this.timestampedValue.get().timestamp == null) {
            return Optional.empty();
        }
        return this.timestampedValue().map(timestampedValue -> new Day(timestampedValue.timestamp()));
    }

    public Optional<Integer> tagDesMonats() {
        return this.timestampedValue.map(value -> value.timestamp().getDayOfMonth());
    }

    public Optional<Double> value() {
        return this.timestampedValue.map(TimestampedValue::wert);
    }

    public boolean erg\u00e4nzt() {
        return this.erg\u00e4nzt;
    }
}

