/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;

public final class HTTPRequest {
    public static final String defaultProxyHost = "";
    public static final int defaultProxyPort = 8080;

    private HTTPRequest() {
    }

    public static byte[] getWithDefaultProxy(String urlString) throws IOException {
        return HTTPRequest.get(urlString, defaultProxyHost, 8080);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] get(String urlString, String proxyHost, int proxyPort) throws IOException {
        boolean withProxy = proxyHost != null && !proxyHost.isEmpty();
        System.out.println("HTTP GET: " + urlString);
        if (withProxy) {
            System.out.println("Proxy: " + proxyHost + ":" + proxyPort);
        }
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int bytesRead;
            URL url = new URL(urlString);
            if (withProxy) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                connection = (HttpURLConnection)url.openConnection(proxy);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP request failed with response code: " + responseCode);
            }
            inputStream = connection.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

