/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.tool.extremwerte.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import luwa.marlin.ship_library.tool.extremwerte.Konfiguration;
import luwa.marlin.ship_library.tool.extremwerte.repository.KonfigurationRepository;
import luwa.marlin.sql.SqlHelpers;

public class SQLKonfigurationRepository
implements KonfigurationRepository {
    private final Connection connection;

    public SQLKonfigurationRepository(Connection connection) {
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Konfiguration> konfiguration() {
        try (PreparedStatement query = this.connection.prepareStatement("select * from ex_hvz_extremwerte");
             ResultSet rs = query.executeQuery();){
            if (!rs.next()) return Optional.empty();
            int jahrVon = rs.getInt("referenz_jahr_von");
            int jahrBis = rs.getInt("referenz_jahr_bis");
            String ausgabeverzeichnis = SqlHelpers.getNullSafeString(rs, "ausgabe_verzeichnis");
            Optional<Konfiguration> optional = Optional.of(new Konfiguration(jahrVon, jahrBis, ausgabeverzeichnis));
            return optional;
        }
        catch (SQLException e2) {
            throw new RuntimeException("Konnte Konfiguration f\u00fcr HVZ-Extremwerteexport nicht laden");
        }
    }
}

