/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.tool.extremwerte;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import luwa.marlin.database.PegeldatenDatenbank;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.JahrbuchModus;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.repository.sql.SQLDatenRepository;
import luwa.marlin.ship_library.tool.extremwerte.Konfiguration;
import luwa.marlin.ship_library.tool.extremwerte.repository.SQLKonfigurationRepository;
import luwa.marlin.ship_library.view.ExtremwerteRenderModel;
import luwa.marlin.ship_library.view.JahrbuchseiteRenderModel;

public class ExtremwerteHVZ {
    private final Messstelle messstelle;
    private final JahrbuchseiteRenderModel model;
    private static final String spaltentrennzeichen = "\t";

    public ExtremwerteHVZ(Jahrbuchseite data) {
        this.messstelle = data.messstelle();
        this.model = new JahrbuchseiteRenderModel(data);
    }

    public static void main(String[] args) throws Exception {
        DataSource dataSource = PegeldatenDatenbank.fromSystemEnvironment().createAsDataSource();
        try (Connection connection = dataSource.getConnection();){
            SQLDatenRepository dataProvider = new SQLDatenRepository(connection);
            AbflussOderWasserstand parameter = AbflussOderWasserstand.Q;
            Konfiguration konfiguration = new SQLKonfigurationRepository(connection).konfiguration().orElseThrow(() -> new RuntimeException("Keine Konfiguration f\u00fcr den HVZ-Extremwerteexport in der Datenbank gefunden."));
            Optional<Integer> jahr = Optional.of(konfiguration.referenzZeitraumJahrBis());
            List<Long> pegel = dataProvider.alleAktivenUndTeilaktivenPegel();
            Path dateipfad = konfiguration.ausgabeverzeichnis().resolve(ExtremwerteHVZ.dateinameF\u00fcr(parameter));
            try (PrintStream ausgabe = new PrintStream(Files.newOutputStream(dateipfad, new OpenOption[0]));){
                ExtremwerteHVZ.schreibePegel(ausgabe, dataProvider, konfiguration, parameter, jahr, pegel);
            }
        }
    }

    private static String dateinameF\u00fcr(AbflussOderWasserstand parameter) {
        String NNx = "NN" + parameter.symbol();
        String zusatz = parameter == AbflussOderWasserstand.Q ? " historisch" : "";
        String zeitstempel = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(ZonedDateTime.now());
        return NNx + zusatz + " " + zeitstempel + ".csv";
    }

    private static void schreibePegel(PrintStream out, SQLDatenRepository dataProvider, Konfiguration konfiguration, AbflussOderWasserstand parameter, Optional<Integer> jahr, List<Long> pegel) {
        boolean mit\u00dcberschriften = true;
        int n2 = 1;
        int total = pegel.size();
        for (Long messstellenNummer : pegel) {
            System.out.println(n2 + " / " + total);
            try {
                JahrbuchseitenConfiguration jahrbuchseitenConfig = new JahrbuchseitenConfiguration(messstellenNummer, Optional.empty(), konfiguration.referenzZeitraumJahrVon(), konfiguration.referenzZeitraumJahrBis(), parameter, JahrbuchModus.nachRichtlinie, jahr);
                Jahrbuchseite jahrbuchseite = new Jahrbuchseite(jahrbuchseitenConfig, dataProvider);
                ExtremwerteHVZ extremwerte = new ExtremwerteHVZ(jahrbuchseite);
                extremwerte.writeTo(out, mit\u00dcberschriften);
            }
            catch (Exception e2) {
                System.err.println("Konnte Pegel " + messstellenNummer + " nicht verarbeiten.");
                e2.printStackTrace(System.err);
            }
            mit\u00dcberschriften = false;
            ++n2;
        }
    }

    public void writeTo(PrintStream out, boolean mit\u00dcberschriften) {
        ExtremwerteRenderModel extremwerte = this.model.extremwerte();
        ExtremwerteRenderModel.HochOderNiedrigwasser niedrigwasser = ExtremwerteRenderModel.HochOderNiedrigwasser.Niedrigwasser;
        List spalten = extremwerte.spalten().stream().filter(spalte -> spalte != ExtremwerteRenderModel.Spalte.Spende).collect(Collectors.toList());
        if (mit\u00dcberschriften) {
            List<String> spalten\u00fcberschriften = Stream.concat(Stream.of("Messtellen-Nr.", "Standort", "Gew\u00e4sser", "Messnetz", "Rang"), spalten.stream().map(extremwerte::header)).collect(Collectors.toList());
            ExtremwerteHVZ.schreibeZeile(out, spalten\u00fcberschriften);
        }
        int n2 = 1;
        while (n2 <= 10) {
            List<String> messtelle = List.of(String.valueOf(this.messstelle.nummer()), this.messstelle.standort(), this.messstelle.gew\u00e4sser(), this.messstelle.messnetz());
            ArrayList<String> zeile = new ArrayList<String>(messtelle);
            zeile.add(String.valueOf(n2));
            int finalN = n2++;
            zeile.addAll(spalten.stream().map(spalte -> extremwerte.model(niedrigwasser, (ExtremwerteRenderModel.Spalte)((Object)spalte)).get(finalN)).collect(Collectors.toList()));
            out.println(String.join((CharSequence)spaltentrennzeichen, zeile));
        }
    }

    private static void schreibeZeile(PrintStream out, List<String> eintr\u00e4ge) {
        out.println(String.join((CharSequence)spaltentrennzeichen, eintr\u00e4ge));
    }
}

